<?php

namespace App\Mail;

use App\Models\Empresa;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class LimiteUsoNotificacao extends Mailable
{
    use Queueable, SerializesModels;

    public $empresa;
    public $tipoLimite;
    public $valorAtual;
    public $valorLimite;
    public $percentual;

    /**
     * Create a new message instance.
     *
     * @param Empresa $empresa
     * @param string $tipoLimite
     * @param mixed $valorAtual
     * @param mixed $valorLimite
     * @return void
     */
    public function __construct(Empresa $empresa, $tipoLimite, $valorAtual, $valorLimite)
    {
        $this->empresa = $empresa;
        $this->tipoLimite = $tipoLimite;
        $this->valorAtual = $valorAtual;
        $this->valorLimite = $valorLimite;
        
        // Calcula o percentual de uso
        if ($valorLimite > 0) {
            $this->percentual = round(($valorAtual / $valorLimite) * 100, 2);
        } else {
            $this->percentual = 0;
        }
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $tipoFormatado = ucfirst($this->tipoLimite);
        
        return $this->subject("Alerta: Limite de {$tipoFormatado} Atingido - {$this->empresa->razao_social}")
            ->markdown('emails.empresas.limite-uso')
            ->with([
                'empresa' => $this->empresa,
                'tipoLimite' => $this->tipoLimite,
                'valorAtual' => $this->valorAtual,
                'valorLimite' => $this->valorLimite,
                'percentual' => $this->percentual,
                'dataAlerta' => now()->format('d/m/Y H:i:s'),
                'linkAdmin' => url('/empresas/' . $this->empresa->id)
            ]);
    }
} 