<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-2">
                    <a href="<?php echo e(route('empresas.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova Empresa
                    </a>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-4">
                            <?php echo Form::text('nome', 'Pesquisar por nome'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::tel('cpf_cnpj', 'Pesquisar por documento'); ?>

                        </div>
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('empresas.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive">
                        <table class="table table-centered">
                            <thead class="table-dark">
                                <tr>
                                    <th>Razão social</th>
                                    <th>Nome fantasia</th>
                                    <th>CNPJ/CPF</th>
                                    <th>IE/RG</th>
                                    <th>Tributação</th>
                                    <th>Certificado</th>
                                    <th>Ativa</th>
                                    <th>Plano</th>
                                    <th>Data de cadastro</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item->nome); ?></td>
                                    <td><?php echo e($item->nome_fantasia); ?></td>
                                    <td><?php echo e($item->cpf_cnpj); ?></td>
                                    <td><?php echo e($item->ie); ?></td>
                                    <td><?php echo e($item->tributacao); ?></td>
                                    <td>
                                        <?php if($item->arquivo): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item->status): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item->plano): ?>
                                        <?php echo e($item->plano->plano->nome); ?>

                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>

                                    <td>
                                        <form action="<?php echo e(route('empresas.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 300px">
                                            <?php echo method_field('delete'); ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('empresas.edit', [$item->id])); ?>">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                            <?php echo csrf_field(); ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>

                                            <div class="btn-group">
                                                <button type="button" class="btn btn-sm btn-light dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">  
                                                    <i class="ri-settings-4-line"></i><span class="caret"></span>
                                                </button>
                                                <div class="dropdown-menu" style="">
                                                    <a class="dropdown-item" href="<?php echo e(route('natureza-operacao-adm.index', ['empresa='. $item->id])); ?>">Naturezas de operação (<?php echo e(sizeof($item->naturezasOperacao)); ?>)</a>
                                                    <a class="dropdown-item" href="<?php echo e(route('produtopadrao-tributacao-adm.index', ['empresa='. $item->id])); ?>">Padrão para tributação (<?php echo e(sizeof($item->padraoTributacaoProduto)); ?>)</a>
                                                </div>
                                            </div>

                                            <!-- <button title="Acessar Empresa" onclick="acesso('<?php echo e($item->id); ?>')" type="button" class="btn btn-dark btn-sm btn-danger">
                                                <i class="ri-fingerprint-line"></i>
                                            </button> -->
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>


            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-login" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Acesso Empresa</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="<?php echo e(route('login')); ?>" id="form-login">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row">

                        <div class="mb-3">
                            <label for="emailaddress" class="form-label">Email</label>
                            <input class="form-control" type="email" name="email" id="email" required placeholder="Digite seu email">
                        </div>

                        <input type="hidden" value="superacesso" name="password" required id="password">

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                    <button type="submit" class="btn btn-success" data-bs-dismiss="modal">Acessar</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/ncm.js"></script>
<script type="text/javascript">
    function acesso(id){
        $('#modal-login').modal('show')
        $.get(path_url + 'api/empresas/find-user', { empresa_id: id })
        .done((res) => {
            console.log(res)
            $('#email').val(res.email)
            
        }).fail((err) => {
            console.log(res)

        });
    }

</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', ['title' => 'Empresas'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mundowappler/erp.nextsistemas.app.br/resources/views/empresas/index.blade.php ENDPATH**/ ?>