<?php $__env->startSection('content'); ?>

<div class="content d-flex flex-column flex-column-fluid" id="kt_content">

	<div class="container <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
		<div class="card card-custom gutter-b example example-compact">
			<div class="col-lg-12">
				<!--begin::Portlet-->

				<form method="post" action="/empresas/update">

					<input type="hidden" name="id" value="<?php echo e($empresa->id); ?>">
					<div class="card card-custom gutter-b example example-compact">
						<div class="card-header">
							<h3 class="card-title">Dados da Empresa</h3>
						</div>
					</div>
					<?php echo csrf_field(); ?>

					<div class="row">
						<div class="col-xl-12">
							<div class="kt-section kt-section--first">
								<div class="kt-section__body">

									<div class="row">
										<div class="form-group validated col-sm-10 col-lg-6">
											<label class="col-form-label">Nome</label>
											<div class="">
												<input id="nome" type="text" class="form-control <?php if($errors->has('nome')): ?> is-invalid <?php endif; ?>" name="nome" value="<?php echo e($empresa->nome); ?>">
												<?php if($errors->has('nome')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('nome')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="form-group validated col-sm-6 col-lg-5">
											<label class="col-form-label" id="lbl_ie_rg">Rua</label>
											<div class="">
												<input type="text" id="rua" class="form-control <?php if($errors->has('rua')): ?> is-invalid <?php endif; ?>" name="rua" value="<?php echo e($empresa->rua); ?>">
												<?php if($errors->has('rua')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('rua')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-3 col-lg-2">
											<label class="col-form-label" id="lbl_ie_rg">Nº</label>
											<div class="">
												<input type="text" id="numero" class="form-control <?php if($errors->has('numero')): ?> is-invalid <?php endif; ?>" name="numero" value="<?php echo e($empresa->numero); ?>">
												<?php if($errors->has('numero')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('numero')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-4 col-lg-3">
											<label class="col-form-label" id="lbl_ie_rg">Bairro</label>
											<div class="">
												<input type="text" id="bairro" class="form-control <?php if($errors->has('bairro')): ?> is-invalid <?php endif; ?>" name="bairro" value="<?php echo e($empresa->bairro); ?>">
												<?php if($errors->has('bairro')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('bairro')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-4 col-lg-4">
											<label class="col-form-label" id="lbl_ie_rg">Cidade</label>
											<div class="">
												<input type="text" id="cidade" class="form-control <?php if($errors->has('cidade')): ?> is-invalid <?php endif; ?>" name="cidade" value="<?php echo e($empresa->cidade); ?>">
												<?php if($errors->has('cidade')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('cidade')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-4 col-lg-4">
											<label class="col-form-label" id="lbl_ie_rg">
												
												<?php if(strlen($empresa->cnpj) == 14): ?>
												CPF
												<?php else: ?>
												CNPJ
												<?php endif; ?>
											</label>
											<div class="">
												<input type="text" <?php if(strlen($empresa->cnpj) == 14): ?> id="cpf" <?php else: ?> d="cnpj" <?php endif; ?> class="form-control <?php if($errors->has('cnpj')): ?> is-invalid <?php endif; ?>" name="cnpj" value="<?php echo e($empresa->cnpj); ?>">
												<?php if($errors->has('cnpj')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('cnpj')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-4 col-lg-4">
											<label class="col-form-label" id="lbl_ie_rg">Email</label>
											<div class="">
												<input type="text" id="email" class="form-control <?php if($errors->has('email')): ?> is-invalid <?php endif; ?>" name="email" value="<?php echo e($empresa->email); ?>">
												<?php if($errors->has('email')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('email')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										

										<div class="form-group validated col-sm-4 col-lg-4">
											<label class="col-form-label" id="lbl_ie_rg">Telefone</label>
											<div class="">
												<input type="text" id="telefone" class="form-control <?php if($errors->has('telefone')): ?> is-invalid <?php endif; ?>" name="telefone" value="<?php echo e($empresa->telefone); ?>">
												<?php if($errors->has('telefone')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('telefone')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										
										<div class="form-group validated col-sm-6 col-lg-2">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Status</label>
											<div class="col-6">
												<span class="switch switch-outline switch-primary">
													<label>
														<input value="true" <?php if($empresa->status): ?> checked <?php endif; ?> type="checkbox" name="status" id="status">
														<span></span>
													</label>
												</span>
											</div>
										</div>

										<div class="form-group validated col-sm-6 col-lg-5">
											<label class="col-form-label" id="lbl_ie_rg">Informação do contador</label>
											<button type="button" class="btn btn-light-info btn-sm btn-icon col-lg-6 col-sm-6" data-toggle="popover" data-trigger="click" data-content="Campo opcional de informação do contador nome, contato, email, etc..."><i class="la la-info"></i></button>
											<div class="">
												<input type="text" id="info_contador" class="form-control <?php if($errors->has('info_contador')): ?> is-invalid <?php endif; ?>" name="info_contador" value="<?php echo e($empresa->info_contador); ?>">
												<?php if($errors->has('info_contador')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('info_contador')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="row">
											<div class="form-group validated col-sm-12">

												<label class="col-3 col-form-label">Permissão de Acesso:</label>

												<?php if(sizeof($perfis) > 0): ?>
												<div class="form-group validated col-sm-4 col-lg-4">
													<label class="col-form-label" id="lbl_ie_rg">Perfil</label>
													<div class="">
														<select id="perfil-select" class="custom-select" name="perfil_id">
															<option value="0">--</option>
															<?php $__currentLoopData = $perfis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option 
															<?php if($empresa->perfil_id == $p->id): ?>
															selected
															<?php endif; ?>
															value="<?php echo e($p); ?>">
															<?php echo e($p->nome); ?>

														</option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>
												</div>
											</div>
											<?php endif; ?>
											
											<input type="hidden" id="menus" value="<?php echo e(json_encode($menu)); ?>" name="">
											<?php $__currentLoopData = $menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<div class="col-12 col-form-label">
												<span>
													<label class="checkbox checkbox-info">
														<input id="todos_<?php echo e($m['titulo']); ?>" onclick="marcarTudo('<?php echo e($m['titulo']); ?>')" type="checkbox">
														<span></span><strong class="text-info" style="margin-left: 5px; font-size: 16px;"><?php echo e($m['titulo']); ?> </strong>
													</label>
												</span>
												<div class="checkbox-inline" style="margin-top: 10px;">
													<?php $__currentLoopData = $m['subs']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

													<?php if($s['nome'] != 'NFS-e'): ?>

													<?php
													$link = str_replace('/', '', $s['rota']);
													$link = str_replace('.', '_', $link);
													$link = str_replace(':', '_', $link);

													?>
													<!-- <label class="checkbox checkbox-info check-sub">
														<input id="sub_<?php echo e($link); ?>" <?php if(in_array($s['rota'], $permissoesAtivas)): ?> checked <?php endif; ?> type="checkbox" name="<?php echo e($s['rota']); ?>">
														<span></span><?php echo e($s['nome']); ?>


													</label> -->

													<label class="checkbox checkbox-info check-sub">
														<input id="sub_<?php echo e($link); ?>" <?php if(\App\Models\Empresa::validaLink($s['rota'], $permissoesAtivas)): ?> checked <?php endif; ?> type="checkbox" name="<?php echo e($s['rota']); ?>">
														<span></span><?php echo e($s['nome']); ?>


													</label>
													<?php endif; ?>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</div>

											</div>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<div class="card-footer">
					<div class="row">
						<div class="col-xl-2">

						</div>
						<div class="col-lg-3 col-sm-6 col-md-4">
							<a style="width: 100%" class="btn btn-danger" href="/empresas">
								<i class="la la-close"></i>
								<span class="">Cancelar</span>
							</a>
						</div>
						<div class="col-lg-3 col-sm-6 col-md-4">
							<button style="width: 100%" type="submit" class="btn btn-success">
								<i class="la la-check"></i>
								<span class="">Salvar</span>
							</button>
						</div>

					</div>
				</div>
			</form>
		</div>

	</div>
</div>
</div>

<div class="container <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight" style="margin-top: -30px;">
	<div class="card card-custom gutter-b example example-compact">
		<div class="col-lg-12">
			<div class="card card-custom gutter-b example example-compact">

			</div>
			<div class="row">

				<div class="col-xl-12">

					<div class="row">

						<div class="col-sm-4 col-lg-4 col-md-4 col-12">

							<div class="card card-custom gutter-b">
								<div class="card-header">
									<h3 class="card-title">
										Total de Cadastros
									</h3>
								</div>
								<div class="card-body" style="height: 200px;">

									<h4>Clientes: <strong class="text-info"><?php echo e(sizeof($empresa->clientes)); ?></strong></h4>
									<h4>Fornecedores: <strong class="text-info"><?php echo e(sizeof($empresa->fornecedores)); ?></strong></h4>
									<h4>Produtos: <strong class="text-info"><?php echo e(sizeof($empresa->produtos)); ?></strong></h4>
									<h4>Usuários: <strong class="text-info"><?php echo e(sizeof($empresa->usuarios)); ?></strong></h4>
									<h4>Veiculos: <strong class="text-info"><?php echo e(sizeof($empresa->veiculos)); ?></strong></h4>
								</div>
							</div>
						</div>
						<div class="col-sm-4 col-lg-4 col-md-4 col-12">

							<div class="card card-custom gutter-b">
								<div class="card-header">
									<h3 class="card-title">
										Total de Documentos
									</h3>
								</div>
								<div class="card-body" style="height: 200px;">

									<h4>NF-e: <strong class="text-info"><?php echo e($empresa->nfes()); ?></strong></h4>
									<h4>NFC-e: <strong class="text-info"><?php echo e($empresa->nfces()); ?></strong></h4>
									<h4>CT-e: <strong class="text-info"><?php echo e($empresa->ctes()); ?></strong></h4>
									<h4>MDF-e: <strong class="text-info"><?php echo e($empresa->mdfes()); ?></strong></h4>
								</div>
							</div>
						</div>

						<div class="col-sm-4 col-lg-4 col-md-4 col-12">
							<div class="card card-custom gutter-b">
								<div class="card-header">
									<h3 class="card-title">
										Registros
									</h3>
								</div>
								<div class="card-body" style="height: 200px;">

									<h4>Vendas: <strong class="text-info"><?php echo e(sizeof($empresa->vendas)); ?></strong></h4>
									<h4>Vendas PDV: <strong class="text-info"><?php echo e(sizeof($empresa->vendasCaixa)); ?></strong></h4>
								</div>
							</div>
						</div>

					</div>
					<div class="row">
						<div class="form-group validated col-sm-6 col-lg-6">
							<div class="">

								<a href="/empresas/alterarSenha/<?php echo e($empresa->id); ?>" class="btn btn-danger">
									<i class="la la-key"></i> Alterar Senhas de usuários
								</a>
							</div>
						</div>
						<div class="col-sm-6 col-lg-6">
							<h3 class="text-success">Data de cadastro: <?php echo e(\Carbon\Carbon::parse($empresa->created_at)->format('d/m/Y H:i:s')); ?></h3>
						</div>
					</div>

					<div class="row">
						<div class="col-sm-12 col-lg-12">
							<h3 class="">Plano atual: 

								<?php if(!$empresa->planoEmpresa): ?>
								<a href="/empresas/setarPlano/<?php echo e($empresa->id); ?>" class="btn btn-info">
									Atribuir plano
								</a>
								<?php else: ?>
								<span class="text-info"><?php echo e($empresa->planoEmpresa->plano->nome); ?> R$ <?php echo e($empresa->planoEmpresa->plano->valor); ?></span>
								- Data de expiração: <span class="<?php if($planoExpirado): ?> text-danger <?php else: ?> text-info <?php endif; ?>">
									<?php if($empresa->planoEmpresa->expiracao != '0000-00-00'): ?>
									<?php echo e(\Carbon\Carbon::parse($empresa->planoEmpresa->expiracao)->format('d/m/Y')); ?>

									<?php else: ?>
									Indeterminado
									<?php endif; ?>
								</span>
								<?php endif; ?>

								<?php if($planoExpirado): ?>
								<a target="" href="/empresas/setarPlano/<?php echo e($empresa->id); ?>" class="btn btn-danger">
									Atribuir plano
								</a>
								<?php else: ?>
								<?php if($empresa->planoEmpresa): ?>
								<a target="" href="/empresas/setarPlano/<?php echo e($empresa->id); ?>" class="btn btn-warning">
									Alterar plano
								</a>
								<?php endif; ?>
								<?php endif; ?>
							</h3>
						</div>
					</div>

					<div class="row">
						<div class="col-sm-12 col-lg-12">
							<h3 class="">Contrato: 

								<?php if($empresa->contrato == null): ?>
								<a href="/contrato/gerarContrato/<?php echo e($empresa->id); ?>" class="btn btn-warning">
									Gerar contrato
								</a>
								<?php else: ?>

								<?php if($empresa->contrato->status == 0): ?>
								<span class="label label-xl label-inline label-light-danger">Não assinado</span>
								<?php else: ?>

								<span class="label label-xl label-inline label-light-success">
									<i class="la la-check"></i> Assinado
								</span>

								<a href="/contrato/download/<?php echo e($empresa->id); ?>" class="label label-xl label-inline label-light-info">
									<i class="la la-print"></i>
									Imprimir
								</a>
								<?php endif; ?>

								<?php endif; ?>
							</h3>
						</div>
					</div>

					<?php if(!$empresa->configNota): ?>
					<p class="text-danger">>>Esta empresa não possui os dados do emitente cadastrados</p>
					<?php endif; ?>
					<div class="row">
						<div class="col-sm-12">
							<a class="btn btn-info" href="/empresas/download/<?php echo e($empresa->id); ?>">
								<i class="la la-download"></i>
								Download Certificado
							</a>	
							
							<?php if($empresa->configNota): ?>
							<a class="btn btn-primary" href="/empresas/arquivosXml/<?php echo e($empresa->id); ?>">
								<i class="la la-file-code"></i>
								Arquivos Xml
							</a>
							<?php endif; ?>

							<a class="btn btn-warning" href="/empresas/configEmitente/<?php echo e($empresa->id); ?>">
								<i class="la la-id-card"></i>
								Configuração do Emitente
							</a>
						</div>
					</div>
					<br>

					<?php if(getenv("MIGRADOR")): ?>
					<div class="row">
						<div class="col-sm-4 col-lg-4">

							<a style="width: 100%;" href="/migrador/<?php echo e($empresa->id); ?>" class="btn btn-info">
								Migrador
							</a>
						</div>
					</div>
					<?php endif; ?>
					
					<br>
				</div>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/empresas/detalhes.blade.php ENDPATH**/ ?>