<?php $__env->startSection('content'); ?>

<style type="text/css">
    h3{
        font-size: 20px;
    }
</style>

<section class="shoping-cart" style="margin-top: -70px;">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">

                <input type="hidden" value="<?php echo e($pedido->transacao_id); ?>" id="transacao_id" name="">
                <input type="hidden" value="<?php echo e($pedido->status_pagamento); ?>" id="status" name="">
                

                <h2>Detalhes do seu pedido</h2>

                <?php if($pedido->status_pagamento == 'pending'): ?>
                <h3>PAGAMENTO: <strong class="text-warning">PENDENTE</strong></h3>
                <?php elseif($pedido->status_pagamento == 'approved'): ?>
                <h3>PAGAMENTO: <strong class="text-success">APROVADO</strong> - Transação ID: <strong class="text-primary"><?php echo e($pedido->transacao_id); ?></strong></h3>
                <?php else: ?>
                <h3>PAGAMENTO: <strong class="text-danger">CANCELADO/REJEITADO</strong></h3>
                <?php endif; ?>

                <h4>Estado:
                <?php if($pedido->status_preparacao == 0): ?>
                <span class="text-info">Novo</span>
                <?php elseif($pedido->status_preparacao == 1): ?>
                <span class="text-primary">Aprovado</span>
                <?php elseif($pedido->status_preparacao == 2): ?>
                <span class="text-danger">Cancelado</span>
                <?php elseif($pedido->status_preparacao == 3): ?>
                <span class="text-warning">Aguardando Envio</span>
                <?php elseif($pedido->status_preparacao == 4): ?>
                <span class="text-dark">Enviado</span>
                <?php else: ?>
                <span class="text-success">Entregue</span>
                <?php endif; ?>
                </h4>

                <br>

                <div class="shoping__cart__table">
                    <table>
                        <thead>
                            <tr>
                                <th class="shoping__product">Produto</th>
                                <th>Valor</th>
                                <th>Quantidade</th>
                                <th>SubTotal</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $pedido->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="shoping__cart__item">
                                    <a href="/loja/<?php echo e($default['config']->link); ?>/<?php echo e($i->produto->id); ?>/verProduto">
                                        <img height="40" src="/ecommerce/produtos/<?php echo e($i->produto->galeria[0]->img); ?>" alt="">
                                        <h5><?php echo e($i->produto->produto->nome); ?></h5>
                                    </a>
                                </td>
                                <td class="shoping__cart__price">
                                    R$ <?php echo e(number_format($i->produto->valor, 2, ',', '.')); ?>

                                </td>
                                <td class="shoping__cart__quantity">
                                    <strong><?php echo e($i->quantidade); ?></strong>
                                </td>
                                <td class="shoping__cart__total">
                                    R$ <?php echo e(number_format($i->quantidade*$i->produto->valor, 2, ',', '.')); ?>

                                </td>
                                <td class="shoping__cart__item__close">

                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="shoping__cart__btns">

                </div>
            </div>
            <input type="hidden" value="<?php echo e(csrf_token()); ?>" id="token">


            <div class="col-lg-6">
                <div class="shoping__checkout">
                    <h5>Endereço</h5>
                    <ul>
                        <li>

                            <h6>Rua: 
                                <strong>
                                    <?php echo e($pedido->endereco->rua); ?>, <?php echo e($pedido->endereco->numero); ?>

                                </strong>
                            </h6>
                            <h6>Bairro: 
                                <strong>
                                    <?php echo e($pedido->endereco->bairro); ?>

                                </strong>
                            </h6>
                            <h6>CEP: 
                                <strong>
                                    <?php echo e($pedido->endereco->cep); ?>

                                </strong>
                            </h6>

                            <h6>Cidade: 
                                <strong>
                                    <?php echo e($pedido->endereco->cidade); ?> (<?php echo e($pedido->endereco->uf); ?>)
                                </strong>
                            </h6>

                            <?php if($pedido->codigo_rastreio != ""): ?>
                            <h6>Código de rastreamento: 
                                <strong class="text-info">
                                    <?php echo e($pedido->codigo_rastreio); ?>

                                </strong>
                            </h6>
                            <?php endif; ?>
                        </li>

                    </ul>

                </div>
            </div>

            <div class="col-lg-6">
                <div class="shoping__checkout">
                    <h5>TOTAL</h5>
                    <ul>
                        <li>Itens 
                            <span class="text-info">
                                R$ <?php echo e(number_format($pedido->somaItens(), 2, ',', '.')); ?>

                            </span>
                        </li>

                        <li>Frete 
                            <span>
                                R$ <?php echo e(number_format($pedido->valor_frete, 2, ',', '.')); ?>

                            </span>
                        </li>

                        <li>Total 
                            <span id="total" class="text-success">
                                R$ <?php echo e(number_format($pedido->valor_total, 2, ',', '.')); ?>

                            </span>
                        </li>

                        
                    </ul>

                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">

    function copy(){

        const inputTest = document.querySelector("#qrcode_input");

        inputTest.select();
        document.execCommand('copy');

        swal("", "Código pix copado!!", "success")
    }

    var prot = window.location.protocol;
    var host = window.location.host;
    var pathname = window.location.pathname;
    let path = prot + "//" + host;

    if($('#status').val() != "approved"){
        setInterval(() => {
            let transacao_id = $('#transacao_id').val();

            $.get(path+'/ecommercePay/consulta/'+transacao_id)
            .done((success) => {

                if(success == "approved"){
                    location.reload()
                }
            })
            .fail((err) => {
                console.log(err)
            })
        }, 1500)
    }
</script>

<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?> 

<?php echo $__env->make('ecommerce.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/ecommerce/pedido_detalhe.blade.php ENDPATH**/ ?>