<?php $__env->startSection('content'); ?>

<div class="row">
	<div class="col s12">
		<h3 class="center-align">Relátorio de Caixa</h3>

		<h2 class="card-title">Total de vendas: <strong class="text-info"><?php echo e(sizeof($vendas)); ?></strong></h2>
		<h2 class="card-title text-success">Valor de abertura: <strong class=""><?php echo e(number_format($abertura->valor, 2, ',', '.')); ?></strong></h2>
	</div>

	<div class="row">
		<div class="col-xl-12">
			<h3 class="text-info">Total por tipo de pagamento:</h3>
			<div class="kt-section kt-section--first">
				<div class="kt-section__body">
					<div class="row">

						<?php $__currentLoopData = $somaTiposPagamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<?php if($tp > 0): ?>
						<div class="col-sm-4 col-lg-4 col-md-6">
							<div class="card card-custom gutter-b">
								<div class="card-header">
									<h3 class="card-title">
										<?php echo e(App\Models\VendaCaixa::getTipoPagamento($key)); ?>: 
										<strong class="text-success"> R$ <?php echo e(number_format($tp, 2, ',', '.')); ?></strong>
									</h3>
								</div>

							</div>
						</div>
						<?php endif; ?>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

					</div>
				</div>
			</div>
		</div>
	</div>

	<table class="pure-table">
		<thead>
			<tr>
				<th width="110">CLIENTE</th>
				<th width="110">DATA</th>
				<th width="110">TIPO DE PAGAMENTO</th>
				<th width="110">ESTADO</th>
				<th width="110">NFCE/NFE</th>
				<th width="110">TIPO</th>
				<th width="110">VALOR</th>
			</tr>
		</thead>

		<tbody>
			<?php
			$soma = 0;
			?>

			<?php $__currentLoopData = $vendas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr>
				<td><?php echo e($v->cliente->razao_social ?? 'NAO IDENTIFCADO'); ?></td>
				<td><?php echo e(\Carbon\Carbon::parse($v->created_at)->format('d/m/Y H:i:s')); ?></td>
				<td>
					<?php if($v->tipo_pagamento == '99'): ?>

					<a href="#!" onclick='swal("", "<?php echo e($v->multiplo()); ?>", "info")' class="btn btn-light-info">
						Ver
					</a>
					<?php else: ?>
					<?php echo e($v->getTipoPagamento($v->tipo_pagamento)); ?>

					<?php endif; ?>
				</td>
				<td><?php echo e($v->estado); ?></td>

				<?php if($v->tipo == 'PDV'): ?>
				<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e($v->NFcNumero > 0 ? $v->NFcNumero : '--'); ?></span>
				</td>
				<?php else: ?>
				<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e($v->NfNumero > 0 ? $v->NfNumero : '--'); ?></span>
				</td>
				<?php endif; ?>

				<td><?php echo e($v->tipo); ?></td>
				<td><?php echo e(number_format($v->valor_total, 2, ',', '.')); ?></td>
			</tr>

			<?php
			$soma += $v->valor_total;
			?>

			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>
	

	<h2 class="text-info">Soma de vendas: 
		<strong><?php echo e(number_format($soma, 2, ',', '.')); ?></strong>
	</h2>	

	<?php
	$somaSuprimento = 0;
	$somaSangria = 0;
	?>

	<div class="row">
		<div class="col-12 col-xl-6" style="width: 50%">
			<div class="card card-custom gutter-b bg-light-info">

				<div class="card-body">
					<h2 class="card-title">Suprimentos:</h2>

					<?php if(sizeof($suprimentos) > 0): ?>
					<?php $__currentLoopData = $suprimentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<h4>Valor: R$ <?php echo e(number_format($s->valor, 2, ',', '.')); ?></h4>
					<?php
					$somaSuprimento += $s->valor;
					?>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php else: ?>
					<h4>R$ 0,00</h4>
					<?php endif; ?>
				</div>			
			</div>			
		</div>	

		<div class="col-12 col-xl-6" style="width: 50%">
			<div class="card card-custom gutter-b bg-light-danger">

				<div class="card-body">
					<h2 class="card-title">Sangrias:</h2>

					<?php if(sizeof($sangrias) > 0): ?>
					<?php $__currentLoopData = $sangrias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<h4>Valor: R$ <?php echo e(number_format($s->valor, 2, ',', '.')); ?></h4>
					<?php
					$somaSangria += $s->valor;
					?>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php else: ?>
					<h4>R$ 0,00</h4>
					<?php endif; ?>
				</div>			
			</div>			
		</div>		
	</div>

	<div class="row">

		<div class="col-6">
			<h4 class="text-primary">Soma da vendas: <strong><?php echo e(number_format($soma, 2, ',', '.')); ?></strong></h4>

		</div>

		<div class="col-6">
			<h4 class="text-danger">Soma de sangria: <strong><?php echo e(number_format($somaSangria, 2, ',', '.')); ?></strong></h4>

		</div>

		<div class="col-6">
			<h4 class="text-success">Soma de suprimento: <strong><?php echo e(number_format($somaSuprimento, 2, ',', '.')); ?></strong></h4>
		</div>

		<div class="col-6">
			<h4 class="text-info">Valor em caixa: <strong><?php echo e(number_format($somaSuprimento + $soma - $somaSangria, 2, ',', '.')); ?></strong></h4>
		</div>
	</div>


</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('relatorios.cabecalho', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/caixa/relatorio.blade.php ENDPATH**/ ?>