<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">

	<div class="card-body">
		<h4>Fornecedor: <strong><?php echo e($cotacao->fornecedor->razao_social); ?></strong></h4>
		<h4>Data de registro: <strong><?php echo e(\Carbon\Carbon::parse($cotacao->data_registro)->format('d/m/Y H:i')); ?></strong></h4>

		<h5>Referencia: <?php echo e($cotacao->referencia); ?></h5>
		<h5>Observação: <?php echo e($cotacao->observacao); ?></h5>
		<h5>Link: <strong class="danger-text"> <a href="<?php echo e(getenv('PATH_URL')); ?>/response/<?php echo e($cotacao->link); ?>" target="_blank"><?php echo e(getenv('PATH_URL')); ?>/response/<?php echo e($cotacao->link); ?></a></strong></h5>

		<h5>Ativa:
			<?php if($cotacao->ativa): ?>
			<span class="label label-xl label-inline label-light-success">Sim</span>
			<?php else: ?>
			<span class="label label-xl label-inline label-light-danger">Não</span>
			<?php endif; ?>

		</h5>
		<h5>Respondida:
			<?php if($cotacao->resposta): ?>
			<span class="label label-xl label-inline label-light-success">Sim</span>
			<?php else: ?>
			<span class="label label-xl label-inline label-light-danger">Não</span>
			<?php endif; ?>
		</h5>

	</div>

	<div class="card-body">
		<h4>Itens da Cotação</h4>

		<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
			<div class="card card-custom gutter-b example example-compact">
				<div class="card-header">

					<div class="col-xl-12">
						<div class="row">
							<div class="col-xl-12">
								<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

									<table class="datatable-table" style="max-width: 100%; overflow: scroll">
										<thead class="datatable-head">
											<tr class="datatable-row" style="left: 0px;">
												<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 80px;">#</span></th>
												<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Produto</span></th>
												<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Quantidade</span></th>
												<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 80px;">Valor</span></th>

												<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Ações</span></th>
											</tr>
										</thead>
										<tbody class="datatable-body">
											<?php $__currentLoopData = $cotacao->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<tr class="datatable-row" style="left: 0px;">
												<td class="datatable-cell"><span class="codigo" style="width: 80px;"><?php echo e($i->id); ?></span></td>
												<td class="datatable-cell"><span class="codigo" style="width: 150px;"><?php echo e($i->produto->nome); ?></span></td>
												<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e($i->quantidade); ?></span></td>
												<td class="datatable-cell"><span class="codigo" style="width: 120px;"><?php echo e(number_format($i->valor, 2, ',', '.')); ?></span></td>
												<th class="datatable-cell">
													<span style="width: 120px;">
														<a href="/cotacao/deleteItem/<?php echo e($i->id); ?>" class="btn btn-danger">
															<span class="la la-trash">
															</span>
														</a>
													</span>
												</th>
											</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</tbody>
									</table>
								</div>
							</div>

						</div>

					</div>
				</div>

			</div>
		</div>
	</div>

	<div class="card-body">
		<div class="row">
			<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
				<div class="card card-custom gutter-b example example-compact">
					<div class="card-header">

						<div class="card-body">
							<h3 class="card-title">Total: <strong class="red-text">R$
									<?php echo e(number_format($cotacao->valor, 2, ',', '.')); ?></strong></h3>

							<div class="kt-widget__info">

								<h5 class="kt-widget__label">Total de itens: <strong><?php echo e(count($cotacao->itens)); ?></strong></h5>
								<h5 class="kt-widget__label">Forma de pagamento: <strong><?php echo e($cotacao->forma_pagamento); ?></strong></h5>
								<h5 class="kt-widget__label">Responsável: <strong><?php echo e($cotacao->responsavel); ?></strong></h5>

								<a target="_blank" class="navi-text" href="/cotacao/clonar/<?php echo e($cotacao->id); ?>">
									<span class="label label-xl label-inline label-light-warning">Clonar</span>
								</a>

								<?php if(!$cotacao->escolhida()): ?>
								<a onclick="if (! confirm('Deseja marcar como escolhida esta cotação?')) { return false; }" href="/cotacao/escolher/<?php echo e($cotacao->id); ?>" class="btn green">
								<span class="label label-xl label-inline label-light-success">Marcar como Escolhida</span>

								
								</a>
								<?php else: ?>
								<?php if($cotacao->escolhida()->id == $cotacao->id): ?>
								<h5 class="text-danger">Essa cotação já foi escolhida!</h5>
								<?php else: ?>
								<br>
								<h5><a href="/cotacao/view/<?php echo e($cotacao->escolhida()->id); ?>">
								<span class="label label-xl label-inline label-light-danger">
								Essa refernência já foi definida para cotação <?php echo e($cotacao->escolhida()->id); ?>

								</span>

								</a></h5>
								<?php endif; ?>

								<?php endif; ?>

							</div>
						</div>


					</div>
				</div>
			</div>


		</div>
	</div>

</div>

<div class="row">



</div>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/cotacao/view.blade.php ENDPATH**/ ?>