<?php $__env->startSection('content'); ?>
<div class="card card-custom gutter-b">
	<div class="card-body">
		<br>
		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<form method="get" action="/locacao/pesquisa">
				<div class="row align-items-center">
					<div class="form-group col-lg-3 col-md-4 col-sm-6">
						<label class="col-form-label">Cliente</label>
						<div class="">
							<div class="input-group">
								<input type="text" name="cliente" class="form-control" value="<?php echo e(isset($cliente) ? $cliente : ''); ?>" />
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Data inicial</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="data_inicial" class="form-control date-out" readonly value="<?php echo e(isset($dataInicial) ? $dataInicial : ''); ?>" id="kt_datepicker_3" />
								<div class="input-group-append">
									<span class="input-group-text">
										<i class="la la-calendar"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Data final</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="data_final" class="form-control" readonly value="<?php echo e(isset($dataFinal) ? $dataFinal : ''); ?>" id="kt_datepicker_3" />
								<div class="input-group-append">
									<span class="input-group-text">
										<i class="la la-calendar"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Estado</label>
						<div class="">
							<div class="input-group date">
								<select class="custom-select form-control" id="estado" name="estado">
									<option <?php if(isset($estado) && $estado == ''): ?> selected <?php endif; ?> value="">TODOS</option>
									<option <?php if(isset($estado) && $estado == '0'): ?> selected <?php endif; ?> value="0">NOVO</option>
									<option <?php if(isset($estado) && $estado == '1'): ?> selected <?php endif; ?> value="1">FINALIZADO</option>
								</select>
							</div>
						</div>
					</div>

					<div class="col-lg-2 col-xl-2 mt-2 mt-lg-0">
						<button style="margin-top: 13px;" class="btn btn-light-primary px-6 font-weight-bold">Pesquisa</button>
					</div>
				</div>

			</form>
			<br>
			<h4>Lista de Locações</h4>
			<label>Total de registros: <?php echo e(sizeof($locacoes)); ?></label>

			<div class="row <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">
				<div class="col-12">
					<div class="row">
						<a href="/locacao/novo" class="btn btn-success ml-3 mb-3">
							<i class="la la-plus"></i>
							Nova Locação
						</a>

						<?php if(isset($pesquisa)): ?>
						<form method="get" action="/locacao/relatorio">
							<input type="hidden" name="cliente" value="<?php echo e(isset($cliente) ? $cliente : ''); ?>" />
							<input type="hidden" name="data_inicial" value="<?php echo e(isset($dataInicial) ? $dataInicial : ''); ?>"/>
							<input type="hidden" name="data_final" value="<?php echo e(isset($dataFinal) ? $dataFinal : ''); ?>"/>
							<input type="hidden" name="estado" value="<?php echo e(isset($estado) ? $estado : ''); ?>"/>

							<button style="margin-left: 5px;" type="submit" class="btn btn-info">
								<i class="la la-print"></i>
								Imprimir
							</button>
						</form>
						<?php endif; ?>
					</div>
				</div>

			</div>
			<div class="row">

				<?php $__currentLoopData = $locacoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

				<div class="col-sm-12 col-lg-6 col-md-6 col-xl-6">
					<div class="card card-custom gutter-b example example-compact">
						<div class="card-header">
							<div class="card-title">
								<h3 style="width: 230px; font-size: 12px; height: 10px;" class="card-title">
									R$ <?php echo e(number_format($e->total, 2, ',', '.')); ?>

								</h3>
							</div>

							<div class="card-toolbar">
								<div class="dropdown dropdown-inline" data-toggle="tooltip" title="" data-placement="left" data-original-title="Ações">
									<a href="#" class="btn btn-hover-light-primary btn-sm btn-icon" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										<i class="fa fa-ellipsis-h"></i>
									</a>
									<div class="dropdown-menu p-0 m-0 dropdown-menu-md dropdown-menu-right">
										<!--begin::Navigation-->
										<ul class="navi navi-hover">
											<li class="navi-header font-weight-bold py-4">
												<span class="font-size-lg">Ações:</span>
											</li>
											<li class="navi-separator mb-3 opacity-70"></li>
											<li class="navi-item">
												<a href="/locacao/edit/<?php echo e($e->id); ?>" class="navi-link">
													<span class="navi-text">
														<span class="label label-xl label-inline label-light-primary">Editar</span>
													</span>
												</a>
											</li>
											<li class="navi-item">
												<a onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/locacao/delete/<?php echo e($e->id); ?>" }else{return false} })' href="#!" class="navi-link">
													<span class="navi-text">
														<span class="label label-xl label-inline label-light-danger">Excluir</span>
													</span>
												</a>
											</li>

										</ul>
										<!--end::Navigation-->
									</div>
								</div>

							</div>
						</div>

						<div class="card-body">

							<div class="kt-widget__info">
								<span class="kt-widget__label">Cliente:</span>
								<a target="_blank" class="kt-widget__data text-success">
									<?php echo e($e->cliente->razao_social); ?>

								</a>
							</div>
							<div class="kt-widget__info">
								<span class="kt-widget__label">Status:</span>
								<a target="_blank" class="kt-widget__data text-success">
									<?php if($e->status): ?>
									<span class="label label-xl label-inline label-light-success">FINALIZADO</span>
									<?php else: ?>
									<span class="label label-xl label-inline label-light-primary">NOVO</span>
									<?php endif; ?>
								</a>
							</div>
							<div class="kt-widget__info">
								<span class="kt-widget__label">Início:</span>
								<a target="_blank" class="kt-widget__data text-success">
									<?php echo e(\Carbon\Carbon::parse($e->inicio)->format('d/m/Y')); ?>

								</a>
							</div>
							<div class="kt-widget__info">
								<span class="kt-widget__label">Fim:</span>
								<a target="_blank" class="kt-widget__data text-danger">
									<?php if($e->fim != '1969-12-31'): ?>
									<?php echo e(\Carbon\Carbon::parse($e->fim)->format('d/m/Y')); ?>

									<?php else: ?>
									--
									<?php endif; ?>
								</a>
							</div>

						</div>

						<div class="card-footer">
							<a style="width: 100%;" href="/locacao/itens/<?php echo e($e->id); ?>" class="btn btn-light-primary">
								Detalhes
							</a>
						</div>
					</div>
				</div>

				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

			</div>

			<div class="d-flex justify-content-between align-items-center flex-wrap">
				<div class="d-flex flex-wrap py-2 mr-3">
					<?php if(isset($links)): ?>
					<?php echo e($eventos->links()); ?>

					<?php endif; ?>
				</div>
			</div>
		</div>

	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/locacao/list.blade.php ENDPATH**/ ?>