<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">

	<div class="card-body">
		<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
			<h4>Lista de Preço <strong class="text-primary"><?php echo e($lista->nome); ?></strong></h4>
			<h4>Percentual de alteração: <strong class="text-danger"><?php echo e($lista->percentual_alteracao); ?>%</strong>
				<?php if($lista->tipo == 1): ?>
				Valor de compra
				<?php else: ?>
				Valor de venda
				<?php endif; ?>
			</h4>

			<h5>Total de produtos cadastrados no sistema: <strong class="text-danger"><?php echo e(sizeof($produtos)); ?></strong></h5>

			<?php if(sizeof($lista->itens) > 0): ?>

			<a href="/listaDePrecos/gerar/<?php echo e($lista->id); ?>" class="btn btn-info">
				<i class="la la-refresh"></i>
				Atualizar
			</a>
			
			<div class="row">
				<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
					<div class="row">
						<div class="col-xl-12">

							<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">

								<table class="datatable-table" style="max-width: 100%; overflow: scroll">
									<thead class="datatable-head">
										<tr class="datatable-row" style="left: 0px;">
											<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 300px;">Produto</span></th>
											<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Valor venda padrão</span></th>
											<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Valor de compra</span></th>
											<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Valor venda da lista</span></th>
											<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Percentual de lucro</span></th>
											<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Ações</span></th>
										</tr>
									</thead>

									<tbody id="body" class="datatable-body">
										<?php $__currentLoopData = $lista->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr class="datatable-row">
											<td class="datatable-cell"><span class="codigo" style="width: 300px;" id="id"><?php echo e($i->produto->nome); ?></span>
											</td>
											<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e(number_format($i->produto->valor_venda, 2)); ?></span>
											</td>
											<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e(number_format($i->produto->valor_compra, 2)); ?></span>
											</td>
											<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e(number_format($i->valor, 2)); ?></span>
											</td>
											<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e(number_format($i->percentual_lucro, 2)); ?></span>
											</td>
											<td class="datatable-cell">
												<span class="codigo" style="width: 120px;" id="id">
													<a class="btn btn-light-primary" href="/listaDePrecos/editValor/<?php echo e($i->id); ?>">
														<i class="la la-edit"></i>				
													</a>
												</span>
											</td>
										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tbody>
								</table>

							</div>
						</div>
					</div>
				</div>
			</div>

			<?php else: ?>
			<h5 class="center-align text-danger">Esta lista ainda não tem produtos cadastrados <a class="btn btn-light-success" href="/listaDePrecos/gerar/<?php echo e($lista->id); ?>">Gerar Lista de Produtos</a></h5>

			<?php endif; ?>
		</div>

	</div>
</div>


<?php $__env->stopSection(); ?>	
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/listaPreco/ver.blade.php ENDPATH**/ ?>