<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">

	<div class="card-body">
		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
			<div class="col-12">

				<div class="row">
					<a href="/contasPagar/new" class="btn btn-lg btn-success">
						<i class="fa fa-plus"></i>Novo Conta a Pagar
					</a>

					<?php if(isset($paraImprimir)): ?>
					<form method="post" action="/contasPagar/relatorio">
						<?php echo csrf_field(); ?>
						<input type="hidden" name="fornecedor" value="<?php echo e(isset($fornecedor) ? $fornecedor : ''); ?>">
						<input type="hidden" name="data_inicial" value="<?php echo e(isset($dataInicial) ? $dataInicial : ''); ?>">
						<input type="hidden" name="data_final" value="<?php echo e(isset($dataFinal) ? $dataFinal : ''); ?>">
						<input type="hidden" name="status" value="<?php echo e(isset($status) ? $status : ''); ?>">
						<button style="margin-left: 5px;" href="/contasPagar/new" class="btn btn-lg btn-info">
							<i class="fa fa-print"></i>Imprimir relatório
						</button>
					</form>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<br>

		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<form method="get" action="/contasPagar/filtro">
				<div class="row align-items-center">

					<div class="form-group col-lg-4 col-xl-4">
						<div class="row align-items-center">

							<div class="col-md-12 my-2 my-md-0">
								<label class="col-form-label">Fornecedor</label>

								<div class="input-icon">
									<input type="text" name="fornecedor" value="<?php echo e(isset($fornecedor) ? $fornecedor : ''); ?>" class="form-control" placeholder="Fornecedor" id="kt_datatable_search_query">
									<span>
										<i class="fa fa-search"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Data de Registro</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="data_inicial" class="form-control" readonly value="<?php echo e(isset($dataInicial) ? $dataInicial : ''); ?>" id="kt_datepicker_3" />
								<div class="input-group-append">
									<span class="input-group-text">
										<i class="la la-calendar"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Data de Final</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="data_final" class="form-control" readonly value="<?php echo e(isset($dataFinal) ? $dataFinal : ''); ?>" id="kt_datepicker_3" />
								<div class="input-group-append">
									<span class="input-group-text">
										<i class="la la-calendar"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label text-left col-lg-12 col-sm-12">Estado</label>

						<select class="custom-select form-control" id="status" name="status">
							<option <?php if(isset($stats) && $status == 'todos'): ?> selected <?php endif; ?> value="todos">TODOS</option>
							<option <?php if(isset($stats) && $status == 'pago'): ?> selected <?php endif; ?> value="pago">PAGO</option>
							<option <?php if(isset($stats) && $status == 'pendente'): ?> selected <?php endif; ?> value="pendente">PENDENTE</option>
						</select>
					</div>

					<div class="col-lg-2 col-xl-2 mt-2 mt-lg-0">
						<button style="margin-top: 10px;" class="btn btn-light-primary px-6 font-weight-bold">Pesquisa</button>
					</div>
				</div>

			</form>
			<br>
			<h4>Lista de Contas a Pagar</h4>
			<h6 style="color: red">*<?php echo e($infoDados); ?></h6>
			<label>Total de registros: <?php echo e(sizeof($contas)); ?></label>
			<div class="row">

				<?php 
				$somaValor = 0;
				$somaPago = 0;
				$somaPendente = 0;
				?>

				<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">

					<div class="wizard wizard-3" id="kt_wizard_v3" data-wizard-state="between" data-wizard-clickable="true">
						<div class="wizard-nav">

							<div class="wizard-steps px-8 py-8 px-lg-15 py-lg-3">
								<!--begin::Wizard Step 1 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="done">
									<div class="wizard-label">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-table"></i>
												Tabela
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>
								<!--end::Wizard Step 1 Nav-->
								<!--begin::Wizard Step 2 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="current">
									<div class="wizard-label" id="grade">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-tablet"></i>
												Grade
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>

							</div>
						</div>

						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">
								<div class="col-xl-12">

									<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

										<table class="datatable-table" style="max-width: 100%; overflow: scroll">
											<thead class="datatable-head">
												<tr class="datatable-row" style="left: 0px;">
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 250px;">FORNECEDOR</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">CATEGORIA</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">VALOR INTEGRAL</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">VALOR PAGO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">DATA DE REGISTRO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">DATA DE PAGAMENTO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">DATA VENCIMENTO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">ESTADO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">AÇÕES</span></th>
												</tr>
											</thead>
											<tbody id="body" class="datatable-body">
												<?php $__currentLoopData = $contas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr class="datatable-row">
													<td class="datatable-cell">
														<span class="codigo" style="width: 250px;" id="id">

															<?php if($c->compra_id != null): ?>
															<?php echo e($c->compra->fornecedor->razao_social); ?>

														
															<?php else: ?>
															<?php if($c->fornecedor_id != null): ?>
															<?php echo e($c->fornecedor->razao_social); ?>

															<?php else: ?>
															--
															<?php endif; ?>
															<?php endif; ?>
														</span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 150px;" id="id"><?php echo e($c->categoria->nome); ?></span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															R$ <?php echo e(number_format($c->valor_integral, $casasDecimais, ',', '.')); ?>

														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															R$ <?php echo e(number_format($c->valor_pago, $casasDecimais, ',', '.')); ?>

														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															<?php echo e(\Carbon\Carbon::parse($c->created_at)->format('d/m/Y')); ?>

														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															<?php echo e(\Carbon\Carbon::parse($c->data_pagamento)->format('d/m/Y')); ?>

														</span>
													</td>
													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															<?php echo e(\Carbon\Carbon::parse($c->data_vencimento)->format('d/m/Y')); ?>

														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 120px;" id="id">
															<?php if($c->status == true): ?>
															<span class="label label-xl label-inline label-light-success">Pago</span>
															<?php else: ?>
															<span class="label label-xl label-inline label-light-danger">Pendente</span>
															<?php endif; ?>
														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 200px;" id="id">

															<a href="/contasPagar/edit/<?php echo e($c->id); ?>" class="btn btn-warning">
																<i class="la la-edit"></i>
															</a>


															<a onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/contasPagar/delete/<?php echo e($c->id); ?>" }else{return false} })' href="#!" class="btn btn-danger">
																<i class="la la-trash"></i>
															</a>

															<?php if($c->status == false): ?>

															<a href="/contasPagar/pagar/<?php echo e($c->id); ?>" class="btn btn-success">
																<i class="la la-money"></i>
															</a>

															<?php endif; ?>

														</span>
													</td>

												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>

						<input type="hidden" id="contas" value="<?php echo e(json_encode($contas)); ?>" name="">
						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">

								<?php $__currentLoopData = $contas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

								<div class="col-sm-12 col-lg-6 col-md-6 col-xl-4">
									<div class="card card-custom gutter-b example example-compact">
										<div class="card-header">
											<div class="card-title">
												<h3 style="width: 230px; font-size: 20px; height: 10px;" class="card-title">
													R$ <?php echo e(number_format($c->valor_integral, $casasDecimais, ',', '.')); ?>

												</h3>
											</div>

											<div class="card-toolbar">
												<div class="dropdown dropdown-inline" data-toggle="tooltip" title="" data-placement="left" data-original-title="Ações">
													<a href="#" class="btn btn-hover-light-primary btn-sm btn-icon" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
														<i class="fa fa-ellipsis-h"></i>
													</a>
													<div class="dropdown-menu p-0 m-0 dropdown-menu-md dropdown-menu-left">
														<!--begin::Navigation-->
														<ul class="navi navi-hover">
															<li class="navi-header font-weight-bold py-4">
																<span class="font-size-lg">Ações:</span>
															</li>


															<li class="navi-separator mb-3 opacity-70"></li>
															<li class="navi-item">
																<a href="/contasPagar/edit/<?php echo e($c->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-primary">Editar</span>
																	</span>
																</a>
															</li>
															<li class="navi-item">
																<a onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/contasPagar/delete/<?php echo e($c->id); ?>" }else{return false} })' href="#!" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-danger">Excluir</span>
																	</span>
																</a>
															</li>

															<?php if($c->status == false): ?>

															<li class="navi-item">
																<a href="/contasPagar/pagar/<?php echo e($c->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-success">Pagar</span>
																	</span>
																</a>
															</li>

															<?php endif; ?>


														</ul>
														<!--end::Navigation-->
													</div>
												</div>

											</div>

											<div class="card-body">

												<div class="kt-widget__info">
													<span class="kt-widget__label">Fornecedor:</span>
													<a target="_blank" class="kt-widget__data text-success">
														<?php if($c->compra_id != null): ?>
														<?php echo e($c->compra->fornecedor->razao_social); ?>

														<?php elseif($c->fornecedor_id != null): ?>
														<?php echo e($c->fornecedor->razao_social); ?>

														<?php else: ?>
														--
														<?php endif; ?>

													</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Categoria:</span>
													<a class="kt-widget__data text-success">
														<?php echo e($c->categoria->nome); ?>

													</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Valor pago:</span>
													<a class="kt-widget__data text-success">
														<?php echo e(number_format($c->valor_pago, $casasDecimais, ',', '.')); ?>

													</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Data de registro:</span>
													<a class="kt-widget__data text-success">
														<?php echo e(\Carbon\Carbon::parse($c->created_at)->format('d/m/Y')); ?>

													</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Data de pagamento:</span>
													<a class="kt-widget__data text-success">
														<?php echo e(\Carbon\Carbon::parse($c->data_pagamento)->format('d/m/Y')); ?>

													</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Data de vencimento:</span>
													<a class="kt-widget__data text-success">
														<?php echo e(\Carbon\Carbon::parse($c->data_vencimento)->format('d/m/Y')); ?>

													</a>
												</div>

												<div class="kt-widget__info">
													<span class="kt-widget__label">Estado:</span>
													<?php if($c->status == true): ?>
													<span class="label label-xl label-inline label-light-success">Pago</span>
													<?php else: ?>
													<span class="label label-xl label-inline label-light-danger">Pendente</span>
													<?php endif; ?>
												</div>



											</div>

										</div>

									</div>

								</div>

								<?php
								$somaValor += $c->valor_integral;
								$somaPago += $c->valor_pago;

								if($c->status == false)
									$somaPendente += $c->valor_integral;
								?>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

							</div>
						</div>
					</div>
				</div>

				<div class="d-flex justify-content-between align-items-center flex-wrap">
					<div class="d-flex flex-wrap py-2 mr-3">
						<?php if(isset($links)): ?>
						<?php echo e($contas->links()); ?>

						<?php endif; ?>
					</div>
				</div>

				<div class="card-body">
					<div class="row">
						<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
							<div class="card card-custom gutter-b example example-compact">
								<div class="card-header">

									<div class="card-body">
										<h3 class="card-title">Valor a Pagar: <strong style="margin-left: 5px;"> R$ <?php echo e(number_format($somaPendente, 2, ',', '.')); ?></strong></h3>

									</div>

								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<?php $__env->stopSection(); ?>

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcos/Documents/laravel/metronic_multi_8.4/resources/views/contaPagar/list.blade.php ENDPATH**/ ?>