<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta name="description" content="Ogani Template">
    <meta name="keywords" content="Ogani, unica, creative, html">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e($title); ?></title>

    <style type="text/css">
        :root {
            --color-default: <?php echo e($default['config']->cor_principal); ?>;
        }
    </style>

    <!-- Google Font -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;600;900&display=swap" rel="stylesheet">

    

    <?php if($default['config']->logo != ""): ?>
    <link rel="shortcut icon" href="/ecommerce/logos/<?php echo e($default['config']->logo); ?>" type="image/x-icon" />
    <?php else: ?>
    <link rel="shortcut icon" href="/ecommerce/logo.png" type="image/x-icon" />
    <?php endif; ?>
    <!-- Css Styles -->
    <link rel="stylesheet" href="/ecommerce/assets/css/bootstrap.min.css" type="text/css">
    <link rel="stylesheet" href="/ecommerce/assets/css/font-awesome.min.css" type="text/css">
    <link rel="stylesheet" href="/ecommerce/assets/css/elegant-icons.css" type="text/css">
    <link rel="stylesheet" href="/ecommerce/assets/css/nice-select.css" type="text/css">
    <link rel="stylesheet" href="/ecommerce/assets/css/jquery-ui.min.css" type="text/css">
    <link rel="stylesheet" href="/ecommerce/assets/css/owl.carousel.min.css" type="text/css">
    <link rel="stylesheet" href="/ecommerce/assets/css/slicknav.min.css" type="text/css">
    <link rel="stylesheet" href="/ecommerce/assets/css/style.css" type="text/css">
</head>

<body>
    <!-- Page Preloder -->
    <div id="preloder">
        <div class="loader"></div>
    </div>

    <!-- Humberger Begin -->
    <div class="humberger__menu__overlay"></div>
    <div class="humberger__menu__wrapper">
        <div class="humberger__menu__logo">
            <?php if($default['config']->logo != ""): ?>
            <img height="80" src="/ecommerce/logos/<?php echo e($default['config']->logo); ?>" alt="">
            <?php else: ?>
            <img height="80" src="/ecommerce/logo.png" alt="">
            <?php endif; ?>
        </div>
        <div class="humberger__menu__cart">
            <ul>
                <li><a href="<?php echo e($rota); ?>/curtidas"><i class="fa fa-heart"></i> <span><?php echo e($default['curtidas']); ?></span></a></li>
                <li><a href="<?php echo e($rota); ?>/carrinho"><i class="fa fa-shopping-bag"></i> <span><?php echo e($default['carrinho'] != null ? sizeof($default['carrinho']->itens) : 0); ?></span></a></li>
            </ul>
            <div class="header__cart__price">Carrinho: <span>R$ 0,00</span></div>
        </div>
        <div class="humberger__menu__widget">

            <div class="header__top__right__auth">
                <a href="<?php echo e($rota); ?>/login"><i class="fa fa-user"></i> Login</a>
            </div>
        </div>
        <nav class="humberger__menu__nav mobile-menu">
            <ul>


                <li><a href="<?php echo e($rota); ?>">Home</a></li>
                <li><a href="<?php echo e($rota); ?>/categorias">Categorias</a></li>

                <?php if($default['postBlogExists']): ?>
                <li><a href="<?php echo e($rota); ?>/blog">Blog</a></li>
                <?php endif; ?>
                <li><a href="<?php echo e($rota); ?>/contato">Contato</a></li>
            </ul>


        </nav>
        <div id="mobile-menu-wrap"></div>
        <div class="header__top__right__social">
            <?php if($default['config']['link_facebook'] != ""): ?>
            <a target="_blank" href="<?php echo e($default['config']['link_facebook']); ?>"><i class="fa fa-facebook"></i></a>
            <?php endif; ?>
            <?php if($default['config']['link_twitter'] != ""): ?>
            <a target="_blank" href="<?php echo e($default['config']['link_twitter']); ?>"><i class="fa fa-twitter"></i></a>
            <?php endif; ?>
            <?php if($default['config']['link_instagram'] != ""): ?>
            <a target="_blank" href="<?php echo e($default['config']['link_instagram']); ?>"><i class="fa fa-instagram"></i></a>
            <?php endif; ?>

        </div>
        <div class="humberger__menu__contact">
            <ul>
                <li><i class="fa fa-envelope"></i> <?php echo e($default['config']['email']); ?></li>
                <li>Frete gratis acima de R$ 
                    <?php echo e(number_format($default['config']['frete_gratis_valor'], 2, ',', '.')); ?>

                </li>
            </ul>
        </div>
    </div>
    <!-- Humberger End -->

    <!-- Header Section Begin -->
    <header class="header">

        <div class="container">
            <div class="row">
                <div class="col-lg-3">
                    <div class="header__logo">
                        <a href="<?php echo e($rota); ?>">
                            <?php if($default['config']->logo != ""): ?>
                            <img height="80" src="/ecommerce/logos/<?php echo e($default['config']->logo); ?>" alt="">
                            <?php else: ?>
                            <img height="80" src="/ecommerce/logo.png" alt="">
                            <?php endif; ?>
                        </a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <nav class="header__menu">
                        <ul>
                            <li <?php if($default['active'] == 'home'): ?> class="active" <?php endif; ?>><a href="<?php echo e($rota); ?>">Home</a></li>
                            <li <?php if($default['active'] == 'categorias'): ?> class="active" <?php endif; ?>><a href="<?php echo e($rota); ?>/categorias">Categorias</a></li>

                            <!-- <?php if($default['postBlogExists']): ?> -->
                            <li <?php if($default['active'] == 'blog'): ?> class="active" <?php endif; ?>><a href="<?php echo e($rota); ?>/blog">Blog</a></li>
                            <!-- <?php endif; ?> -->
                            <li <?php if($default['active'] == 'contato'): ?> class="active" <?php endif; ?>><a href="<?php echo e($rota); ?>/contato">Contato</a></li>
                        </ul>
                    </nav>
                </div>

                <div class="col-lg-3">
                    <div class="header__cart">
                        <ul>
                            <li>
                                <a href="<?php echo e($rota); ?>/login">
                                    <i class="fa fa-user <?php if(session('user_ecommerce')): ?> text-success <?php endif; ?>"></i> 
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e($rota); ?>/curtidas"><i class="fa fa-heart"></i> 
                                    <span>
                                        <?php echo e($default['curtidas']); ?>

                                    </span>
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e($rota); ?>/carrinho"><i class="fa fa-shopping-bag"></i> 
                                    <span><?php echo e($default['carrinho'] != null ? sizeof($default['carrinho']->itens) : 0); ?></span>
                                </a>
                            </li>
                        </ul>
                        <div class="header__cart__price">Carrinho: 
                            <span>
                                R$ <?php echo e($default['carrinho'] != null ? number_format($default['carrinho']->somaItens(), 2, ',', '.') : '0,00'); ?>

                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="humberger__open">
                <i class="fa fa-bars"></i>
            </div>
        </div>
    </header>
    <!-- Header Section End -->

    <!-- Hero Section Begin -->
    <section class="hero hero-normal">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">
                    <div class="hero__categories">
                        <div class="hero__categories__all" style="width: 100%">
                            <i class="fa fa-bars"></i>
                            <span>Categorias</span>
                        </div>
                        <ul class="w-100">
                            <?php $__currentLoopData = $default['categorias']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li style="background: #F5F5F5;">
                                <a href="<?php echo e($rota); ?>/<?php echo e($c->id); ?>/categorias"><?php echo e($c->nome); ?></a>
                            </li>
                            <?php $__currentLoopData = $c->subs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a style="padding-left: 30px;" href="<?php echo e($rota); ?>/<?php echo e($s->id); ?>/subcategoria"><?php echo e($s->nome); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="hero__search">
                        <div class="hero__search__form">
                            <form action="<?php echo e($rota); ?>/pesquisa">

                                <input type="text" name="pesquisa" placeholder="O que você procura?">
                                <button type="submit" class="site-btn">Buscar</button>
                            </form>
                        </div>
                        <div class="hero__search__phone">
                            <div class="hero__search__phone__icon">
                                <i class="fa fa-phone"></i>
                            </div>
                            <div class="hero__search__phone__text">
                                <h5><?php echo e($default['config']->telefone); ?></h5>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
    </section>
    <!-- Hero Section End -->

    <?php if(session()->has('mensagem_sucesso')): ?>
    <div class="escfff" style="background: #fff;">
        <div class="container">
            <div class="alert alert-custom alert-success fade show" role="alert">

                <div class="alert-text"><i class="fa fa-check"></i> 
                    <?php echo e(session()->get('mensagem_sucesso')); ?> 
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="fa fa-close"></i>
                    </button>
                </div>

            </div>
        </div>
    </div>
    <?php endif; ?>

    <?php if(session()->has('mensagem_erro')): ?>
    <div class="escfff" style="background: #fff;">
        <div class="container">
            <div class="alert alert-custom alert-danger fade show" role="alert">

                <div class="alert-text"><i class="fa fa-check"></i> 
                    <?php echo e(session()->get('mensagem_erro')); ?> 
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <i class="fa fa-close"></i>
                    </button>
                </div>

            </div>
        </div>
    </div>
    <?php endif; ?>


    <?php echo $__env->yieldContent('content'); ?>

    <!-- Footer Section Begin -->
    <footer class="footer spad">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-md-6 col-sm-6">
                    <div class="footer__about">
                        <div class="footer__about__logo">
                            <a href="<?php echo e($rota); ?>">

                                <?php if($default['config']->logo != ""): ?>
                                <img height="80" src="/ecommerce/logos/<?php echo e($default['config']->logo); ?>" alt="">
                                <?php else: ?>
                                <img height="80" src="/ecommerce/logo.png" alt="">
                                <?php endif; ?>
                            </a>
                        </div>
                        <ul>
                            <li>Endereço: <?php echo e($default['config']->rua); ?>, <?php echo e($default['config']->numero); ?> - <?php echo e($default['config']->bairro); ?></li>
                            <li>Telefone: <?php echo e($default['config']->telefone); ?></li>
                            <li>Email: <?php echo e($default['config']->email); ?></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-6 offset-lg-1">

                </div>
                <div class="col-lg-4 col-md-12">
                    <div class="footer__widget">
                        <h6>Junte-se ao nosso boletim informativo agora</h6>
                        <p>Receba atualizações por e-mail sobre nossa última loja e ofertas especiais.</p>

                        <?php if($errors->has('email')): ?>
                        <p class="text-danger"><?php echo e($errors->first('email')); ?></p>
                        <?php endif; ?>

                        <form action="/ecommerceInformativo" method="post">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" value="<?php echo e($default['config']->empresa_id); ?>" name="empresa_id">
                            <input type="email" value="<?php echo e(old('email')); ?>" placeholder="Seu melhor email" name="email_info">
                            <button type="submit" class="site-btn">Assinar</button>
                        </form>
                        <div class="footer__widget__social">
                            <?php if($default['config']['link_facebook'] != ""): ?>
                            <a target="_blank" href="<?php echo e($default['config']['link_facebook']); ?>"><i class="fa fa-facebook"></i></a>
                            <?php endif; ?>
                            <?php if($default['config']['link_instagram'] != ""): ?>
                            <a target="_blank" href="<?php echo e($default['config']['link_instagram']); ?>"><i class="fa fa-instagram"></i></a>
                            <?php endif; ?>
                            <?php if($default['config']['link_twiter'] != ""): ?>
                            <a target="_blank" href="<?php echo e($default['config']['link_twiter']); ?>"><i class="fa fa-twitter"></i></a>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </footer>
    <!-- Footer Section End -->

    <!-- Js Plugins -->
    <script src="/ecommerce/assets/js/jquery-3.3.1.min.js"></script>
    <script src="/ecommerce/assets/js/bootstrap.min.js"></script>
    <script src="/ecommerce/assets/js/jquery.nice-select.min.js"></script>
    <?php if(!isset($payJs)): ?>
    <script src="/ecommerce/assets/js/jquery-ui.min.js"></script>
    <script src="/ecommerce/assets/js/jquery.slicknav.js"></script>
    <?php endif; ?>
    <script src="/ecommerce/assets/js/mixitup.min.js"></script>
    <script src="/ecommerce/assets/js/owl.carousel.min.js"></script>
    <script src="/ecommerce/assets/js/main.js"></script>
    <script type="text/javascript" src="/js/jquery.mask.min.js"></script>
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
    
    <?php if(isset($carrinhoJs)): ?>
    <script src="/ecommerce/assets/js/carrinho.js"></script>
    <?php endif; ?>

    <?php if(isset($payJs)): ?>
    <script src="https://secure.mlstatic.com/sdk/javascript/v1/mercadopago.js"></script>

    <script type="text/javascript">
        window.Mercadopago.setPublishableKey('<?php echo e($default['config']->mercadopago_public_key); ?>')
    </script>

    <script src="/ecommerce/assets/js/pay.js"></script>
    <?php endif; ?>

    <?php echo $__env->yieldContent('javascript'); ?>

</body>

</html><?php /**PATH /Users/marcos/Documents/laravel/metronic_multi_8.4/resources/views/ecommerce/default.blade.php ENDPATH**/ ?>