<?php $__env->startSection('content'); ?>
<div class="card card-custom gutter-b">
	<div class="card-body">

		<div class="" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<input type="hidden" id="_token" value="<?php echo e(csrf_token()); ?>">
			<form class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft" method="get" action="/financeiro/filtro">
				<div class="row align-items-center">

					<div class="form-group col-lg-3 col-md-6 col-sm-6">
						<label class="col-form-label">Empresa</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="empresa" class="form-control" value="<?php echo e(isset($empresa) ? $empresa : ''); ?>" />
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Data Inicial</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="data_inicial" class="form-control date-out" readonly value="<?php echo e(isset($dataInicial) ? $dataInicial : ''); ?>" id="kt_datepicker_3" />
								<div class="input-group-append">
									<span class="input-group-text">
										<i class="la la-calendar"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Data Final</label>
						<div class="">
							<div class="input-group date">
								<input type="text" name="data_final" class="form-control" readonly value="<?php echo e(isset($dataFinal) ? $dataFinal : ''); ?>" id="kt_datepicker_3" />
								<div class="input-group-append">
									<span class="input-group-text">
										<i class="la la-calendar"></i>
									</span>
								</div>
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-3 col-sm-3">
						<label class="col-form-label">Estado</label>
						<div class="">
							<select name="status" class="custom-select">
								<option <?php if(isset($status)): ?> <?php if($status == 'TODOS'): ?> selected <?php endif; ?> <?php endif; ?> value="TODOS">TODOS</option>
								<option <?php if(isset($status)): ?> <?php if($status ==  'approved'): ?> selected <?php endif; ?> <?php endif; ?> value="approved">PAGO</option>
								<option <?php if(isset($status)): ?> <?php if($status == 'pending'): ?> selected <?php endif; ?> <?php endif; ?> value="pending">PENDENTE</option>
								<option <?php if(isset($status)): ?> <?php if($status == 'rejected'): ?> selected <?php endif; ?> <?php endif; ?> value="rejected">REJEITADO</option>
							</select>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-3 col-sm-3">
						<label class="col-form-label">Tipo de pagamento</label>
						<div class="">
							<select name="tipo_pagamento" class="custom-select">
								<option <?php if(isset($tipo_pagamento)): ?> <?php if($tipo_pagamento == 'TODOS'): ?> selected <?php endif; ?> <?php endif; ?> value="TODOS">TODOS</option>
								<option <?php if(isset($tipo_pagamento)): ?> <?php if($tipo_pagamento == 'Cartão'): ?> selected <?php endif; ?> <?php endif; ?> value="Cartão">CARTÃO</option>
								<option <?php if(isset($tipo_pagamento)): ?> <?php if($tipo_pagamento == 'Boleto'): ?> selected <?php endif; ?> <?php endif; ?> value="Boleto">BOLETO</option>
								<option <?php if(isset($tipo_pagamento)): ?> <?php if($tipo_pagamento == 'Pix'): ?> selected <?php endif; ?> <?php endif; ?> value="Pix">PIX</option>
							</select>
						</div>
					</div>
					<div class="col-lg-1 col-xl-1 mt-2 mt-lg-0">
						<button style="margin-top: 15px;" class="btn btn-light-primary px-6 font-weight-bold">
							<i class="la la-search"></i>
						</button>
					</div>
				</div>
			</form>

			<h4 class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">Lista de Pagamentos</h4>

			<label class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">Registros: <strong class="text-success"><?php echo e(sizeof($payments)); ?></strong></label>
			<div class="col-xl-12 <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
				<div class="row">

					<a href="/financeiro/novoPagamento" class="btn btn-success">
						<i class="la la-plus"></i>
						Pagamento Manual
					</a>

					<a id="btn-verifica" style="margin-left: 5px;" href="/financeiro/verificaPagamentos" class="btn btn-info spinner-white spinner-right">
						<i class="la la-refresh"></i>
						verificar pagamentos
					</a>

				</div>
			</div>

			<div class="col-xl-12 <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">

				<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

					<table class="datatable-table" style="max-width: 100%; overflow: scroll">
						<thead class="datatable-head">
							<tr class="datatable-row" style="left: 0px;">
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">#</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 250px;">Empresa</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Data</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Plano</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Valor</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Status</span></th>
								<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">Ações</span></th>
							</tr>
						</thead>

						<?php
						$soma = 0;
						?>
						<tbody class="datatable-body">
							<?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

							<tr class="datatable-row">
								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">
										<?php echo e($p->transacao_id != '' ? $p->transacao_id : '--'); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 250px;">
										<?php echo e($p->empresa->nome); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 150px;">
										<?php echo e(\Carbon\Carbon::parse($p->created_at)->format('d/m/Y H:i:s')); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">
										<?php echo e($p->plano->plano->nome); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">
										<?php echo e(number_format($p->valor, 2, ',', '.')); ?>

									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 100px;">

										<?php if($p->status == 'approved'): ?>
										<span class="label label-xl label-inline label-light-success">Aprovado</span>
										<?php elseif($p->status == 'pending'): ?>
										<span class="label label-xl label-inline label-light-warning">Pendente</span>
										<?php elseif($p->status == 'rejected'): ?>
										<span class="label label-xl label-inline label-light-danger">Rejeitado</span>
										<?php else: ?>
										<span class="label label-xl label-inline label-light-dark">Não identificado</span>
										<?php endif; ?>
									</span>
								</td>

								<td class="datatable-cell">
									<span class="codigo" style="width: 200px;">
										<a href="/financeiro/detalhes/<?php echo e($p->id); ?>" class="btn btn-sm btn-primary">
											Detalhes
										</a>

										<!-- <?php if($p->status == 'rejected' || $p->status == 'pending'): ?>
										<a onclick='swal("Atenção!", "Deseja remover este pagamento?", "warning").then((sim) => {if(sim){ location.href="/financeiro/delete/<?php echo e($p->id); ?>" }else{return false} })' href="#!"  class="btn btn-sm btn-danger">
											Remover
										</a>
										<?php endif; ?> -->
									</span>
								</td>

							</tr>

							<?php
							$soma += $p->valor;
							?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
							<div class="card card-custom gutter-b example example-compact">
								<div class="card-header">

									<div class="card-body">
										<h3 class="card-title">Soma: <strong style="margin-left: 5px;" class="text-info"> R$ <?php echo e(number_format($soma, 2, ',', '.')); ?></strong></h3>

									</div>

								</div>
							</div>
						</div>

					</div>
				</div>
			</div>
			<div class="d-flex justify-content-between align-items-center flex-wrap">
				<div class="d-flex flex-wrap py-2 mr-3">
					<?php if(isset($links)): ?>
					<?php echo e($payments->links()); ?>

					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">

	$('#btn-verifica').click(() => {
		$('#btn-verifica').addClass('spinner');
	})
</script>
<?php $__env->stopSection(); ?>	

<?php $__env->stopSection(); ?>	

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/payment/list.blade.php ENDPATH**/ ?>