<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">
	<div class="col-xl-12">
		
		<div class="card-body">
			<h4>Código: <strong><?php echo e($compra->id); ?></strong></h4>

			<?php if($compra->nf > 0): ?>
			<h4>NF-e: <strong><?php echo e($compra->nf ?? '*'); ?></strong></h4>
			<?php endif; ?>

			<h5>Usuário: <strong><?php echo e($compra->usuario->nome); ?></strong></h5>

			<?php if($compra->nf): ?>
			<h5>Chave: <strong><?php echo e($compra->chave); ?></strong></h5>
			<?php endif; ?>

			<h5>Fornecedor: <strong><?php echo e($compra->fornecedor->razao_social); ?></strong></h5>
			<h5>Data: <strong><?php echo e(\Carbon\Carbon::parse($compra->created_at)->format('d/m/Y H:i:s')); ?></strong></h5>

			
		</div>
	</div>

	<div class="card-body">

		<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
			<div class="card card-custom gutter-b example example-compact">
				<div class="card-header">

					<div class="col-xl-12">
						<div class="row">
							<div class="col-xl-12">
								<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">
									<br>
									<h4>Itens da Compra</h4>

									<table class="datatable-table" style="max-width: 100%; overflow: scroll">
										<thead class="datatable-head">
											<tr class="datatable-row" style="left: 0px;">
												<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 80px;">#</span></th>
												<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">Produto</span></th>
												<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Valor</span></th>
												<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 80px;">Validade</span></th>

												<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 80px;">Quantidade</span></th>

												<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 80px;">Subtotal</span></th>

											</tr>
										</thead>
										<?php 
										$p = null;
										?>
										<tbody class="datatable-body">
											<?php $__currentLoopData = $compra->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php 
											$p = $i;
											?>
											<tr class="datatable-row" style="left: 0px;">
												<td class="datatable-cell"><span class="codigo" style="width: 80px;"><?php echo e($i->produto_id); ?></span></td>
												<td class="datatable-cell">
													<span class="codigo" style="width: 200px;">
														<?php echo e($i->produto->nome); ?>

														<?php echo e($i->produto->grade ? " (" . $i->produto->str_grade . ")" : ""); ?>

													</span>
												</td>
												<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e(number_format($i->valor_unitario, $casasDecimais, ',', '.')); ?></span></td>
												<td class="datatable-cell"><span class="codigo" style="width: 80px;"><?php echo e(\Carbon\Carbon::parse($i->validade)->format('d/m/Y')); ?></span></td>
												<td class="datatable-cell"><span class="codigo" style="width: 80px;"><?php echo e($i->quantidade); ?></span></td>
												<td class="datatable-cell"><span class="codigo" style="width: 80px;"><?php echo e(number_format(($i->valor_unitario * $i->quantidade), $casasDecimais, ',', '.')); ?></span></td>

												
											</tr>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</tbody>
									</table>
								</div>
							</div>

						</div>

					</div>

					<div class="card-body">
						<div class="row">
							<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">
								<div class="card card-custom gutter-b example example-compact">
									<div class="card-header">

										<div class="card-body">
											<h3 class="card-title">Total: R$ <strong class="red-text"><?php echo e(number_format($compra->somaItems(), $casasDecimais, ',', '.')); ?></strong></h3>

											<?php if($compra->xml_path != ''): ?>
											<a target="_blank" class="navi-text" href="/compras/downloadXml/<?php echo e($compra->id); ?>">
												<span class="label label-xl label-inline label-light-success">
													Downlaod XML
												</span>
											</a>
											<?php endif; ?>

											<h5>Oservação: 
												<strong>
													<?php echo e($compra->observacao); ?>


													<?php
													$veiCpl = '';


													if($p->produto->renavam != ''){
													$veiCpl = 'RENAVAM ' . $p->produto->renavam;
													if($p->produto->placa != '') $veiCpl .= ', PLACA ' . $p->produto->placa;
													if($p->produto->chassi != '') $veiCpl .= ', CHASSI ' . $p->produto->chassi;
													if($p->produto->combustivel != '') $veiCpl .= ', COMBUSTÍVEL ' . $p->produto->combustivel;
													if($p->produto->ano_modelo != '') $veiCpl .= ', ANO/MODELO ' . $p->produto->ano_modelo;
													if($p->produto->cor_veiculo != '') $veiCpl .= ', COR ' . $p->produto->cor_veiculo;

												}
												?>

												<?php echo e($veiCpl); ?>

											</strong>
										</h5>

									</div>


								</div>
							</div>
						</div>


					</div>
				</div>
			</div>

		</div>
	</div>
</div>



</div>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/compraManual/detail.blade.php ENDPATH**/ ?>