<?php $__env->startSection('content'); ?>


<div class="content d-flex flex-column flex-column-fluid" id="kt_content">

	<div class="container <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
		<div class="card card-custom gutter-b example example-compact">
			<div class="col-lg-12">
				<!--begin::Portlet-->

				<form method="post" action="/produtos/save" enctype="multipart/form-data">


					<input type="hidden" name="id" value="<?php echo e(isset($produto) ? $produto->id : 0); ?>">
					<div class="card card-custom gutter-b example example-compact">
						<div class="card-header">

							<h3 class="card-title">Duplicar Produto</h3>
						</div>

					</div>
					<input type="hidden" value="<?php echo e(csrf_token()); ?>" id="_token" name="_token">
					
					<p class="kt-widget__data text-danger">Campos com (*) obrigatório</p>
					<div class="row">
						<div class="col-xl-2"></div>
						<div class="col-xl-8">
							<div class="kt-section kt-section--first">
								<div class="kt-section__body">

									<div class="row">
										<div class="form-group validated col-sm-9 col-lg-9">
											<label class="col-form-label">Nome*</label>
											<div class="">
												<input type="text" class="form-control <?php if($errors->has('nome')): ?> is-invalid <?php endif; ?>" name="nome" value="<?php echo e(isset($produto) ? $produto->nome : old('nome')); ?>">
												<?php if($errors->has('nome')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('nome')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-3 col-lg-3">
											<label class="col-form-label">Referência</label>
											<div class="">
												<input type="text" class="form-control <?php if($errors->has('referencia')): ?> is-invalid <?php endif; ?>" name="referencia" value="<?php echo e(isset($produto) ? $produto->referencia : old('referencia')); ?>">
												<?php if($errors->has('referencia')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('referencia')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-3 col-lg-3">
											<label class="col-form-label">Valor de Compra*</label>
											<div class="">
												<input type="text" id="valor_compra" class="form-control <?php if($errors->has('valor_compra')): ?> is-invalid <?php endif; ?> money" name="valor_compra" value="<?php echo e(isset($produto) ? number_format($produto->valor_compra, $casasDecimais) : old('valor_compra')); ?>">
												<?php if($errors->has('valor_compra')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('valor_compra')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-3 col-lg-3">
											<label class="col-form-label">% lucro*</label>
											<div class="">
												<input type="text" id="percentual_lucro" class="form-control <?php if($errors->has('percentual_lucro')): ?> is-invalid <?php endif; ?> money" name="percentual_lucro" value="<?php echo e(isset($produto) ? $produto->percentual_lucro : old('percentual_lucro')); ?>">
												<?php if($errors->has('percentual_lucro')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('percentual_lucro')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-3 col-lg-3">
											<label class="col-form-label">Valor de Venda*</label>
											<div class="">
												<input type="text" id="valor_venda" class="form-control <?php if($errors->has('valor_venda')): ?> is-invalid <?php endif; ?> money" name="valor_venda" value="<?php echo e(isset($produto) ? number_format($produto->valor_venda, $casasDecimais) : old('valor_venda')); ?>">
												<?php if($errors->has('valor_venda')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('valor_venda')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<?php if(isset($produto)): ?>
										<div class="form-group validated col-sm-3 col-lg-3">
											<label class="col-form-label">Estoque Atual</label>
											<div class="">
												<input type="text" id="estoque" class="form-control <?php if($errors->has('estoque')): ?> is-invalid <?php endif; ?> money" name="estoque" 
												value="<?php if($produto->estoque): ?> <?php echo e(number_format($produto->estoque->quantidade, 2)); ?> <?php else: ?> 0 <?php endif; ?>">
												<?php if($errors->has('estoque')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('estoque')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										<?php else: ?>
										<div class="form-group validated col-sm-3 col-lg-3">
											<label class="col-form-label">Iniciar com Estoque</label>
											<div class="">
												<input type="text" id="estoque" class="form-control <?php if($errors->has('estoque')): ?> is-invalid <?php endif; ?> money" name="estoque" 
												value="">
												<?php if($errors->has('estoque')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('estoque')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										<?php endif; ?>

										<div class="form-group validated col-sm-6 col-lg-3">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Valor livre</label>
											<div class="col-6">
												<span class="switch switch-outline switch-primary">
													<label>
														<input value="true" <?php if(isset($produto->valor_livre) && $produto->valor_livre): ?> checked <?php endif; ?> type="checkbox" name="valor_livre" id="valor_livre">
														<span></span>
													</label>
												</span>
											</div>
										</div>

										<div class="form-group validated col-sm-3 col-lg-3">
											<label class="col-form-label">Estoque minimo</label>
											<div class="">
												<input type="text" id="estoque_minimo" class="form-control <?php if($errors->has('estoque_minimo')): ?> is-invalid <?php endif; ?>" name="estoque_minimo" value="<?php echo e(isset($produto) ? $produto->estoque_minimo : old('estoque_minimo')); ?>">
												<?php if($errors->has('estoque_minimo')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('estoque_minimo')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>


										<div class="form-group validated col-sm-6 col-lg-3">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Gerenciar estoque</label>
											<div class="col-6">
												<span class="switch switch-outline switch-primary">
													<label>
														<input value="true" <?php if(isset($produto) && $produto->gerenciar_estoque): ?> checked <?php elseif(getenv("PRODUTO_GERENCIAR_ESTOQUE") == 1 && !isset($produto)): ?> checked <?php endif; ?> type="checkbox" name="gerenciar_estoque" id="gerenciar_estoque">
														<span></span>
													</label>
												</span>
											</div>
										</div>

										<div class="form-group validated col-lg-5 col-md-5 col-sm-10">
											<label class="col-form-label text-left col-12">Categoria</label>
											<div class="input-group">

												<select id="categoria" class="form-control custom-select" name="categoria_id">
													<?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option value="<?php echo e($cat->id); ?>" <?php if(isset($produto)): ?> <?php if($cat->id == $produto->categoria_id): ?>
														selected=""
														<?php endif; ?>
														<?php endif; ?> ><?php echo e($cat->nome); ?>

													</option>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>
												<div class="input-group-prepend">
													<span class="input-group-text btn-info btn" onclick="novaCategoria()">
														<i class="la la-plus"></i>
													</span>
												</div>
												<?php if($errors->has('categoria')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('categoria')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-4 col-lg-4">
											<label class="col-form-label">Limite maximo desconto %</label>
											<div class="">
												<input type="text" id="limite_maximo_desconto" class="form-control <?php if($errors->has('limite_maximo_desconto')): ?> is-invalid <?php endif; ?>" name="limite_maximo_desconto" value="<?php echo e(isset($produto) ? $produto->limite_maximo_desconto : old('limite_maximo_desconto')); ?>">
												<?php if($errors->has('limite_maximo_desconto')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('limite_maximo_desconto')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>


										<div class="form-group validated col-lg-4 col-md-5 col-sm-10">
											<label class="col-form-label text-left col-lg-3 col-sm-6">Cor</label>

											<select class="form-control select2" id="kt_select2_2" name="cor">
												<option value="--">--</option>
												<option value="Preto">Preto</option>
												<option value="Branco">Branco</option>
												<option value="Dourado">Dourado</option>
												<option value="Vermelho">Vermelho</option>
												<option value="Azul">Azul</option>
												<option value="Rosa">Rosa</option>
											</select>

										</div>
										<div class="form-group validated col-sm-3 col-lg-4">
											<label class="col-form-label">Alerta de Venc. (Dias)</label>
											<div class="">
												<input type="text" id="alerta_vencimento" class="form-control <?php if($errors->has('alerta_vencimento')): ?> is-invalid <?php endif; ?>" name="alerta_vencimento" value="<?php echo e(isset($produto) ? $produto->alerta_vencimento : old('alerta_vencimento')); ?>">
												<?php if($errors->has('alerta_vencimento')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('alerta_vencimento')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										

										<div class="form-group validated col-lg-4 col-md-6 col-sm-10">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Unidade de compra *</label>

											<select class="custom-select form-control" id="unidade_compra" name="unidade_compra">
												<?php $__currentLoopData = $unidadesDeMedida; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option <?php if(isset($produto)): ?> <?php if($u==$produto->unidade_compra): ?>
													selected
													<?php endif; ?>
													<?php else: ?>
													<?php if($u == 'UN'): ?>
													selected
													<?php endif; ?>
													<?php endif; ?> value="<?php echo e($u); ?>"><?php echo e($u); ?>

												</option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
										</div>


										<div class="form-group validated col-sm-3 col-lg-3" id="conversao" style="display: none">
											<label class="col-form-label">Conversão Unitária</label>
											<div class="">
												<input type="text" id="alerta_vencimento" class="form-control <?php if($errors->has('conversao_unitaria')): ?> is-invalid <?php endif; ?>" name="conversao_unitaria" value="<?php echo e(isset($produto->conversao_unitaria) ? $produto->conversao_unitaria : old('conversao_unitaria')); ?>">
												<?php if($errors->has('conversao_unitaria')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('conversao_unitaria')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
										<div class="form-group validated col-lg-4 col-md-6 col-sm-10">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Unidade de venda *</label>

											<select class="custom-select form-control" id="unidade_venda" name="unidade_venda">
												<?php $__currentLoopData = $unidadesDeMedida; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option <?php if(isset($produto)): ?> <?php if($u==$produto->unidade_venda): ?>
													selected
													<?php endif; ?>
													<?php else: ?>
													<?php if($u == 'UN'): ?>
													selected
													<?php endif; ?>
													<?php endif; ?> value="<?php echo e($u); ?>"><?php echo e($u); ?>

												</option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>

										</div>
									</div>

									<div class="row">
										<div class="form-group validated col-sm-3 col-lg-3">
											<label class="col-form-label">NCM *</label>
											<div class="">
												<input type="text" id="ncm" class="form-control <?php if($errors->has('NCM')): ?> is-invalid <?php endif; ?>" name="NCM" value="<?php echo e(isset($produto->NCM) ? $produto->NCM : $tributacao->ncm_padrao); ?>">
												<?php if($errors->has('NCM')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('NCM')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>

										<div class="form-group validated col-sm-3 col-lg-3">
											<label class="col-form-label">CEST</label>
											<div class="">
												<input type="text" id="cest" class="form-control <?php if($errors->has('CEST')): ?> is-invalid <?php endif; ?>" name="CEST" value="<?php echo e(isset($produto->CEST) ? $produto->CEST : old('CEST')); ?>">
												<?php if($errors->has('CEST')): ?>
												<div class="invalid-feedback">
													<?php echo e($errors->first('CEST')); ?>

												</div>
												<?php endif; ?>
											</div>
										</div>
									</div>

									<div class="row">
										<div class="form-group validated col-lg-10 col-md-10 col-sm-10">
											<label class="col-form-label text-left col-lg-12 col-sm-12">
												<?php if($tributacao->regime == 1): ?>
												CST
												<?php else: ?>
												CSOSN
												<?php endif; ?>
											*</label>

											<select class="custom-select form-control" id="CST_CSOSN" name="CST_CSOSN">
												<?php $__currentLoopData = $listaCSTCSOSN; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($key); ?>" <?php if($config !=null): ?> <?php if(isset($produto)): ?> <?php if($key==$produto->CST_CSOSN): ?>
													selected
													<?php endif; ?>
													<?php else: ?>
													<?php if($key == $config->CST_CSOSN_padrao): ?>
													selected
													<?php endif; ?>
													<?php endif; ?>

													<?php endif; ?>
													><?php echo e($key); ?> - <?php echo e($c); ?>

												</option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>

										</div>
									</div>

									<div class="row">
										<div class="form-group validated col-lg-5 col-md-10 col-sm-10">
											<label class="col-form-label text-left col-lg-12 col-sm-12">CST PIS *</label>

											<select class="custom-select form-control" id="CST_CSOSN" name="CST_PIS">
												<?php $__currentLoopData = $listaCST_PIS_COFINS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($key); ?>" <?php if($config !=null): ?> <?php if(isset($produto)): ?> <?php if($key==$produto->CST_PIS): ?>
													selected
													<?php endif; ?>
													<?php else: ?>
													<?php if($key == $config->CST_PIS_padrao): ?>
													selected
													<?php endif; ?>
													<?php endif; ?>

													<?php endif; ?>
													><?php echo e($key); ?> - <?php echo e($c); ?>

												</option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>

										</div>

										<div class="form-group validated col-lg-5 col-md-10 col-sm-10">
											<label class="col-form-label text-left col-lg-12 col-sm-12">CST COFINS *</label>

											<select class="custom-select form-control" id="CST_CSOSN" name="CST_COFINS">
												<?php $__currentLoopData = $listaCST_PIS_COFINS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($key); ?>" <?php if($config !=null): ?> <?php if(isset($produto)): ?> <?php if($key==$produto->CST_COFINS): ?>
													selected
													<?php endif; ?>
													<?php else: ?>
													<?php if($key == $config->CST_COFINS_padrao): ?>
													selected
													<?php endif; ?>
													<?php endif; ?>

													<?php endif; ?>
													><?php echo e($key); ?> - <?php echo e($c); ?></option>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>

											</div>
										</div>

										<div class="row">
											<div class="form-group validated col-lg-10 col-md-10 col-sm-10">
												<label class="col-form-label text-left col-lg-12 col-sm-12">CST IPI *</label>

												<select class="custom-select form-control" id="CST_IPI" name="CST_IPI">
													<?php $__currentLoopData = $listaCST_IPI; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option value="<?php echo e($key); ?>" <?php if($config !=null): ?> <?php if(isset($produto)): ?> <?php if($key==$produto->CST_IPI): ?>
														selected
														<?php endif; ?>
														<?php else: ?>
														<?php if($key == $config->CST_IPI_padrao): ?>
														selected
														<?php endif; ?>
														<?php endif; ?>

														<?php endif; ?>
														><?php echo e($key); ?> - <?php echo e($c); ?>

													</option>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>

											</div>
										</div>

										<div class="row">
											<div class="form-group validated col-lg-10 col-md-10 col-sm-10">
												<label class="col-form-label text-left col-lg-12 col-sm-12">
													<?php if($tributacao->regime == 1): ?>
													CST Exportação
													<?php else: ?>
													CSOSN Exportação
													<?php endif; ?>
												*</label>

												<select class="custom-select form-control" id="CST_CSOSN_EXP" name="CST_CSOSN_EXP">
													<option value="">--</option>
													<?php $__currentLoopData = $listaCSTCSOSN; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option value="<?php echo e($key); ?>" <?php if(isset($produto)): ?> <?php if($key==$produto->CST_CSOSN_EXP): ?>
														selected
														<?php endif; ?>
														<?php endif; ?>

														><?php echo e($key); ?> - <?php echo e($c); ?>

													</option>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>

											</div>
										</div>

										<div class="row">
											<div class="form-group validated col-sm-4 col-lg-4">
												<label class="col-form-label">Código de Barras EAN13</label>
												<div class="">
													<input type="text" class="form-control <?php if($errors->has('codBarras')): ?> is-invalid <?php endif; ?>" name="codBarras" value="<?php echo e(isset($produto->codBarras) ? $produto->codBarras : old('codBarras')); ?>">
													<?php if($errors->has('codBarras')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('codBarras')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>
											<div class="form-group validated col-sm-4 col-lg-4">
												<label class="col-form-label">CFOP saida interno *</label>
												<div class="">
													<input type="text" id="CFOP_saida_estadual" class="form-control <?php if($errors->has('CFOP_saida_estadual')): ?> is-invalid <?php endif; ?>" name="CFOP_saida_estadual" 
													value="<?php echo e(isset($produto->CFOP_saida_estadual) ? $produto->CFOP_saida_estadual : $natureza->CFOP_saida_estadual); ?>">
													<?php if($errors->has('CFOP_saida_estadual')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('CFOP_saida_estadual')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>
											<div class="form-group validated col-sm-4 col-lg-4">
												<label class="col-form-label">CFOP saida externo *</label>
												<div class="">
													<input type="text" id="CFOP_saida_inter_estadual" class="form-control <?php if($errors->has('CFOP_saida_inter_estadual')): ?> is-invalid <?php endif; ?>" name="CFOP_saida_inter_estadual" 
													value="<?php echo e(isset($produto->CFOP_saida_inter_estadual) ? $produto->CFOP_saida_inter_estadual : $natureza->CFOP_saida_inter_estadual); ?>">
													<?php if($errors->has('CFOP_saida_inter_estadual')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('CFOP_saida_inter_estadual')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>
										</div>

										<div class="row">
											<div class="form-group validated col-sm-3 col-lg-3">
												<label class="col-form-label">%ICMS *</label>
												<div class="">
													<input type="text" id="perc_icms" class="form-control trib <?php if($errors->has('perc_icms')): ?> is-invalid <?php endif; ?>" name="perc_icms" 
													value="<?php echo e(isset($produto->perc_icms) ? $produto->perc_icms : $tributacao->icms); ?>">
													<?php if($errors->has('perc_icms')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('perc_icms')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>
											<div class="form-group validated col-sm-3 col-lg-3">
												<label class="col-form-label">%PIS *</label>
												<div class="">
													<input type="text" id="perc_pis" class="form-control trib <?php if($errors->has('perc_pis')): ?> is-invalid <?php endif; ?>" name="perc_pis" 
													value="<?php echo e(isset($produto->perc_pis) ? $produto->perc_pis : $tributacao->pis); ?>">
													<?php if($errors->has('perc_pis')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('perc_pis')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>
											<div class="form-group validated col-sm-3 col-lg-3">
												<label class="col-form-label">%COFINS *</label>
												<div class="">
													<input type="text" id="perc_cofins" class="form-control trib <?php if($errors->has('perc_cofins')): ?> is-invalid <?php endif; ?>" name="perc_cofins" 
													value="<?php echo e(isset($produto->perc_cofins) ? $produto->perc_cofins : $tributacao->cofins); ?>">
													<?php if($errors->has('perc_cofins')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('perc_cofins')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>
											<div class="form-group validated col-sm-3 col-lg-3">
												<label class="col-form-label">%IPI *</label>
												<div class="">
													<input type="text" id="perc_ipi" class="form-control trib <?php if($errors->has('perc_ipi')): ?> is-invalid <?php endif; ?>" name="perc_ipi" 
													value="<?php echo e(isset($produto->perc_ipi) ? $produto->perc_ipi : $tributacao->ipi); ?>">
													<?php if($errors->has('perc_ipi')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('perc_ipi')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>
										</div>

										<div class="row">
											<div class="form-group validated col-sm-3 col-lg-3">
												<label class="col-form-label">%ISS*</label>
												<div class="">
													<input type="text" id="perc_iss" class="form-control trib <?php if($errors->has('perc_iss')): ?> is-invalid <?php endif; ?>" name="perc_iss" 
													value="<?php echo e(isset($produto->perc_iss) ? $produto->perc_iss : 0.00); ?>">
													<?php if($errors->has('perc_iss')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('perc_iss')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>

											<div class="form-group validated col-sm-3 col-lg-3">
												<label class="col-form-label">%Redução BC *</label>
												<div class="">
													<input type="text" id="pRedBC" class="form-control <?php if($errors->has('pRedBC')): ?> is-invalid <?php endif; ?>" name="pRedBC" 
													value="<?php echo e(isset($produto->pRedBC) ? $produto->pRedBC : 0.00); ?>">
													<?php if($errors->has('pRedBC')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('pRedBC')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>

											<div class="form-group validated col-sm-3 col-lg-3">
												<label class="col-form-label">Cod benefício *</label>
												<div class="">
													<input type="text" id="cBenef" class="form-control <?php if($errors->has('cBenef')): ?> is-invalid <?php endif; ?>" name="cBenef" 
													value="<?php echo e(isset($produto->cBenef) ? $produto->cBenef : old('cBenef')); ?>">
													<?php if($errors->has('cBenef')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('cBenef')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>

											<div class="form-group validated col-sm-4 col-lg-4">
												<label class="col-form-label">Cod Lista Serviço (ISS)</label>
												<div class="">
													<input type="text" id="cListServ" class="form-control <?php if($errors->has('cListServ')): ?> is-invalid <?php endif; ?>" name="cListServ" value="<?php echo e(isset($produto->cListServ) ? $produto->cListServ : old('cListServ')); ?>">
													<?php if($errors->has('cListServ')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('cListServ')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>

											<div class="form-group validated col-lg-6 col-md-10 col-sm-10">
												<label class="col-form-label text-left col-lg-12 col-sm-12">Identificaçao ANP</label>

												<select class="custom-select form-control" id="anp" name="anp">
													<option value="">--</option>
													<?php $__currentLoopData = $anps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option value="<?php echo e($key); ?>" <?php if(isset($produto->codigo_anp)): ?>
														<?php if($key == $produto->codigo_anp): ?>
														selected=""
														<?php endif; ?>
														<?php endif; ?> >[<?php echo e($key); ?>] - <?php echo e($a); ?>

													</option>

													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>

											</div>
										</div>


										<div class="row">
											<div class="form-group validated col-lg-12 col-md-12 col-sm-12">
												<label class="col-xl-12 col-lg-12 col-form-label text-left">Imagem</label>
												<div class="col-lg-12 col-xl-12">




													<div class="image-input image-input-outline" id="kt_image_1">
														<div class="image-input-wrapper" <?php if(!isset($produto) || $produto->imagem == ''): ?> style="background-image: url(/imgs/no_image.png)" <?php else: ?>
															style="background-image: url(/imgs_produtos/<?php echo e($produto->imagem); ?>)"
															<?php endif; ?>>

														</div>
														<label class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="change" data-toggle="tooltip" title="" data-original-title="Change avatar">
															<i class="fa fa-pencil icon-sm text-muted"></i>
															<input type="file" name="file" accept=".png, .jpg, .jpeg">
															<input type="hidden" name="profile_avatar_remove">
														</label>
														<span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="cancel" data-toggle="tooltip" title="" data-original-title="Cancel avatar">
															<i class="fa fa-close icon-xs text-muted"></i>
														</span>
													</div>

													<span class="form-text text-muted">.png, .jpg, .jpeg</span>
													<?php if($errors->has('file')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('file')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>
										</div>

										<div class="row">
											<div class="form-group validated col-lg-12 col-md-12 col-sm-12">
												<label class="col-xl-12 col-lg-12 col-form-label text-left">Composto</label>
												<div class="col-lg-12 col-xl-12">
													<span class="switch switch-outline switch-success">
														<label>
															<input <?php if(isset($produto->composto) && $produto->composto): ?> checked <?php endif; ?> value="true" name="composto" class="red-text" type="checkbox">
															<span></span>
														</label>
													</span>

													<p class="text-danger">*Produzido no estabelecimento composto de outros produtos já cadastrados, deverá ser criado uma receita para redução de estoque. </p>

												</div>
											</div>
										</div>

									</div>

									<hr>

									<h3>Dados de dimensão e peso do produto (Opcional)</h3>
									<div class="row">

										<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Largura (cm)</label>

											<input type="text" id="largura" class="form-control <?php if($errors->has('largura')): ?> is-invalid <?php endif; ?>" name="largura" 
											value="<?php echo e(isset($produto->largura) ? $produto->largura : ''); ?>">
										</div>

										<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Altura (cm)</label>

											<input type="text" id="altura" class="form-control <?php if($errors->has('altura')): ?> is-invalid <?php endif; ?>" name="altura" 
											value="<?php echo e(isset($produto->altura) ? $produto->altura : ''); ?>">
										</div>

										<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Comprimento (cm)</label>

											<input type="text" id="comprimento" class="form-control <?php if($errors->has('comprimento')): ?> is-invalid <?php endif; ?>" name="comprimento" value="<?php echo e(isset($produto->comprimento) ? $produto->comprimento : ''); ?>">
										</div>
									</div>

									<div class="row">

										<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Peso liquido</label>

											<input type="text" id="peso_liquido" class="form-control <?php if($errors->has('peso_liquido')): ?> is-invalid <?php endif; ?>" name="peso_liquido" 
											value="<?php echo e(isset($produto->peso_liquido) ? $produto->peso_liquido : ''); ?>">
										</div>

										<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
											<label class="col-form-label text-left col-lg-12 col-sm-12">Peso bruto</label>

											<input type="text" id="peso_bruto" class="form-control <?php if($errors->has('peso_bruto')): ?> is-invalid <?php endif; ?>" name="peso_bruto" 
											value="<?php echo e(isset($produto->peso_bruto) ? $produto->peso_bruto : ''); ?>">
										</div>

										<div class="col-lg-12 col-xl-12">
											<p class="text-danger">*Se atente a preencher todos os dados para utilizar a Api dos correios.</p>
										</div>

									</div>

									<?php if(getenv('DELIVERY') == 1): ?>
									<div class="row">
										<div class="form-group validated col-lg-12 col-md-12 col-sm-12">
											<label class="col-xl-12 col-lg-12 col-form-label text-left">Atribuir ao Delivery</label>
											<div class="col-lg-12 col-xl-12">
												<span class="switch switch-outline switch-success">
													<label>
														<input <?php if(isset($produto->delivery) && $produto->delivery): ?> checked <?php endif; ?> value="true" name="atribuir_delivery" class="red-text" type="checkbox" id="atribuir_delivery">
														<span></span>
													</label>
												</span>

											</div>
										</div>
									</div>

									<?php endif; ?>
									<?php if(getenv('DELIVERY') == 1): ?>
									<div id="delivery" style="display: none">

										<div class="row">
											<div class="form-group validated col-lg-3 col-md-6 col-sm-3">
												<label class="col-xl-12 col-lg-12 col-form-label text-left">Destaque</label>
												<div class="col-lg-12 col-xl-12">
													<span class="switch switch-outline switch-success">
														<label>
															<input <?php if(isset($produto->delivery->destaque) && $produto->delivery->destaque): ?>
															checked <?php endif; ?> value="true" name="destaque" class="red-text" type="checkbox">
															<span></span>
														</label>
													</span>

												</div>
											</div>

											<div class="form-group validated col-sm-6 col-lg-4">
												<label class="col-form-label">Limite Diário de venda *</label>
												<div class="">
													<input type="text" id="limite_diario" class="form-control <?php if($errors->has('limite_diario')): ?> is-invalid <?php endif; ?>" name="limite_diario" value="<?php echo e(isset($produto->limite_diario) ? $produto->limite_diario : old('limite_diario')); ?>">
													<?php if($errors->has('limite_diario')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('limite_diario')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>

											<div class="form-group validated col-sm-8 col-lg-5">
												<label class="col-form-label text-left col-12">Categoria de Delivery</label>

												<select class="custom-select form-control" id="categoria_delivery_id" name="categoria_delivery_id">
													<?php $__currentLoopData = $categoriasDelivery; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<option value="<?php echo e($cat->id); ?>" <?php if(isset($produto->delivery)): ?><?php if($cat->id == $produto->delivery->categoria_id): ?>
														selected=""
														<?php endif; ?>
														<?php endif; ?> ><?php echo e($cat->nome); ?>

													</option>

													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</select>

											</div>

										</div>

										<div class="row">
											<div class="form-group validated col-sm-6 col-lg-6">
												<label class="col-form-label">Descrição</label>
												<div class="">
													<textarea class="form-control" name="descricao" placeholder="Descrição" rows="3"><?php echo e(isset($produto->delivery->descricao) ? $produto->delivery->descricao : old('descricao')); ?></textarea>
													<?php if($errors->has('descricao')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('descricao')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>
											<div class="form-group validated col-sm-6 col-lg-6">
												<label class="col-form-label">Ingredientes</label>
												<div class="">
													<textarea class="form-control" name="ingredientes" placeholder="Enter a menu" rows="3"><?php echo e(isset($produto->delivery->ingredientes) ? $produto->delivery->ingredientes : old('ingredientes')); ?></textarea>
													<?php if($errors->has('ingredientes')): ?>
													<div class="invalid-feedback">
														<?php echo e($errors->first('ingredientes')); ?>

													</div>
													<?php endif; ?>
												</div>
											</div>
										</div>


									</div>
									<?php endif; ?>

								</div>
							</div>
						</div>
						<div class="card-footer">

							<div class="row">
								<div class="col-xl-2">

								</div>
								<div class="col-lg-3 col-sm-6 col-md-4">
									<a style="width: 100%" class="btn btn-danger" href="/produtos">
										<i class="la la-close"></i>
										<span class="">Cancelar</span>
									</a>
								</div>
								<div class="col-lg-3 col-sm-6 col-md-4">
									<button style="width: 100%" type="submit" class="btn btn-success">
										<i class="la la-check"></i>
										<span class="">Salvar</span>
									</button>
								</div>

							</div>
						</div>
					</div>
				</div>

			</form>
		</div>
	</div>
</div>
</div>

<div class="modal fade" id="modal-categoria" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Nova Categoria</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">

				<div class="row">
					<div class="col-xl-12">

						
						<div class="row">

							<div class="form-group validated col-12">
								<label class="col-form-label" id="lbl_cpf_cnpj">Nome</label>
								<div class="">
									<input type="text" id="nome_categoria" class="form-control <?php if($errors->has('nome')): ?> is-invalid <?php endif; ?>" name="nome">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" id="btn-frete" class="btn btn-danger font-weight-bold spinner-white spinner-right" data-dismiss="modal" aria-label="Close">Fechar</button>
				<button type="button" onclick="salvarCategoria()" class="btn btn-success font-weight-bold spinner-white spinner-right">Salvar</button>
			</div>
		</div>
	</div>
</div>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">

	$(function () {
		let is = $('.ecommerce').is(':checked');
		if(is){
			$('.div-ecommmerce').css('display', 'block')
		}else{
			$('.div-ecommmerce').css('display', 'none')
		}
	});
	$('.ecommerce').change((target) => {
		let is = $('.ecommerce').is(':checked');
		if(is){
			$('.div-ecommmerce').css('display', 'block')
		}else{
			$('.div-ecommmerce').css('display', 'none')

		}
	})

	function novaCategoria(){
		$('#modal-categoria').modal('show')

	}

	function salvarCategoria(){
		let nome = $('#nome_categoria').val()
		if(!nome){
			swal("Erro", "Informe nome", "warning")
		}else{
			let token = $('#_token').val();
			$.post(path + 'categorias/quickSave',
			{
				_token: token,
				nome: nome
			})
			.done((res) =>{

				console.log(res)
				$('#categoria').append('<option value="'+res.id+'">'+ 
					res.nome+'</option>').change();
				$('#categoria').val(res.id).change();
				swal("Sucesso", "Categoria adicionada!!", 'success')
				.then(() => {
					$('#modal-categoria').modal('hide')
				})
			})
			.fail((err) => {
				console.log(err)
				swal("Erro", "Algo deu errado!!", 'error')

			})
		}
	}

</script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/produtos/duplicar.blade.php ENDPATH**/ ?>