@extends('relatorios.cabecalho')
@section('content')
<style type="text/css">
	th{
		font-size: 12px;
	}
	td{
		font-size: 10px;
	}
</style>
<div class="row">
	<div class="col s12">
		<h3 class="center-align">Relatório de Vendas</h3>
		@if($data_inicial && $data_final)
		<h4>Periodo: {{$data_inicial}} - {{$data_final}}</h4>
		@endif
	</div>

	<table class="pure-table">
		<thead>
			<tr>
				<th width="70">DATA</th>
				<th width="70">ID</th>
				<th width="100">VENDEDOR</th>
				<th width="120">CLIENTE</th>
				<th width="80">FORMA DE PAGAMENTO</th>
				<th width="80">DESPESAS OPERACIONAIS</th>
				<th width="80">DESCONTO</th>
				<th width="80">VALOR VENDA LIQUIDA</th>
				<th width="80">VALOR TOTAL</th>
			</tr>
		</thead>
		@php
		$somaPedido = 0;
		$somaPedidoLiquido = 0;
		$somaPdv = 0;
		$somaDesconto = 0;
		@endphp
		<tbody>
			@foreach($vendas as $key => $v)
			<tr class="@if($key%2 == 0) pure-table-odd @endif">
				<td><center>{{\Carbon\Carbon::parse($v->created_at)->format('d/m/Y H:i')}}</center></td>
				<td><center>{{$v->id}}</center></td>
				<td><center>{{$v->vendedor()}}</center></td>
				<td><center>{{$v->cliente ? $v->cliente->razao_social : 'Consumidor final'}}</center></td>
				@if(isset($v->cpf))
				<td><center>{{$v->getTipoPagamento2()}}</center></td>
				@else
				<td><center>{{$v->getTipoPagamento()}}</center></td>
				@endif
				@if($v->tbl == 'pdv')
				<td><center>R$ 0,00</center></td>

				<td><center>R$ {{number_format($v->desconto, 2, ',', '.')}}</center></td>
				<td><center>R$ {{number_format($v->valor_total, 2, ',', '.')}}</center></td>
				<td><center>R$ {{number_format($v->valor_total+$v->desconto, 2, ',', '.')}}</center></td>
				@else
				<td><center>R$ {{ $v->valorDespesaOperacionais() }}</center></td>
				<td><center>R$ {{number_format($v->desconto, 2, ',', '.')}}</center></td>
				<td><center>R$ {{ number_format($v->valorLiquido(), 2, ',', '.') }}</center></td>
				<td><center>R$ {{number_format($v->valor_total, 2, ',', '.')}}</center></td>
				@endif
				
			</tr>

			@php
			if(!isset($v->cpf)){
			$somaPedido += $v->valor_total;
			$somaPedidoLiquido += $v->valorLiquido();
			}else{
			$somaPdv += $v->valor_total;
			}
			$somaDesconto += $v->desconto
			@endphp
			@endforeach
		</tbody>
	</table>

	<h4>Soma Pedido: <strong style="color: blue">{{number_format($somaPedido, 2, ',', '.')}}</strong></h4>
	<h4>Soma Pedido Liquido: <strong style="color: blue">{{number_format($somaPedidoLiquido, 2, ',', '.')}}</strong></h4>
	<h4>Soma PDV: <strong style="color: purple">{{number_format($somaPdv, 2, ',', '.')}}</strong></h4>

	<h3>Total: <strong style="color: green">{{number_format($somaPedidoLiquido + $somaPdv, 2, ',', '.')}}</strong></h3>
	<h3>Soma Desconto: <strong style="color: red">{{number_format($somaDesconto, 2, ',', '.')}}</strong></h3>
</div>
@endsection
