@extends('relatorios.cabecalho')
@section('content')
<div class="row">
	<div class="col s12">
		<h3 class="center-align">Relátorio de Cadastro de Produtos</h3>
		@if($d1 && $d2)
		<h4>Periodo: {{$d1}} - {{$d2}}</h4>
		@endif
	</div>

	<table class="pure-table">
		<thead>
			<tr>
				<th style="width: 200px;">CLIENTE</th>
				<th style="width: 80px;">DATA</th>
				<th style="width: 80px;">ESTADO</th>
				<th style="width: 120px;">CHAVE</th>
				<th style="width: 80px;">NÚMERO</th>
				<!-- <th width="150">ITENS VENDIDOS</th> -->
			</tr>
		</thead>

		<tbody>
			@foreach($data as $key => $d)
			<tr class="@if($key%2 == 0) pure-table-odd @endif">
				<td><center>{{$d['cliente'] == '' ? 'Consumidor Final' : $d['cliente']}}</center></td>
				<td><center>{{$d['data']}}</center></td>
				<td><center>{{$d['estado']}}</center></td>
				<td><center>{{$d['chave']}}</center></td>
				<td><center>{{$d['numero']}}</center></td>
			</tr>
			@endforeach
		</tbody>
	</table>
	<br>
	<h1>Total de documentos: <strong class="text-success">{{sizeof($data)}}</strong></h1>
</div>

@endsection
