<?php $__env->startSection('content'); ?>

<style type="text/css">
	.card-stretch:hover{
		cursor: pointer;
	}
</style>
<div class="card card-custom gutter-b">

	<div class="card-body <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">
		<div class="content d-flex flex-column flex-column-fluid" id="kt_content" >

			<div class="row" id="anime" style="display: none">
				<div class="col s8 offset-s2">
					<lottie-player src="/anime/success.json" background="transparent" speed="0.8" style="width: 100%; height: 300px;" autoplay >
					</lottie-player>
				</div>
			</div>

			<div class="col-lg-12" id="content">
				<h3 class="card-title">PAGAMENTO DE PLANO</h3>

				<form method="post" action="/payment/setPlano">
					<?php echo csrf_field(); ?>
					<input id="plano" type="hidden" name="plano" value="<?php echo e($plano->plano_id); ?>">

					<div class="row">

						<?php $__currentLoopData = $planos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="col-xl-4 h-t" onclick="selectPlan(<?php echo e($p); ?>)">
							<!--begin::Nav Panel Widget 2-->
							<div class="card card-custom card-stretch gutter-b <?php if($p->id == $plano->plano_id): ?> bg-light-danger <?php endif; ?>" id="plan_<?php echo e($p->id); ?>">
								<!--begin::Body-->
								<div class="card-body">
									<!--begin::Wrapper-->
									<div class="d-flex justify-content-between flex-column pt-4 h-100">
										<!--begin::Container-->
										<div class="pb-5">
											<!--begin::Header-->
											<div class="d-flex flex-column flex-center">
												<!--begin::Symbol-->
												<div class="symbol symbol-120 symbol-circle symbol-success overflow-hidden">
													<span class="symbol-label">
														<?php if($p->img != ''): ?>
														<img src="/imgs_planos/<?php echo e($p->img); ?>" class="h-100 align-self-end" alt="">
														<?php else: ?>
														<img src="/imgs_planos/sem_imagem.png" class="h-100 align-self-end" alt="">
														<?php endif; ?>

													</span>
												</div>

												<a class="card-title font-weight-bolder text-dark-75 text-hover-primary font-size-h4 m-0 pt-7 pb-1"><?php echo e($p->nome); ?></a>

												<h2 class="card-title font-weight-bolder text-info text-hover-primary font-size-h4 m-0 pt-7 pb-1">R$ <?php echo e(number_format($p->valor, 2, ',', '.')); ?></h2>

											</div>
											<div class="pt-1">
												<!--begin::Text-->
												<p class="text-dark-75 font-weight-nirmal font-size-lg m-0 pb-7">
													<?php echo $p->descricao; ?>

												</p>
												<!--end::Text-->

												<!--end::Item-->
											</div>
											<!--end::Body-->
										</div>
										<!--eng::Container-->
										<!--end::Footer-->
									</div>
									<!--end::Wrapper-->
								</div>
								<!--end::Body-->
							</div>
							<!--end::Nav Panel Widget 2-->
						</div>

						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</div>

					<div class="row">

						<button type="submit" style="width: 100%;" class="btn btn-success font-weight-bolder text-uppercase px-9 py-4" data-wizard-type="action-submit">
							<i class="la la-check"></i>
							ESCOLHER
						</button>
					</div>
				</form>

				<input type="hidden" value="<?php echo e($pay); ?>" id="pay">

				<!--end::Form-->
			</div>
		</div>
	</div>
</div>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">

	$(function(){
		let pay = $('#pay').val();
		pay = JSON.parse(pay);

		console.log(pay)

		if(pay){

			swal({
				title: "Alerta",
				text: "Voçe possui uma fatura gerada para o plano",
				icon: "warning",
				buttons: [
				'Gerar nova',
				'ir para fatura'
				],
			}).then((acao) => {
				if(acao){
					location.href = path + 'payment/'+pay.transacao_id
				}else{

				}
			})
		}
	})

	function selectPlan(plano){
		console.log(plano)

		$('.card-stretch').removeClass('bg-light-danger')
		$('#plan_'+plano.id).addClass('bg-light-danger')

		$('#plano').val(plano.id)
	}
</script>

<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nextsistemas/nextweb.nextsistemas.app.br/resources/views/payment/index.blade.php ENDPATH**/ ?>