<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">

	<div class="card-body">
		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
			<div class="col-12">
				<div class="row">

					<a style="margin-left: 5px; margin-top: 5px;" href="/clientes/new" class="btn btn-lg btn-success">
						<i class="fa fa-plus"></i>Novo Cliente
					</a>

					<?php if(isset($paraImprimir)): ?>
					<form method="post" action="/clientes/relatorio">
						<?php echo csrf_field(); ?>
						<input type="hidden" name="pesquisa" value="<?php echo e(isset($pesquisa) ? $pesquisa : ''); ?>">

						<input type="hidden" name="aniversariante" value="<?php echo e($aniversariante); ?>">
						<button style="margin-left: 5px; margin-top: 5px;" class="btn btn-lg btn-info">
							<i class="fa fa-print"></i>Imprimir relatório
						</button>
					</form>
					<?php endif; ?>

					<a style="margin-left: 5px; margin-top: 5px;" href="/clientes/importacao" class="btn btn-lg btn-danger">
						<i class="fa fa-arrow-up"></i>Importação
					</a>

				</div>
			</div>
		</div>
		<br>

		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<form method="get" action="/clientes/pesquisa">
				<div class="row align-items-center">

					<div class="col-lg-2 col-xl-2">
						<div class="row align-items-center">
							<div class="col-md-12 my-2 my-md-0">
								<div class="input-group">

									<select name="tipo_pesquisa" class="custom-select">
										<?php $__currentLoopData = App\Models\Cliente::tiposPesquisa(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option <?php if(isset($tipoPesquisa)): ?> <?php if($tipoPesquisa == $key): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($key); ?>"><?php echo e($t); ?></option>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</select>
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-5 col-xl-5">
						<div class="row align-items-center">
							<div class="col-md-12 my-2 my-md-0">
								<div class="input-group">
									<input type="text" name="pesquisa" class="form-control" placeholder="Pesquisa cliente" id="kt_datatable_search_query" value="<?php echo e(isset($pesquisa) ? $pesquisa : ''); ?>">
									
									<div class="input-group-prepend">
										<span class="input-group-text">
											<i class="la la-birthday-cake"></i>
										</span>
									</div>
									<div class="input-group-append">
										<span class="input-group-text">
											<label class="checkbox checkbox-inline checkbox-info">
												<input type="checkbox" name="aniversariante" <?php if(isset($aniversariante)): ?> <?php if($aniversariante == true): ?> checked <?php endif; ?> <?php endif; ?>/>
												<span></span>
											</label>
										</span>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="col-lg-2 col-xl-2 mt-2 mt-lg-0">
						<button class="btn btn-light-primary px-6 font-weight-bold">Pesquisa</button>
					</div>
				</div>

			</form>
			<br>
			<h4>Lista de Clientes</h4>
			<?php if(isset($totalGeralClientes)): ?>
			<label>Total de clientes cadastrados: <strong class="text-info"><?php echo e($totalGeralClientes); ?></strong></label>
			<?php endif; ?>
			<div class="row">

				<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">

					<div class="wizard wizard-3" id="kt_wizard_v3" data-wizard-state="between" data-wizard-clickable="true">
						<div class="wizard-nav">

							<div class="wizard-steps px-8 py-8 px-lg-15 py-lg-3">
								<!--begin::Wizard Step 1 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="done">
									<div class="wizard-label">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-table"></i>
												Tabela
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>
								<!--end::Wizard Step 1 Nav-->
								<!--begin::Wizard Step 2 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="current">
									<div class="wizard-label" id="grade">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-tablet"></i>
												Grade
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>

							</div>
						</div>

						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">
								<div class="col-xl-12">

									<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

										<table class="datatable-table" style="max-width: 100%; overflow: scroll">
											<thead class="datatable-head">
												<tr class="datatable-row" style="left: 0px;">
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 250px;">RAZÃO SOCIAL</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">NOME FANTASIA</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">CPF/CNPJ</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">IE/RG</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">CIDADE</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">TELEFONE</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">EMAIL</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">DATA DE CADASTRO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">DATA DE ANIVERSÁRIO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">AÇÕES</span></th>
												</tr>
											</thead>
											<tbody id="body" class="datatable-body">
												<?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr class="datatable-row">
													<td class="datatable-cell"><span class="codigo" style="width: 250px;" id="id"><?php echo e($c->razao_social); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 150px;" id="id"><?php echo e($c->nome_fantasia); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 150px;" id="id"><?php echo e($c->cpf_cnpj); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e($c->ie_rg); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 200px;" id="id"><?php echo e($c->cidade->nome); ?> (<?php echo e($c->cidade->uf); ?>)</span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 120px;" id="id"><?php echo e($c->telefone); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e($c->email); ?></span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 100px;" id="id">
															<?php echo e(\carbon\carbon::parse($c->created_at)->format('d/m/Y')); ?>

														</span>
													</td>

													<?php if($c->data_aniversario != ""): ?>
													<td class="datatable-cell">
														<span class="codigo" style="width: 100px;" id="id">
															<?php echo e($c->data_aniversario); ?>

														</span>
													</td>
													<?php else: ?>
													<td class="datatable-cell">
														<span class="codigo" style="width: 100px;" id="id">
															--
														</span>
													</td>
													<?php endif; ?>

													<td class="datatable-cell">
														<span class="codigo" style="width: 200px;" id="id">
															<a class="btn btn-warning" onclick='swal("Atenção!", "Deseja editar este registro?", "warning").then((sim) => {if(sim){ location.href="/clientes/edit/<?php echo e($c->id); ?>" }else{return false} })' href="#!">
																<i class="la la-edit"></i>	
															</a>
															<a class="btn btn-danger" onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/clientes/delete/<?php echo e($c->id); ?>" }else{return false} })' href="#!">
																<i class="la la-trash"></i>	
															</a>
															
														</span>
													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>

						</div>

						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">

								<?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

								<div class="col-sm-12 col-lg-6 col-md-6 col-xl-4">
									<div class="card card-custom gutter-b example example-compact">
										<div class="card-header">
											<div class="card-title">
												<h3 style="width: 230px; font-size: 12px; height: 10px;" class="card-title"><?php echo e(substr($c->razao_social, 0, 30)); ?>

												</h3>
											</div>

											<div class="card-toolbar">
												<div class="dropdown dropdown-inline" data-toggle="tooltip" title="" data-placement="left" data-original-title="Ações">
													<a href="#" class="btn btn-hover-light-primary btn-sm btn-icon" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
														<i class="fa fa-ellipsis-h"></i>
													</a>
													<div class="dropdown-menu p-0 m-0 dropdown-menu-md dropdown-menu-left">
														<!--begin::Navigation-->
														<ul class="navi navi-hover">
															<li class="navi-header font-weight-bold py-4">
																<span class="font-size-lg">Ações:</span>
															</li>
															<li class="navi-separator mb-3 opacity-70"></li>
															<li class="navi-item">
																<a href="/clientes/edit/<?php echo e($c->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-primary">Editar</span>
																	</span>
																</a>
															</li>
															<li class="navi-item">
																<a onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/clientes/delete/<?php echo e($c->id); ?>" }else{return false} })' href="#!" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-danger">Excluir</span>
																	</span>
																</a>
															</li>


														</ul>
														<!--end::Navigation-->
													</div>
												</div>

											</div>

											<div class="card-body">

												<div class="kt-widget__info">
													<span class="kt-widget__label">Nome fantasia:</span>
													<a target="_blank" class="kt-widget__data text-success"><?php echo e($c->nome_fantasia); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">CNPJ/CPF:</span>
													<a target="_blank" class="kt-widget__data text-success"><?php echo e($c->cpf_cnpj); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">IE/RG:</span>
													<a class="kt-widget__data text-success"><?php echo e($c->ie_rg); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Cidade:</span>
													<a class="kt-widget__data text-success"><?php echo e($c->cidade->nome); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Data de cadastro:</span>
													<a class="kt-widget__data text-success">
														<?php echo e(\carbon\carbon::parse($c->created_at)->format('d/m')); ?>

													</a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Data de aniversário:</span>
													<a class="kt-widget__data text-success">
														<?php if($c->data_aniversario != ""): ?>
														<?php echo e($c->data_aniversario); ?>

														<?php else: ?>
														--
														<?php endif; ?>
													</a>
												</div>

												<div class="kt-widget__info">
													<span class="kt-widget__label">UF:</span>
													<a class="kt-widget__data text-success"><?php echo e($c->cidade->uf); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Telefone:</span>
													<a class="kt-widget__data text-success"><?php echo e($c->telefone); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Email:</span>
													<a class="kt-widget__data text-success"><?php echo e($c->email); ?></a>
												</div>

											</div>

										</div>

									</div>

								</div>

								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</div>
						</div>
					</div>
				</div>

			</div>

			<div class="d-flex justify-content-between align-items-center flex-wrap">
				<div class="d-flex flex-wrap py-2 mr-3">
					<?php if(isset($links)): ?>
					<?php echo e($clientes->links()); ?>

					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcos/Documents/laravel/metronic_multi_8.4/resources/views/clientes/list.blade.php ENDPATH**/ ?>