<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">

	<div class="card-body">
		<div class="" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">
			<div class="col-lg-12" id="content">
				<!--begin::Portlet-->

				<?php
				$estado = $abertura == null ? false : true;
				?>
				<h2 class="card-title">Estado:
					<?php if($estado): ?>
					<span class="label label-xl label-inline label-light-success">Caixa aberto</span>
					<?php else: ?>
					<span class="label label-xl label-inline label-light-danger">Caixa fechado</span>
					<?php endif; ?>
				</h2>

				<div class="row">
					<div class="col-xl-12">
						<?php if(!$estado): ?>
						<a data-toggle="modal" href="#!" data-target="#modal-abrir-caixa" class="btn btn-light-success">
							<i class="las la-book-open"></i>
							ABRIR CAIXA
						</a>
						<?php endif; ?>

						<?php if($estado): ?>


						<a data-toggle="modal" href="#!" data-target="#modal-supri" class="btn btn-light-info">
							<i class="las la-money-bill"></i>
							SUPRIMENTO DE CAIXA
						</a>

						<a data-toggle="modal" href="#!" data-target="#modal-sangria" class="btn btn-light-danger">
							<i class="las la-hand-holding-usd"></i>
							SANGRIA DE CAIXA
						</a>

						<?php endif; ?>

						<a href="/caixa/list" class="btn btn-light-primary">
							<i class="la la-list"></i>
							LISTA
						</a>
					</div>
				</div>

				<br>

				<?php if($estado): ?>
				<?php if(sizeof($caixa) > 0): ?>
				<h2 class="card-title">Total de vendas: <strong class="text-info"><?php echo e(sizeof($caixa['vendas'])); ?></strong></h2>

				<h2 class="card-title text-success">Valor de abertura: <strong class=""><?php echo e(number_format($abertura->valor, 2, ',', '.')); ?></strong></h2>
				<?php endif; ?>
				<?php endif; ?>

				<?php
				$somaDinheiro = 0;
				?>
				<?php if(sizeof($caixa) > 0): ?>
				<div class="row">
					<div class="col-xl-12">
						<h3 class="text-info">Total por tipo de pagamento:</h3>
						<div class="kt-section kt-section--first">
							<div class="kt-section__body">
								<div class="row">

									<?php $__currentLoopData = $caixa['somaTiposPagamento']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<?php if($tp > 0): ?>
									<div class="col-sm-4 col-lg-4 col-md-6">
										<div class="card card-custom gutter-b">
											<div class="card-header">
												<h3 class="card-title">
													<?php echo e(App\Models\VendaCaixa::getTipoPagamento($key)); ?>

												</h3>
											</div>

											<?php
											if($key == '01') $somaDinheiro = $tp;
											?>
											<div class="card-body">
												<h4 class="text-success">R$ <?php echo e(number_format($tp, 2, ',', '.')); ?></h4>
											</div>

										</div>
									</div>
									<?php endif; ?>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

								</div>
							</div>
						</div>
					</div>
				</div>
				<?php endif; ?>


				<div class="row">
					<div class="col-xl-12">

						<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

							<table class="datatable-table" style="max-width: 100%; overflow: scroll">
								<thead class="datatable-head">
									<tr class="datatable-row" style="left: 0px;">
										
										<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">Cliente</span></th>
										<th data-field="Country" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Data</span></th>
										<th data-field="ShipDate" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Tipo de pagamento</span></th>

										<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Estado</span></th>

										<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">NFCe/NFe</span></th>

										<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Tipo</span></th>

										<th data-field="CompanyName" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">Valor</span></th>
									</tr>
								</thead>

								<tbody class="datatable-body">
									<?php
									$soma = 0;
									
									?>

									<?php if(sizeof($caixa) > 0): ?>

									<?php $__currentLoopData = $caixa['vendas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

									<tr class="datatable-row" >
										
										<td class="datatable-cell"><span class="codigo" style="width: 150px;"><?php echo e($v->cliente->razao_social ?? 'NAO IDENTIFCADO'); ?></span>
										</td>
										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e(\Carbon\Carbon::parse($v->created_at)->format('d/m/Y H:i:s')); ?></span>
										</td>
										<td class="datatable-cell">
											<span class="codigo" style="width: 100px;">

												<?php if($v->tipo_pagamento == '99'): ?>

												Outros
												<?php else: ?>
												<?php echo e($v->getTipoPagamento($v->tipo_pagamento)); ?>

												<?php endif; ?>

											</span>
										</td>
										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e($v->estado); ?></span>
										</td>
										<?php if($v->tipo == 'PDV'): ?>
										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e($v->NFcNumero > 0 ? $v->NFcNumero : '--'); ?></span>
										</td>
										<?php else: ?>
										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e($v->NfNumero > 0 ? $v->NfNumero : '--'); ?></span>
										</td>
										<?php endif; ?>

										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e($v->tipo); ?></span>
										</td>

										<?php if(!isset($v->cpf)): ?>
										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e(number_format($v->valor_total-$v->desconto+$v->acrescimo, 2, ',', '.')); ?></span>
										</td>
										<?php else: ?>
										<td class="datatable-cell"><span class="codigo" style="width: 100px;"><?php echo e(number_format($v->valor_total, 2, ',', '.')); ?></span>
										</td>
										<?php endif; ?>

									</tr>
									
									<?php if($v->estado != 'CANCELADO'): ?>
									<?php
									if(!isset($v->cpf))
									$soma += $v->valor_total-$v->desconto+$v->acrescimo;
									else
									$soma += $v->valor_total;

									?>

									<?php endif; ?>
									
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									<?php endif; ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
				<br>

				<?php
				$somaSuprimento = 0;
				$somaSangria = 0;
				?>


				<?php if(sizeof($caixa) > 0): ?>
				<div class="row">
					<div class="col-12 col-xl-6">
						<div class="card card-custom gutter-b bg-light-info">

							<div class="card-body">
								<h2 class="card-title">Suprimentos:</h2>

								<?php if(sizeof($caixa['suprimentos']) > 0): ?>
								<?php $__currentLoopData = $caixa['suprimentos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<h4>Valor: R$ <?php echo e(number_format($s->valor, 2, ',', '.')); ?></h4>
								<?php
								$somaSuprimento += $s->valor;
								?>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<?php else: ?>
								<h4>R$ 0,00</h4>
								<?php endif; ?>
							</div>			
						</div>			
					</div>	

					<div class="col-12 col-xl-6">
						<div class="card card-custom gutter-b bg-light-danger">

							<div class="card-body">
								<h2 class="card-title">Sangrias:</h2>

								<?php if(sizeof($caixa['sangrias']) > 0): ?>
								<?php $__currentLoopData = $caixa['sangrias']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<h4>Valor: R$ <?php echo e(number_format($s->valor, 2, ',', '.')); ?></h4>
								<?php
								$somaSangria += $s->valor;
								?>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								<?php else: ?>
								<h4>R$ 0,00</h4>
								<?php endif; ?>
							</div>			
						</div>			
					</div>		
				</div>
				<?php endif; ?>

				<?php if(sizeof($caixa) == 0): ?>
				<h2 class="text-danger text-center">NÃO É POSSÍVEL FECHAR SEM NENHUMA VENDA</h2>
				<?php else: ?>
				<h2 class="text-warning">Soma de vendas: 
					<strong><?php echo e(number_format($soma, 2, ',', '.')); ?></strong>
				</h2>

				<h2 class="text-info">Total caixa dinheiro: 

					<strong>
						<?php echo e(number_format(($somaDinheiro + $somaSuprimento + $abertura->valor) - $somaSangria, 2, ',', '.')); ?>

					</strong>
				</h2>

				<h2 class="text-success">Total Geral: 
					<strong>
						<?php echo e(number_format(($soma + $somaSuprimento + $abertura->valor) - $somaSangria, 2, ',', '.')); ?>

					</strong>
				</h2>
				<?php endif; ?>

				<div class="row">
					<div class="col-12">
						<form method="post" action="/frenteCaixa/fechar">
							<?php echo csrf_field(); ?>
							<input type="hidden" name="abertura_id" value="<?php echo e($abertura != null ? $abertura->id : 0); ?>">
							<input type="hidden" name="redirect" value="/caixa">
							<button <?php if(sizeof($caixa) == 0): ?> disabled <?php endif; ?> class="btn btn-lg btn-danger">
								<i class="la la-times"></i>
								Fechar Caixa
							</button>
						</form>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>

<input type="hidden" id="_token" value="<?php echo e(csrf_token()); ?>" name="">

<div class="modal fade" id="modal-abrir-caixa" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog modal-sm" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Abertura de caixa</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="form-group validated col-sm-12 col-lg-12">
						<label class="col-form-label" id="">Valor</label>
						<div class="">
							<input type="text" id="valor" name="valor" class="form-control money" value="">
						</div>
					</div>
				</div>

			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-light-danger font-weight-bold" data-dismiss="modal">Fechar</button>
				<button type="button" onclick="abrirCaixa()" class="btn btn-light-success font-weight-bold">Abrir</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-supri" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog modal-md" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">SUPRIMENTO DE CAIXA</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="form-group validated col-sm-6 col-lg-6 col-6">
						<label class="col-form-label" id="">Valor</label>
						<input type="text" placeholder="Valor" id="valor_suprimento" name="valor_sangria" class="form-control money" value="">
					</div>
				</div>

				<div class="row">
					<div class="form-group validated col-sm-12 col-lg-12 col-12">
						<label class="col-form-label" id="">Observação</label>
						<input type="text" placeholder="Observação" id="obs_suprimento" name="obs" class="form-control" value="">
					</div>
				</div>

			</div>
			<div class="modal-footer">
				<button style="width: 100%" type="button" onclick="suprimentoCaixa()" class="btn btn-success font-weight-bold">OK</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-sangria" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog modal-md" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">SANGRIA DE CAIXA</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="form-group validated col-sm-6 col-lg-6 col-12">
						<label class="col-form-label" id="">Valor</label>
						<input type="text" placeholder="Valor" id="valor_sangria" name="valor_sangria" class="form-control" value="">
					</div>
				</div>

				<div class="row">
					<div class="form-group validated col-sm-12 col-lg-12 col-12">
						<label class="col-form-label" id="">Observação</label>
						<input type="text" placeholder="Observação" id="obs_sangria" name="obs" class="form-control" value="">
					</div>
				</div>

			</div>
			<div class="modal-footer">
				<button style="width: 100%" type="button" onclick="sangriaCaixa()" class="btn btn-success font-weight-bold">OK</button>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>	

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/caixa/index.blade.php ENDPATH**/ ?>