<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">


	<div class="card-body">
		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
			<div class="col-sm-12 col-lg-4 col-md-6 col-xl-4">

				<a href="/funcionarios/new" class="btn btn-lg btn-success">
					<i class="fa fa-plus"></i>Novo Funcionario
				</a>

				<a href="/funcionarios/comissao" class="btn btn-lg btn-info">
					<i class="fa fa-list"></i>Comissão
				</a>
			</div>
		</div>
		<br>


		<div class="<?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			
			<br>
			<h4>Lista de Funcionários</h4>
			<label>Total de registros: <?php echo e(count($funcionarios)); ?></label>
			<div class="row">


				<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">

					<div class="wizard wizard-3" id="kt_wizard_v3" data-wizard-state="between" data-wizard-clickable="true">
						<div class="wizard-nav">

							<div class="wizard-steps px-8 py-8 px-lg-15 py-lg-3">
								<!--begin::Wizard Step 1 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="done">
									<div class="wizard-label">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-table"></i>
												Tabela
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>
								<!--end::Wizard Step 1 Nav-->
								<!--begin::Wizard Step 2 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="current">
									<div class="wizard-label" id="grade">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-tablet"></i>
												Grade
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>

							</div>
						</div>

						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">
								<div class="col-xl-12">

									<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

										<table class="datatable-table" style="max-width: 100%; overflow: scroll">
											<thead class="datatable-head">
												<tr class="datatable-row" style="left: 0px;">
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 250px;">NOME</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 150px;">CPF</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">RG</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">RUA</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 120px;">Nº</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">BAIRRO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">DATA REGISTRO</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">AÇÕES</span></th>
												</tr>
											</thead>
											<tbody id="body" class="datatable-body">
												<?php $__currentLoopData = $funcionarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr class="datatable-row">
													<td class="datatable-cell"><span class="codigo" style="width: 250px;" id="id"><?php echo e($f->nome); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 150px;" id="id"><?php echo e($f->cpf); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e($f->rg); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 200px;" id="id"><?php echo e($f->rua); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 120px;" id="id"><?php echo e($f->numero); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e($f->bairro); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 100px;" id="id"><?php echo e(\Carbon\Carbon::parse($f->data_registro)->format('d/m/Y')); ?></span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 200px;" id="id">
															<a class="btn btn-warning" onclick='swal("Atenção!", "Deseja editar este registro?", "warning").then((sim) => {if(sim){ location.href="/funcionarios/edit/<?php echo e($f->id); ?>" }else{return false} })' href="#!">
																<i class="la la-edit"></i>	
															</a>
															<a class="btn btn-danger" onclick='swal("Atenção!", "Deseja remover este registro?", "warning").then((sim) => {if(sim){ location.href="/funcionarios/delete/<?php echo e($f->id); ?>" }else{return false} })' href="#!">
																<i class="la la-trash"></i>	
															</a>
															
														</span>
													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>

						</div>


						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">

								<?php $__currentLoopData = $funcionarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

								<div class="col-sm-12 col-lg-6 col-md-6 col-xl-4">
									<div class="card card-custom gutter-b example example-compact">
										<div class="card-header">
											<div class="card-title">
												<h3 style="width: 230px; font-size: 12px; height: 10px;" class="card-title"><?php echo e(substr($c->nome, 0, 30)); ?>

												</h3>
											</div>

											<div class="card-toolbar">
												<div class="dropdown dropdown-inline" data-toggle="tooltip" title="" data-placement="left" data-original-title="Ações">
													<a href="#" class="btn btn-hover-light-primary btn-sm btn-icon" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
														<i class="fa fa-ellipsis-h"></i>
													</a>
													<div class="dropdown-menu p-0 m-0 dropdown-menu-md dropdown-menu-right">
														<!--begin::Navigation-->
														<ul class="navi navi-hover">
															<li class="navi-header font-weight-bold py-4">
																<span class="font-size-lg">Ações:</span>
															</li>
															<li class="navi-separator mb-3 opacity-70"></li>
															<li class="navi-item">
																<a href="/funcionarios/edit/<?php echo e($c->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-primary">Editar</span>
																	</span>
																</a>
															</li>

															<li class="navi-item">
																<a onclick = "if (! confirm('Deseja excluir este registro?')) { return false; }" href="/funcionarios/delete/<?php echo e($c->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-danger">Excluir</span>
																	</span>
																</a>
															</li>

															<li class="navi-item">
																<a href="/funcionarios/contatos/<?php echo e($c->id); ?>" class="navi-link">
																	<span class="navi-text">
																		<span class="label label-xl label-inline label-light-primary">Contatos</span>
																	</span>
																</a>
															</li>


														</ul>
														<!--end::Navigation-->
													</div>
												</div>

											</div>

											<div class="card-body">

												<div class="kt-widget__info">
													<span class="kt-widget__label">CPF:</span>
													<a target="_blank" class="kt-widget__data text-success"><?php echo e($c->cpf); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">RG:</span>
													<a class="kt-widget__data text-success"><?php echo e($c->rg); ?></a>
												</div>

												<div class="kt-widget__info">
													<span class="kt-widget__label">Rua:</span>
													<a class="kt-widget__data text-success"><?php echo e($c->rua); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Número:</span>
													<a class="kt-widget__data text-success"><?php echo e($c->numero); ?></a>
												</div>
												<div class="kt-widget__info">
													<span class="kt-widget__label">Bairro:</span>
													<a class="kt-widget__data text-success"><?php echo e($c->bairro); ?></a>
												</div>

												<div class="kt-widget__info">
													<span class="kt-widget__label">Data de registro:</span>
													<a class="kt-widget__data text-success"><?php echo e(\Carbon\Carbon::parse($c->data_registro)->format('d/m/Y')); ?></a>
												</div>

											</div>

										</div>

									</div>

								</div>

								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</div>
						</div>
					</div>
				</div>

			</div>

			<div class="d-flex justify-content-between align-items-center flex-wrap">
				<div class="d-flex flex-wrap py-2 mr-3">
					<?php if(isset($links)): ?>
					<?php echo e($funcionarios->links()); ?>

					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcos/Documents/laravel/metronic_multi_8.4/resources/views/funcionarios/list.blade.php ENDPATH**/ ?>