<?php $__env->startSection('content'); ?>

<style type="text/css">
	.form-control{
		color: #000;
	}

	.end{
		margin-top: 10px;
	}
</style>

<div class="container">

	<div class="">
		<h4>Olá, <strong><?php echo e($cliente->nome); ?></strong> 
			<button style="color: #fff;" data-toggle="modal" data-target="#exampleModal" class="btn btn-warning">Alterar senha</button>
			<a href="<?php echo e($rota); ?>/logoff" class="btn btn-danger">Logoff</a>
		</h4>
		<hr>

		<div class="row">

			<form method="post" action="/ecommerceUpdateCliente">
				<?php echo csrf_field(); ?>
				<div class="col-12" style="margin-bottom: 10px;">
					<h4>Dados pessoais</h4>
					<br>
					<div class="row">
						<input type="hidden" value="<?php echo e($cliente->id); ?>" name="id">
						<div class="col-lg-3 col-6">
							<div class="checkout__input">
								<label>Nome</label>
								<input class="form-control" name="nome" value="<?php echo e($cliente->nome); ?>" type="text">
								<?php if($errors->has('nome')): ?>
								<label class="text-danger"><?php echo e($errors->first('nome')); ?></label>
								<?php endif; ?>
							</div>
						</div>
						<div class="col-lg-3 col-6">
							<div class="checkout__input">
								<label>Sobre nome</label>
								<input class="form-control" name="sobre_nome" value="<?php echo e($cliente->sobre_nome); ?>" type="text">
								<?php if($errors->has('sobre_nome')): ?>
								<label class="text-danger"><?php echo e($errors->first('sobre_nome')); ?></label>
								<?php endif; ?>
							</div>
						</div>

						<div class="col-lg-3 col-6">
							<div class="checkout__input">
								<label>Telefone</label>
								<input class="form-control" data-mask="(00) 00000-0000" name="telefone" value="<?php echo e($cliente->telefone); ?>" type="text">
								<?php if($errors->has('telefone')): ?>
								<label class="text-danger"><?php echo e($errors->first('telefone')); ?></label>
								<?php endif; ?>
							</div>
						</div>

						<div class="col-lg-3 col-6">
							<div class="checkout__input">
								<label>Email</label>
								<input class="form-control" name="email" value="<?php echo e($cliente->email); ?>" type="text">
								<?php if($errors->has('email')): ?>
								<label class="text-danger"><?php echo e($errors->first('email')); ?></label>
								<?php endif; ?>
							</div>
						</div>
					</div>
					<div class="row">
						<div class="col-12">
							<button type="submit" class="button contact_submit_button">Salvar</button>
						</div>
					</div>
				</div>


			</form>
		</div>
		<hr>

		<!-- pedidos -->
		<div class="row">
			<div class="col-12" style="margin-bottom: 10px;">
				<h4>Seus pedidos</h4>
			</div>

			<?php $__currentLoopData = $cliente->pedidos(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<div class="col-lg-4 col-md-6 char_col">
				<div class="char_item d-flex flex-row align-items-center justify-content-start" style="height: 150px;">
					
					<div class="char_content">
						<ul>

							<h4>Data: <strong><?php echo e(\Carbon\Carbon::parse($p->created_at)->format('d/m/Y H:i')); ?></strong></h4>
							<h4>Total: <strong>R$ <?php echo e(number_format($p->valor_total, 2, ',', '.')); ?></strong></h4>
						</ul>

						<?php if($p->status_preparacao == 0): ?>
						<span class="text-info">Novo</span>
						<?php elseif($p->status_preparacao == 1): ?>
						<span class="text-primary">Aprovado</span>
						<?php elseif($p->status_preparacao == 2): ?>
						<span class="text-danger">Cancelado</span>
						<?php elseif($p->status_preparacao == 3): ?>
						<span class="text-warning">Aguardando Envio</span>
						<?php elseif($p->status_preparacao == 4): ?>
						<span class="text-dark">Enviado</span>
						<?php else: ?>
						<span class="text-success">Entregue</span>
						<?php endif; ?>

						<a href="<?php echo e($rota); ?>/pedido_detalhe/<?php echo e($p->id); ?>" class="btn btn-success btn-block">Detalhes</a>
					</div>
				</div>
			</div>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

		</div>

		<hr>
		<!-- Endereços -->

		<div class="row">
			<div class="col-12" style="margin-bottom: 10px;">
				<h4>Seus endereços cadastrados</h4>
			</div>

			<div class="col-12" style="margin-bottom: 10px;">
				<button data-toggle="modal" data-target="#modal-endereco" class="btn btn-success">
					<i class="fa fa-plus"></i> Novo Endereço
				</button>
			</div>

			<?php $__currentLoopData = $cliente->enderecos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<div class="col-lg-4 col-md-6 end">
				<div class="char_item d-flex flex-row align-items-center justify-content-start" style="height: 180px;">
					
					<div class="char_content">

						<p><?php echo e($e->rua); ?>, <?php echo e($e->numero); ?> - <?php echo e($e->bairro); ?></p>
						<p><?php echo e($e->cidade); ?> - <?php echo e($e->uf); ?></p>
						<p><?php echo e($e->cep); ?></p>

						<button onclick="edit(<?php echo e($e); ?>)" class="btn btn-info btn-block">
							<i class="fa fa-edit"></i>
							Editar
						</button>
					</div>
				</div>
			</div>
			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</div>
	</div>
</div>

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<form method="post" action="/ecommerceUpdateSenha">
				<?php echo csrf_field(); ?>
				<div class="modal-header">
					<h5 class="modal-title" id="exampleModalLabel">Alterar Senha</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<input type="hidden" value="<?php echo e($cliente->id); ?>" name="id">
						<div class="col-lg-6 col-12">
							<div class="checkout__input">
								<label>Senha</label>
								<input class="form-control" name="senha" value="" type="password">
							</div>
						</div>

						<div class="col-lg-6 col-12">
							<div class="checkout__input">
								<label>Repita Senha</label>
								<input class="form-control" name="repita_senha" value="" type="password">
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Fechar</button>
					<button type="submit" class="btn btn-success">Salvar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-endereco" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<form method="post" action="/ecommerceSaveEndereco">
				<?php echo csrf_field(); ?>
				<div class="modal-header">
					<h5 class="modal-title" id="titulo">Cadastrar Endereço</h5>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<div class="row">
						<input type="hidden" value="<?php echo e($cliente->id); ?>" id="id" name="id">
						<input type="hidden" value="0" id="endereco_id" name="endereco_id">
						<div class="col-lg-8 col-12">
							<div class="checkout__input">
								<label>Rua</label>
								<input class="form-control" required id="rua" name="rua" value="" type="text">
							</div>
						</div>
						<div class="col-lg-4 col-12">
							<div class="checkout__input">
								<label>Nº</label>
								<input class="form-control" required id="numero" name="numero" value="" type="text">
							</div>
						</div>

						<div class="col-lg-6 col-12">
							<div class="checkout__input">
								<label>Bairro</label>
								<input class="form-control" required id="bairro" name="bairro" value="" type="text">
							</div>
						</div>
						<div class="col-lg-6 col-12">
							<div class="checkout__input">
								<label>CEP</label>
								<input class="form-control" id="cep" data-mask="00000-000" data-mask-reverse="true" required name="cep" value="" type="text">
							</div>
						</div>

						<div class="col-lg-8 col-12">
							<div class="checkout__input">
								<label>Cidade</label>
								<input class="form-control" id="cidade" required name="cidade" value="" type="text">
							</div>
						</div>
						<div class="col-lg-4 col-12">
							<div class="checkout__input">
								<label>UF</label>
								<br>
								<select id="uf" required class="custom-select" name="uf" style="margin-left: 0px;">
									<option></option>
									<?php $__currentLoopData = App\Models\EnderecoEcommerce::estados(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($u); ?>"><?php echo e($u); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>

						<div class="col-12">
							<div class="checkout__input">
								<label>Complemento</label>
								<input class="form-control" id="complemento" name="complemento" value="" type="text">
							</div>
						</div>


					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-danger" data-dismiss="modal">Fechar</button>
					<button type="submit" class="btn btn-success">Salvar</button>
				</div>
			</form>
		</div>
	</div>
</div>


<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
	function edit(endereco){
		$('#endereco_id').val(endereco.id)

		$('#modal-endereco').modal('show')
		$('#rua').val(endereco.rua)
		$('#numero').val(endereco.numero)
		$('#bairro').val(endereco.bairro)
		$('#cep').val(endereco.cep)
		$('#cidade').val(endereco.cidade)
		$('#cidade').val(endereco.cidade)
		$('#uf').val(endereco.uf).change()
		$('#complemento').val(endereco.complemento)
		$('#titulo').html('Editar Endereço')
	}
</script>
<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>	
<?php echo $__env->make('ecommerce_one_tech.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/ecommerce_one_tech/area_cliente.blade.php ENDPATH**/ ?>