<?php $__env->startSection('content'); ?>

<style type="text/css">
	.card-stretch:hover{
		cursor: pointer;
	}

	.input-group-append:hover{
		cursor: pointer;
	}
</style>
<div class="card card-custom gutter-b">

	<div class="card-body <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInRight">
		<div class="content d-flex flex-column flex-column-fluid" id="kt_content" >

			<div class="row">
				<div class="col-lg-6">

					<input type="hidden" value="<?php echo e($payment->transacao_id); ?>" id="transacao_id" name="">
					<input type="hidden" value="<?php echo e($payment->status); ?>" id="status" name="">
					<h3>Plano: <strong class="text-info"><?php echo e($payment->plano->plano->nome); ?></strong></h3>
					<h3>Transação ID: <strong class="text-info"><?php echo e($payment->transacao_id); ?></strong></h3>

					<h3>Status: 
						<?php if($payment->status == 'approved'): ?>
						<span class="label label-xl label-inline label-light-success">Aprovado</span>
						<?php elseif($payment->status == 'pending'): ?>
						<span class="label label-xl label-inline label-light-warning">Pendente</span>
						<?php elseif($payment->status == 'rejected'): ?>
						<span class="label label-xl label-inline label-light-danger">Rejeitado</span>
						<?php else: ?>
						<span class="label label-xl label-inline label-light-dark">Não identificado</span>
						<?php endif; ?>
					</h3>

					<?php if($payment->forma_pagamento == 'Boleto'): ?>
					<a target="_blank" href="<?php echo e($payment->link_boleto); ?>" class="btn btn-info">
						<i class="la la-print"></i>
						Imprimir Boleto
					</a>
					<?php endif; ?>

				</div>
				<div class="col-lg-6">

					<h3>Valor: <strong class="text-info"><?php echo e(number_format($payment->valor, 2, ',', '.')); ?></strong></h3>
					<h3>Forma de pagamento: <strong class="text-info"><?php echo e($payment->forma_pagamento); ?></strong></h3>
					<h3>Data de criação: <strong class="text-info"><?php echo e(\Carbon\Carbon::parse($payment->created_at)->format('d/m/Y H:i:s')); ?></strong></h3>
					<h3>Ultima atualização: <strong class="text-info"><?php echo e(\Carbon\Carbon::parse($payment->updated_at)->format('d/m/Y H:i:s')); ?></strong></h3>
				</div>

				<?php if($payment->forma_pagamento == 'Pix'): ?>
				<div class="row">
					<div class="col-lg-12">

						<div class="col-lg-4 offset-lg-4">
							<img style="width: 400px; height: 400px;" src="data:image/jpeg;base64,<?php echo e($payment->qr_code_base64); ?>"/>
						</div>					
					</div>	
					<div class="col-lg-12">

						<div class="col-lg-11 offset-lg-1">

							<div class="input-group">
								<input type="text" class="form-control" value="<?php echo e($payment->qr_code); ?>" id="qrcode_input" />

								<div class="input-group-append">
									<span class="input-group-text">

										<i onclick="copy()" class="la la-copy">
										</i>

									</span>
								</div>
							</div>

						</div>				
					</div>				
				</div>

				<div class="row">
					

				</div>
				<?php endif; ?>

			</div>
		</div>
	</div>
</div>

<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
	<?php if($payment->link_boleto != ""): ?>
    // window.open('<?php echo e($payment->link_boleto); ?>')
    <?php endif; ?>
	function copy(){
		const inputTest = document.querySelector("#qrcode_input");

		inputTest.select();
		document.execCommand('copy');

		swal("", "Código pix copado!!", "success")
	}
	if($('#status').val() != "approved"){
		setInterval(() => {
			let transacao_id = $('#transacao_id').val();
			$.get(path+'payment/consulta/'+transacao_id)
			.done((success) => {
				// console.log(success)
				if(success == "approved"){
					location.reload()
				}
			})
			.fail((err) => {
				console.log(err)
			})
		}, 1000)
	}
</script>

<?php $__env->stopSection(); ?>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/payment/detalhes_pagamento.blade.php ENDPATH**/ ?>