<!DOCTYPE html>
<html>
<head>
	<title></title>
	<!--  -->

	<style type="text/css">

		.content{
			margin-top: -30px;
		}
		.titulo{
			font-size: 20px;
			margin-bottom: 0px;
			font-weight: bold;
		}

		.b-top{
			border-top: 1px solid #000; 
		}
		.b-bottom{
			border-bottom: 1px solid #000; 
		}
		.page_break { page-break-before: always; }

	</style>

</head>
<body>
	<div class="content">
		<?php if($config->logo != ""): ?>
		<table>
			<tr>
				<td class="" style="width: 150px;">
					<img src="<?php echo e('data:image/png;base64,' . base64_encode(file_get_contents(@public_path('logos/').$config->logo))); ?>" width="100px;">
				</td>

				<td class="" style="width: 550px;">
					<center><label class="titulo">DOCUMENTO AUXILIAR DE VENDA</label></center>
					<center><label class="titulo">NÃO É DOCUMENTO FISCAL</label></center>
					<center><label class="titulo">NÃO COMPROVA PAGAMENTO</label></center>
				</td>
			</tr>
		</table>
		<?php else: ?>
		<center><label class="titulo">DOCUMENTO AUXILIAR DE VENDA</label></center>
		<center><label class="titulo">NÃO É DOCUMENTO FISCAL</label></center>
		<center><label class="titulo">NÃO COMPROVA PAGAMENTO</label></center>
		<?php endif; ?>
	</div>
	<br>
	<table>
		<tr>
			<td class="" style="width: 700px;">
				<strong>Identificação do Estabelecimento Emitente</strong>
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="b-top" style="width: 500px;">
				Razão social: <strong><?php echo e($config->razao_social); ?></strong>
			</td>
			<td class="b-top" style="width: 197px;">
				CNPJ: <strong><?php echo e($config->cnpj); ?></strong>
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="b-top" style="width: 700px;">
				Endereço: <strong><?php echo e($config->logradouro); ?>, <?php echo e($config->numero); ?> - <?php echo e($config->bairro); ?> - <?php echo e($config->municipio); ?> (<?php echo e($config->UF); ?>)</strong>
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="b-top b-bottom" style="width: 700px;">
				Telefone: <strong><?php echo e($config->fone); ?></strong>
			</td>
		</tr>
	</table>
	<br>
	<table>
		<tr>
			<td class="" style="width: 700px;">
				<strong>Identificação do Destinatário</strong>
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="b-top" style="width: 450px;">
				Nome: <strong><?php echo e($venda->cliente->razao_social); ?></strong>
			</td>
			<td class="b-top" style="width: 247px;">
				CPF/CNPJ: <strong><?php echo e($venda->cliente->cpf_cnpj); ?></strong>
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="b-top" style="width: 500px;">
				Endereço: <strong><?php echo e($venda->cliente->rua); ?>, <?php echo e($venda->cliente->numero); ?> - <?php echo e($venda->cliente->bairro); ?> - <?php echo e($venda->cliente->cidade->nome); ?> (<?php echo e($venda->cliente->cidade->uf); ?>)</strong>
			</td>

			<td class="b-top" style="width: 200px;">
				Telefone: <strong><?php echo e($venda->cliente->telefone); ?></strong>
			</td>
		</tr>
	</table>

	<table>
		<tr>
			<td class="b-top" style="width: 350px;">
				Nº Doc: <strong><?php echo e($venda->id); ?></strong>
			</td>
			<td class="b-top" style="width: 347px;">

			</td>
		</tr>
	</table>

	<table>
		<tr>
			<td class="b-top b-bottom" style="width: 700px; height: 50px;">
				<strong>MERCADORIAS:</strong>
			</td>
		</tr>
	</table>	

	<table>
		<thead>
			<tr>
				<td class="" style="width: 95px;">
					Cod
				</td>
				<td class="" style="width: 350px;">
					Descrição
				</td>
				<td class="" style="width: 80px;">
					Quant.
				</td>
				<td class="" style="width: 80px;">
					Vl Uni
				</td>
				<td class="" style="width: 80px;">
					Vl Liq.
				</td>
			</tr>
		</thead>

		<?php
		$somaItens = 0;
		$somaTotalItens = 0;
		$tipoDimensao = false;
		?>
		<tbody>
			<?php $__currentLoopData = $venda->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr>
				<th class="b-top"><?php echo e($i->produto->id); ?></th>
				<th class="b-top">
					<?php echo e($i->produto->nome); ?>

					<?php echo e($i->produto->grade ? " (" . $i->produto->str_grade . ")" : ""); ?>

					<?php if($i->produto->lote != ""): ?>
					| Lote: <?php echo e($i->produto->lote); ?>, 
					Vencimento: <?php echo e($i->produto->vencimento); ?>

					<?php endif; ?>
				</th class="b-top">
				<th class="b-top"><?php echo e(number_format($i->quantidade, 2, ',', '.')); ?></th>
				<th class="b-top"><?php echo e(number_format($i->valor, $casasDecimais, ',', '.')); ?></th>
				<th class="b-top"><?php echo e(number_format($i->quantidade * $i->valor, $casasDecimais, ',', '.')); ?></th>

			</tr>
			<?php
			$somaItens += $i->quantidade;
			$somaTotalItens += $i->quantidade * $i->valor;
			if($i->altura > 0 || $i->esquerda > 0){
				$tipoDimensao = true;
			}
			?>

			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>
	<br>

	<table>
		<tr>
			<td class="b-top b-bottom" style="width: 350px;">
				<center><strong>Quantidade Total: <?php echo e($somaItens); ?></strong></center>
			</td>

			<td class="b-top b-bottom" style="width: 350px;">
				<center><strong>Valor Total dos Itens: 
					<?php echo e(number_format($somaTotalItens, $casasDecimais, ',', '.')); ?>

				</strong></center>
			</td>
		</tr>
	</table>

	<?php if($venda->duplicatas()->exists()): ?>
	<table>
		<tr>
			<td class="b-bottom" style="width: 700px; height: 50px;">
				<strong>FATURA:</strong>
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="b-bottom" style="width: 150px;">
				Vencimento
			</td>
			<td class="b-bottom" style="width: 150px;">
				Valor
			</td>
		</tr>
		<?php $__currentLoopData = $venda->duplicatas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<tr>

			<td class="b-bottom">
				<strong><?php echo e(\Carbon\Carbon::parse($d->data_vencimento)->format('d/m/Y')); ?></strong>
			</td>
			<td class="b-bottom">
				<strong><?php echo e(number_format($d->valor_integral, $casasDecimais, ',', '.')); ?></strong>
			</td>


		</tr>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</table>
	<?php endif; ?>


	<br>
	<table>
		<tr>
			<td class="" style="width: 350px;">
				<strong>Forma de pagamento: 
					<?php echo e($venda->forma_pagamento == 'a_vista' ? 'À vista' : $venda->forma_pagamento); ?>

				</strong>
			</td>
			<td class="" style="width: 350px;">
				<strong>Vendedor: 
					<?php echo e($venda->usuario->nome); ?>

				</strong>
			</td>
			
		</tr>
	</table>
	<table>
		<tr>
			<td class="" style="width: 350px;">
				Data da venda: <strong><?php echo e(\Carbon\Carbon::parse($venda->created_at)->format('d/m/Y H:i')); ?></strong>
			</td>
			<td class="" style="width: 347px;">

			</td>
		</tr>
	</table>

	<?php if($venda->observacao != ""): ?>
	<table>
		<tr>
			<td class="" style="width: 700px;">
				<strong>Observação: 
					<?php echo e($venda->observacao); ?>

				</strong>
			</td>
		</tr>
	</table>
	<?php endif; ?>

	<table>
		<tr>
			<td class="" style="width: 170px;">
				Desconto (-):
				<strong> 
					<?php echo e(number_format($venda->desconto, 2, ',', '.')); ?>

				</strong>
			</td>

			<td class="" style="width: 170px;">
				Acrescimo (+):
				<strong> 
					<?php echo e(number_format($venda->acrescimo, 2, ',', '.')); ?>

				</strong>
			</td>

			<td class="" style="width: 170px;">
				Frete (+):
				<strong> 
					<?php if($venda->frete): ?>
					<?php echo e(number_format($venda->frete->valor, 2, ',', '.')); ?>

					<?php else: ?>
					0,00
					<?php endif; ?>
				</strong>
			</td>

			<td class="" style="width: 200px;">
				Valor Líquido:
				<strong> 
					<?php echo e(number_format($venda->valor_total - $venda->desconto + $venda->acrescimo, $casasDecimais, ',', '.')); ?>

				</strong>
			</td>
			
		</tr>
	</table>

	<br><br><br>
	<table>
		<tr>
			<td class="" style="width: 350px;">
				<strong>
					________________________________________
				</strong><br>
				<span style="font-size: 11px;"><?php echo e($config->razao_social); ?></span>

			</td>

			<td class="" style="width: 350px;">
				<strong>
					________________________________________
				</strong><br>
				<span style="font-size: 11px;"><?php echo e($venda->cliente->razao_social); ?></span>
			</td>
		</tr>
	</table>

	<?php if($tipoDimensao): ?>
	<div class="page_break"></div>
	<table>
		<tr>
			<td class="" style="width: 700px;">
				<strong>Identificação do Destinatário</strong>
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="b-top" style="width: 450px;">
				Nome: <strong><?php echo e($venda->cliente->razao_social); ?></strong>
			</td>
			<td class="b-top" style="width: 247px;">
				CPF/CNPJ: <strong><?php echo e($venda->cliente->cpf_cnpj); ?></strong>
			</td>
		</tr>
	</table>
	<table>
		<tr>
			<td class="b-top" style="width: 500px;">
				Endereço: <strong><?php echo e($venda->cliente->rua); ?>, <?php echo e($venda->cliente->numero); ?> - <?php echo e($venda->cliente->bairro); ?> - <?php echo e($venda->cliente->cidade->nome); ?> (<?php echo e($venda->cliente->cidade->uf); ?>)</strong>
			</td>

			<td class="b-top" style="width: 200px;">
				Telefone: <strong><?php echo e($venda->cliente->telefone); ?></strong>
			</td>
		</tr>
	</table>

	<table>
		<tr>
			<td class="b-top" style="width: 350px;">
				Nº Doc: <strong><?php echo e($venda->id); ?></strong>
			</td>
			<td class="b-top" style="width: 347px;">

			</td>
		</tr>
	</table>

	<table>
		<tr>
			<td class="b-top b-bottom" style="width: 700px; height: 50px;">
				<strong>MERCADORIAS:</strong>
			</td>
		</tr>
	</table>	

	<table>
		<thead>
			<tr>
				<td class="" style="width: 95px;">
					Cod
				</td>
				<td class="" style="width: 520px;">
					Descrição
				</td>
				<td class="" style="width: 80px;">
					Quant.
				</td>
				
			</tr>
		</thead>

		<?php
		$somaItens = 0;
		$somaTotalItens = 0;
		$tipoDimensao = false;
		?>
		<tbody>
			<?php $__currentLoopData = $venda->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
			<tr>
				<th class="b-top"><?php echo e($i->produto->id); ?></th>
				<th class="b-top">
					<?php echo e($i->produto->nome); ?>

					<?php echo e($i->produto->grade ? " (" . $i->produto->str_grade . ")" : ""); ?>

					<?php if($i->produto->lote != ""): ?>
					| Lote: <?php echo e($i->produto->lote); ?>, 
					Vencimento: <?php echo e($i->produto->vencimento); ?>

					<?php endif; ?>
					<?php if($i->produto->tipo_dimensao != ''): ?>
					<?php if($i->produto->tipo_dimensao == 'area'): ?>
					[Altura: <?php echo e($i->altura); ?>, Largura: <?php echo e($i->largura); ?>, Profundidade: <?php echo e($i->profundidade); ?>]
					<?php else: ?>
					[Superior: <?php echo e($i->superior); ?>, Infeior: <?php echo e($i->inferior); ?>, Esquerda: <?php echo e($i->esquerda); ?>, Direita: <?php echo e($i->direita); ?>]

					<?php endif; ?>
					<?php endif; ?>
				</th class="b-top">
				<th class="b-top"><?php echo e(number_format($i->quantidade, 2, ',', '.')); ?></th>

			</tr>
			<?php
			$somaItens += $i->quantidade;
			$somaTotalItens += $i->quantidade * $i->valor;
			if($i->altura > 0 || $i->esquerda > 0){
				$tipoDimensao = true;
			}
			?>

			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
		</tbody>
	</table>
	<br>

	
	<br>
	<table>
		<tr>

			<td class="" style="width: 350px;">
				<strong>Vendedor: 
					<?php echo e($venda->usuario->nome); ?>

				</strong>
			</td>
			
		
			<td class="" style="width: 350px;">
				Data da venda: <strong><?php echo e(\Carbon\Carbon::parse($venda->created_at)->format('d/m/Y H:i')); ?></strong>
			</td>
			<td class="" style="width: 347px;">

			</td>
		</tr>
	</table>

	<?php if($venda->observacao != ""): ?>
	<table>
		<tr>
			<td class="" style="width: 700px;">
				<strong>Observação: 
					<?php echo e($venda->observacao); ?>

				</strong>
			</td>
		</tr>
	</table>
	<?php endif; ?>
	<?php endif; ?>


</body>
</html><?php /**PATH /Users/marcos/Documents/laravel/metronic_multi_8.4/resources/views/vendas/print.blade.php ENDPATH**/ ?>