<?php $__env->startSection('content'); ?>
<style type="text/css">
	.modal-body-grade{
		height: 70vh;
		overflow-y: auto;
	}
</style>
<div class=" d-flex flex-column flex-column-fluid" id="kt_content">
	<div class="card card-custom gutter-b example example-compact">
		<div class="container <?php if(getenv('ANIMACAO')): ?> animate__animated <?php endif; ?> animate__backInLeft">
			<div class="col-lg-12">
				<br>
				<form method="post" action="<?php echo e(isset($produto) ? '/produtos/update': '/produtos/save'); ?>" enctype="multipart/form-data">


					<input type="hidden" name="id" value="<?php echo e(isset($produto) ? $produto->id : 0); ?>">
					<div class="card card-custom gutter-b example example-compact">
						<div class="card-header">

							<h3 class="card-title"><?php echo e(isset($produto) ? 'Editar' : 'Novo'); ?> Produto</h3>
						</div>

					</div>
					<input type="hidden" value="<?php echo e(csrf_token()); ?>" id="_token" name="_token">

					<div class="wizard wizard-3" id="kt_wizard_v3" data-wizard-state="between" data-wizard-clickable="true">
						<!--begin: Wizard Nav-->

						<div class="wizard-nav">

							<div class="wizard-steps px-8 py-8 px-lg-15 py-lg-3">
								<!--begin::Wizard Step 1 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="done">
									<div class="wizard-label">
										<h3 class="wizard-title">
											<span>
												IDENTIFICAÇÃO
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>
								<!--end::Wizard Step 1 Nav-->
								<!--begin::Wizard Step 2 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="current">
									<div class="wizard-label">
										<h3 class="wizard-title">
											<span>
												ALÍQUOTAS
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>
							</div>
						</div>

						<div class="card-body">
							<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">

								<!--begin: Wizard Form-->
								<form class="form fv-plugins-bootstrap fv-plugins-framework" id="kt_form">
									<!--begin: Wizard Step 1-->
									<p class="kt-widget__data text-danger">Campos com (*) obrigatório</p>

									<div class="pb-5" data-wizard-type="step-content">
										<div class="row">

											<div class="col-xl-12">
												<div class="row">

													<div class="form-group validated col-sm-9 col-lg-9">
														<label class="col-form-label">Nome*</label>
														<div class="">
															<input autofocus type="text" class="form-control <?php if($errors->has('nome')): ?> is-invalid <?php endif; ?>" name="nome" value="<?php echo e(isset($produto) ? $produto->nome : old('nome')); ?>">
															<?php if($errors->has('nome')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('nome')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">Referência</label>
														<div class="">
															<input type="text" class="form-control <?php if($errors->has('referencia')): ?> is-invalid <?php endif; ?>" name="referencia" value="<?php echo e(isset($produto) ? $produto->referencia : old('referencia')); ?>">
															<?php if($errors->has('referencia')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('referencia')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">Valor de Compra*</label>
														<div class="">
															<input type="text" id="valor_compra" class="form-control <?php if($errors->has('valor_compra')): ?> is-invalid <?php endif; ?> money" name="valor_compra" value="<?php echo e(isset($produto) ? number_format($produto->valor_compra, $casasDecimais) : old('valor_compra')); ?>">
															<?php if($errors->has('valor_compra')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('valor_compra')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">% lucro*</label>
														<div class="">
															<input type="text" id="percentual_lucro" class="form-control <?php if($errors->has('percentual_lucro')): ?> is-invalid <?php endif; ?> money" name="percentual_lucro" value="<?php echo e(isset($produto) ? $produto->percentual_lucro : $config->percentual_lucro_padrao); ?>">
															<?php if($errors->has('percentual_lucro')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('percentual_lucro')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">Valor de Venda*</label>
														<div class="">
															<input type="text" id="valor_venda" class="form-control <?php if($errors->has('valor_venda')): ?> is-invalid <?php endif; ?> money" name="valor_venda" value="<?php echo e(isset($produto) ? number_format($produto->valor_venda, $casasDecimais) : old('valor_venda')); ?>">
															<?php if($errors->has('valor_venda')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('valor_venda')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<?php if(isset($produto)): ?>
													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">Estoque Atual</label>
														<div class="">
															<input type="text" id="estoque" class="form-control <?php if($errors->has('estoque')): ?> is-invalid <?php endif; ?>" name="estoque" 
															value="<?php if($produto->estoque): ?> <?php echo e($produto->estoque->quantidade); ?> <?php else: ?> 0 <?php endif; ?>">
															<?php if($errors->has('estoque')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('estoque')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
													<?php else: ?>
													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">Iniciar com Estoque</label>
														<div class="">
															<input type="text" id="estoque" class="form-control <?php if($errors->has('estoque')): ?> is-invalid <?php endif; ?>" name="estoque" 
															value="">
															<?php if($errors->has('estoque')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('estoque')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
													<?php endif; ?>

													<div class="form-group validated col-sm-4 col-lg-4">
														<label class="col-form-label">Código de Barras EAN13</label>
														<div class="input-group">
															<input id="codBarras" type="text" class="form-control <?php if($errors->has('codBarras')): ?> is-invalid <?php endif; ?>" name="codBarras" value="<?php echo e(isset($produto->codBarras) ? $produto->codBarras : old('codBarras')); ?>">
															<div class="input-group-prepend">
																<span class="input-group-text btn-info btn" onclick="gerarCode()">
																	<i class="la la-barcode"></i>
																</span>
															</div>
															<?php if($errors->has('codBarras')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('codBarras')); ?>

															</div>
															<?php endif; ?>

														</div>
													</div>

													<div class="form-group validated col-sm-6 col-lg-4">
														<label class="col-form-label text-left col-lg-12 col-sm-12">Reajuste valor automatico</label>
														<div class="col-6">
															<span class="switch switch-outline switch-danger">
																<label>
																	<input value="true" <?php if(isset($produto) && $produto->reajuste_automatico): ?> checked <?php endif; ?> type="checkbox" name="reajuste_automatico" id="reajuste_automatico">
																	<span></span>
																</label>
															</span>
														</div>
													</div>

													<div class="form-group validated col-sm-6 col-lg-3">
														<label class="col-form-label text-left col-lg-12 col-sm-12">Gerenciar estoque</label>
														<div class="col-6">
															<span class="switch switch-outline switch-primary">
																<label>
																	<input value="true" <?php if(isset($produto) && $produto->gerenciar_estoque): ?> checked <?php elseif(getenv("PRODUTO_GERENCIAR_ESTOQUE") == 1 && !isset($produto)): ?> checked <?php endif; ?> type="checkbox" name="gerenciar_estoque" id="gerenciar_estoque">
																	<span></span>
																</label>
															</span>
														</div>
													</div>

													<div class="form-group validated col-sm-6 col-lg-2">
														<label class="col-form-label text-left col-lg-12 col-sm-12">Inativo</label>
														<div class="col-6">
															<span class="switch switch-outline switch-danger">
																<label>
																	<input value="true" <?php if(isset($produto) && $produto->inativo): ?> checked <?php endif; ?> type="checkbox" name="inativo" id="inativo">
																	<span></span>
																</label>
															</span>
														</div>
													</div>

													<div class="form-group validated col-sm-6 col-lg-3">
														<label class="col-form-label text-left col-lg-12 col-sm-12">Tipo grade</label>
														<div class="col-6">
															<span class="switch switch-outline switch-info">
																<label>
																	<input <?php if(old('grade')): ?> checked <?php endif; ?> class="grade" type="checkbox" name="grade">
																	<span></span>
																</label>
															</span>
														</div>
													</div>

													<div class="form-group validated col-lg-4 col-md-6 col-sm-10">
														<label class="col-form-label">Categoria*</label>
														<div class="input-group">

															<select id="categoria" class="form-control custom-select <?php if($errors->has('categoria_id')): ?> is-invalid <?php endif; ?>" name="categoria_id">
																<option value="">--</option>
																<?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<option value="<?php echo e($cat->id); ?>" <?php if(isset($produto)): ?> <?php if($cat->id == $produto->categoria_id): ?>
																	selected=""
																	<?php endif; ?>
																	<?php else: ?>
																	<?php if($cat->id == old('categoria_id')): ?>
																	selected
																	<?php endif; ?>
																	<?php endif; ?> ><?php echo e($cat->nome); ?>

																</option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
															<div class="input-group-prepend">
																<span class="input-group-text btn-info btn" onclick="novaCategoria()">
																	<i class="la la-plus"></i>
																</span>
															</div>
															<?php if($errors->has('categoria_id')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('categoria_id')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-lg-3 col-md-6 col-sm-10">
														<label class="col-form-label">Sub Categoria</label>
														<div class="input-group">

															<select id="sub_categoria_id" class="form-control custom-select" name="sub_categoria_id">
																<option value="">--</option>
															</select>

															<div class="input-group-prepend">
																<span class="input-group-text btn-warning btn" onclick="novaSubCategoria()">
																	<i class="la la-plus"></i>
																</span>
															</div>
															
															<?php if($errors->has('sub_categoria_id')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('sub_categoria_id')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-lg-4 col-md-6 col-sm-10">
														<label class="col-form-label">Marca</label>
														<div class="input-group">

															<select id="marca" class="form-control custom-select" name="marca_id">
																<option value="">--</option>
																<?php $__currentLoopData = $marcas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																<option value="<?php echo e($cat->id); ?>" <?php if(isset($produto)): ?> <?php if($cat->id == $produto->marca_id): ?>
																	selected=""
																	<?php endif; ?>
																	<?php endif; ?> ><?php echo e($cat->nome); ?>

																</option>
																<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
															</select>
															<div class="input-group-prepend">
																<span class="input-group-text btn-danger btn" onclick="novaMarca()">
																	<i class="la la-plus"></i>
																</span>
															</div>
															<?php if($errors->has('marca_id')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('marca_id')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">Estoque minimo</label>
														<div class="">
															<input type="text" id="estoque_minimo" class="form-control <?php if($errors->has('estoque_minimo')): ?> is-invalid <?php endif; ?>" name="estoque_minimo" value="<?php echo e(isset($produto) ? $produto->estoque_minimo : old('estoque_minimo')); ?>">
															<?php if($errors->has('estoque_minimo')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('estoque_minimo')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-4 col-lg-4">
														<label class="col-form-label">Limite maximo desconto %</label>
														<div class="">
															<input type="text" id="limite_maximo_desconto" class="form-control <?php if($errors->has('limite_maximo_desconto')): ?> is-invalid <?php endif; ?>" name="limite_maximo_desconto" value="<?php echo e(isset($produto) ? $produto->limite_maximo_desconto : old('limite_maximo_desconto')); ?>">
															<?php if($errors->has('limite_maximo_desconto')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('limite_maximo_desconto')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>



													<div class="form-group validated col-sm-3 col-lg-4">
														<label class="col-form-label">Alerta de Venc. (Dias)</label>
														<div class="">
															<input type="text" id="alerta_vencimento" class="form-control <?php if($errors->has('alerta_vencimento')): ?> is-invalid <?php endif; ?>" name="alerta_vencimento" value="<?php echo e(isset($produto) ? $produto->alerta_vencimento : old('alerta_vencimento')); ?>">
															<?php if($errors->has('alerta_vencimento')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('alerta_vencimento')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>


													<div class="form-group validated col-lg-4 col-md-6 col-sm-10">
														<label class="col-form-label">Unidade de compra *</label>

														<select class="custom-select form-control" id="unidade_compra" name="unidade_compra">
															<?php $__currentLoopData = $unidadesDeMedida; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option <?php if(isset($produto)): ?> <?php if($u==$produto->unidade_compra): ?>
																selected
																<?php endif; ?>
																<?php else: ?>
																<?php if($u == 'UN'): ?>
																selected
																<?php endif; ?>
																<?php endif; ?> value="<?php echo e($u); ?>"><?php echo e($u); ?>

															</option>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</select>
													</div>


													<div class="form-group validated col-sm-3 col-lg-3" id="conversao" style="display: none">
														<label class="col-form-label">Conversão Unitária</label>
														<div class="">
															<input type="text" id="alerta_vencimento" class="form-control <?php if($errors->has('conversao_unitaria')): ?> is-invalid <?php endif; ?>" name="conversao_unitaria" value="<?php echo e(isset($produto->conversao_unitaria) ? $produto->conversao_unitaria : old('conversao_unitaria')); ?>">
															<?php if($errors->has('conversao_unitaria')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('conversao_unitaria')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
													<div class="form-group validated col-lg-4 col-md-6 col-sm-10">
														<label class="col-form-label">Unidade de venda *</label>

														<select class="custom-select form-control" id="unidade_venda" name="unidade_venda">
															<?php $__currentLoopData = $unidadesDeMedida; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option <?php if(isset($produto)): ?> <?php if($u==$produto->unidade_venda): ?>
																selected
																<?php endif; ?>
																<?php else: ?>
																<?php if($u == 'UN'): ?>
																selected
																<?php endif; ?>
																<?php endif; ?> value="<?php echo e($u); ?>"><?php echo e($u); ?>

															</option>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</select>

													</div>

													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">NCM *</label>
														<div class="">
															<input type="text" id="ncm" class="form-control <?php if($errors->has('NCM')): ?> is-invalid <?php endif; ?>" name="NCM" value="<?php echo e(isset($produto->NCM) ? $produto->NCM : $tributacao->ncm_padrao); ?>">
															<?php if($errors->has('NCM')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('NCM')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">CEST</label>
														<div class="">
															<input type="text" id="cest" class="form-control <?php if($errors->has('CEST')): ?> is-invalid <?php endif; ?>" name="CEST" value="<?php echo e(isset($produto->CEST) ? $produto->CEST : old('CEST')); ?>">
															<?php if($errors->has('CEST')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('CEST')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">Ref. balança</label>
														<div class="">
															<input type="text" id="referencia_balanca" class="form-control <?php if($errors->has('referencia_balanca')): ?> is-invalid <?php endif; ?>" name="referencia_balanca" value="<?php echo e(isset($produto->referencia_balanca) ? $produto->referencia_balanca : old('referencia_balanca')); ?>">
															<?php if($errors->has('referencia_balanca')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('referencia_balanca')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-3 col-lg-2">
														<label class="col-form-label">% Comissão</label>
														<div class="">
															<input type="text" id="perc_comissao" class="form-control <?php if($errors->has('perc_comissao')): ?> is-invalid <?php endif; ?>" name="perc_comissao" value="<?php echo e(isset($produto->perc_comissao) ? $produto->perc_comissao : old('perc_comissao')); ?>">
															<?php if($errors->has('perc_comissao')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('perc_comissao')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="form-group validated col-sm-3 col-lg-3">
														<label class="col-form-label">Tipo dimensão</label>
														<button type="button" class="btn btn-light-info btn-sm btn-icon col-lg-6 col-sm-6" data-toggle="popover" data-trigger="click" data-content="Para setar dimensão do produto na venda pedido"><i class="la la-info"></i></button>
														<div class="">
															<select class="form-control custom-select" name="tipo_dimensao">
																<option value="">--</option>
																<option <?php if(isset($produto)): ?> <?php if($produto->tipo_dimensao == 'area'): ?> selected <?php endif; ?> <?php endif; ?> value="area">Area</option>
																<option <?php if(isset($produto)): ?> <?php if($produto->tipo_dimensao == 'dimensao'): ?> selected <?php endif; ?> <?php endif; ?> value="dimensao">Dimensão</option>
															</select>
														</div>
													</div>

													<div class="form-group validated col-lg-12 col-md-12 col-sm-12">
														<label class="col-xl-12 col-lg-12 col-form-label text-left">Imagem</label>
														<div class="col-lg-12 col-xl-12">

															<div class="image-input image-input-outline" id="kt_image_1">
																<div class="image-input-wrapper"
																<?php if(!isset($produto) || $produto->imagem == ''): ?> style="background-image: url(/imgs/no_image.png)" <?php else: ?>
																	style="background-image: url(/imgs_produtos/<?php echo e($produto->imagem); ?>)"
																	<?php endif; ?>>

																</div>
																<label class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="change" data-toggle="tooltip" title="" data-original-title="Change avatar">
																	<i class="fa fa-pencil icon-sm text-muted"></i>
																	<input type="file" name="file" accept=".png, .jpg, .jpeg">
																	<input type="hidden" name="profile_avatar_remove">
																</label>
																<span class="btn btn-xs btn-icon btn-circle btn-white btn-hover-text-primary btn-shadow" data-action="cancel" data-toggle="tooltip" title="" data-original-title="Cancel avatar">
																	<i class="fa fa-close icon-xs text-muted"></i>
																</span>
															</div>

															<span class="form-text text-muted">.png, .jpg, .jpeg</span>
															<?php if($errors->has('file')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('file')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>

													<div class="row">
														<div class="form-group validated col-lg-12 col-md-12 col-sm-12">
															<label class="col-xl-12 col-lg-12 col-form-label text-left">Composto</label>
															<div class="col-lg-12 col-xl-12">
																<span class="switch switch-outline switch-success">
																	<label>
																		<input <?php if(isset($produto->composto) && $produto->composto): ?> checked <?php endif; ?> value="true" name="composto" class="red-text" type="checkbox">
																		<span></span>
																	</label>
																</span>

																<p class="text-danger">*Produzido no estabelecimento composto de outros produtos já cadastrados, deverá ser criado uma receita para redução de estoque. </p>

															</div>
														</div>
													</div>


													<hr>

													<div class="form-group validated col-12">
														<h3>Derivado Petróleo</h3>
														<span class="switch switch-outline switch-info">
															<label>
																<input <?php if(isset($produto)): ?> <?php if($produto->perc_glp != ''): ?> checked <?php endif; ?> <?php endif; ?> <?php if(old('der_petroleo')): ?> checked <?php endif; ?>
																id="der_petroleo" name="der_petroleo" value="true" type="checkbox">
																<span></span>
															</label>
														</span>
													</div>
													<div class="col-12 div-petroleo" style="display: none;">
														<div class="row">
															<div class="form-group validated col-lg-6 col-md-10 col-sm-10">
																<label class="col-form-label">ANP</label>

																<select class="custom-select form-control" id="anp" name="anp">
																	<option value="">--</option>
																	<?php $__currentLoopData = $anps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																	<option value="<?php echo e($key); ?>" <?php if(isset($produto->codigo_anp)): ?>
																		<?php if($key == $produto->codigo_anp): ?>
																		selected=""
																		<?php endif; ?>
																		<?php endif; ?> >[<?php echo e($key); ?>] - <?php echo e($a); ?>

																	</option>

																	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
																</select>
															</div>

															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">%GLP</label>

																<input type="text" id="perc_glp" class="form-control <?php if($errors->has('perc_glp')): ?> is-invalid <?php endif; ?> trib" name="perc_glp" 
																value="<?php echo e(isset($produto->perc_glp) ? $produto->perc_glp : old('perc_glp')); ?>">
															</div>

															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">%GNn</label>

																<input type="text" id="perc_gnn" class="form-control <?php if($errors->has('perc_gnn')): ?> is-invalid <?php endif; ?> trib" name="perc_gnn" 
																value="<?php echo e(isset($produto->perc_gnn) ? $produto->perc_gnn : old('perc_gnn')); ?>">
															</div>

															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">%GNi</label>

																<input type="text" id="perc_gni" class="form-control <?php if($errors->has('perc_gni')): ?> is-invalid <?php endif; ?> trib" name="perc_gni" 
																value="<?php echo e(isset($produto->perc_gni) ? $produto->perc_gni : old('perc_gni')); ?>">
															</div>

															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">Valor de partida</label>

																<input type="text" id="valor_partida" class="form-control <?php if($errors->has('valor_partida')): ?> is-invalid <?php endif; ?> money" name="valor_partida" 
																value="<?php echo e(isset($produto->valor_partida) ? $produto->valor_partida : old('valor_partida')); ?>">
															</div>

															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">Un. tributável</label>

																<input type="text" id="unidade_tributavel" class="form-control <?php if($errors->has('unidade_tributavel')): ?> is-invalid <?php endif; ?>" data-mask="AAAA" name="unidade_tributavel"
																value="<?php echo e(isset($produto->unidade_tributavel) ? $produto->unidade_tributavel : old('unidade_tributavel')); ?>">
															</div>

															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">Qtd. tributável</label>

																<input type="text" id="quantidade_tributavel" class="form-control <?php if($errors->has('quantidade_tributavel')): ?> is-invalid <?php endif; ?>" data-mask="00000,00" data-mask-reverse="true" name="quantidade_tributavel"
																value="<?php echo e(isset($produto->quantidade_tributavel) ? $produto->quantidade_tributavel : old('quantidade_tributavel')); ?>">
															</div>
														</div>
													</div>


													<hr>
													<div class="form-group validated col-12">
														<h3>Dados de dimensão e peso do produto (Opcional)</h3>
													</div>

													<div class="form-group validated col-lg-2 col-md-4 col-sm-4">
														<label class="col-form-label">Largura (cm)</label>

														<input type="text" id="largura" class="form-control <?php if($errors->has('largura')): ?> is-invalid <?php endif; ?>" name="largura" 
														value="<?php echo e(isset($produto->largura) ? $produto->largura : old('largura')); ?>">

														<?php if($errors->has('largura')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('largura')); ?>

														</div>
														<?php endif; ?>
													</div>

													<div class="form-group validated col-lg-2 col-md-4 col-sm-4">
														<label class="col-form-label">Altura (cm)</label>

														<input type="text" id="altura" class="form-control <?php if($errors->has('altura')): ?> is-invalid <?php endif; ?>" name="altura" 
														value="<?php echo e(isset($produto->altura) ? $produto->altura : old('altura')); ?>">
														<?php if($errors->has('altura')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('altura')); ?>

														</div>
														<?php endif; ?>
													</div>

													<div class="form-group validated col-lg-2 col-md-4 col-sm-4">
														<label class="col-form-label">Comprimento (cm)</label>

														<input type="text" id="comprimento" class="form-control <?php if($errors->has('comprimento')): ?> is-invalid <?php endif; ?>" name="comprimento" value="<?php echo e(isset($produto->comprimento) ? $produto->comprimento : old('comprimento')); ?>">
														<?php if($errors->has('comprimento')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('comprimento')); ?>

														</div>
														<?php endif; ?>
													</div>


													<div class="form-group validated col-lg-2 col-md-4 col-sm-4">
														<label class="col-form-label">Peso liquido</label>

														<input type="text" id="peso_liquido" class="form-control <?php if($errors->has('peso_liquido')): ?> is-invalid <?php endif; ?>" name="peso_liquido" 
														value="<?php echo e(isset($produto->peso_liquido) ? $produto->peso_liquido : old('peso_liquido')); ?>">
														<?php if($errors->has('peso_liquido')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('peso_liquido')); ?>

														</div>
														<?php endif; ?>
													</div>

													<div class="form-group validated col-lg-2 col-md-4 col-sm-4">
														<label class="col-form-label">Peso bruto</label>

														<input type="text" id="peso_bruto" class="form-control <?php if($errors->has('peso_bruto')): ?> is-invalid <?php endif; ?>" name="peso_bruto" 
														value="<?php echo e(isset($produto->peso_bruto) ? $produto->peso_bruto : old('peso_bruto')); ?>">
														<?php if($errors->has('peso_bruto')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('peso_bruto')); ?>

														</div>
														<?php endif; ?>
													</div>

													<?php if(!isset($produto) && getenv("ECOMMERCE") == 1): ?>
													<div class="form-group validated col-sm-6 col-lg-3">
														<label class="col-form-label text-left col-lg-12 col-sm-12">Ecommerce</label>
														<div class="col-6">
															<span class="switch switch-outline switch-danger">
																<label>
																	<input <?php if(old('ecommerce')): ?> checked <?php endif; ?> class="ecommerce" type="checkbox" name="ecommerce">
																	<span></span>
																</label>
															</span>
														</div>
													</div>
													<?php endif; ?>

													<?php if(getenv("LOCACAO") == 1): ?>
													<div class="form-group validated col-sm-6 col-lg-2">
														<label class="col-form-label text-left col-lg-12 col-sm-12">Locação</label>
														<div class="col-6">
															<span class="switch switch-outline switch-info">
																<label>
																	<input <?php if(old('locacao') || (isset($produto) && $produto->valor_locacao > 0)): ?> checked <?php endif; ?> class="locacao" type="checkbox" name="locacao">
																	<span></span>
																</label>
															</span>
														</div>
													</div>

													<div class="form-group validated col-sm-4 col-lg-3 div-loc" <?php if(!isset($produto)): ?> style="display: none;" <?php endif; ?> <?php if(isset($produto) && $produto->valor_locacao == 0): ?> style="display: none;" <?php endif; ?>>
														<label class="col-form-label">Valor locação</label>
														<div class="">
															<input type="text" class="form-control <?php if($errors->has('valor_locacao')): ?> is-invalid <?php endif; ?> money" name="valor_locacao" id="valor_locacao" value="<?php echo e(isset($produto->valor_locacao) ? number_format($produto->valor_locacao, $casasDecimais) : old('valor_locacao')); ?>">
															<?php if($errors->has('valor_locacao')): ?>
															<div class="invalid-feedback">
																<?php echo e($errors->first('valor_locacao')); ?>

															</div>
															<?php endif; ?>
														</div>
													</div>
													<?php endif; ?>

													<div class="col-lg-12 col-xl-12">
														<p class="text-danger">*Se atente a preencher todos os dados para utilizar a Api dos correios.</p>
													</div>

													<?php if(!isset($produto)): ?>
													<div class="col-12 div-ecommmerce" style="display: none;">
														<div class="row">
															<div class="form-group validated col-12">
																<h3>Dados de Ecommerce</h3>
															</div>
															<div class="form-group validated col-lg-4 col-md-4 col-sm-10">
																<label class="col-form-label ">Categoria</label>

																<select id="categoria-select" class="custom-select form-control <?php if($errors->has('categoria_ecommerce_id')): ?> is-invalid <?php endif; ?>" name="categoria_ecommerce_id">
																	<?php $__currentLoopData = $categoriasEcommerce; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
																	<option 
																	<?php if(old('categoria_ecommerce_id') == $c->id): ?> selected <?php endif; ?>
																	value="<?php echo e($c->id); ?>"><?php echo e($c->nome); ?></option>
																	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
																</select>

																<?php if($errors->has('categoria_ecommerce_id')): ?>
																<div class="invalid-feedback">
																	<?php echo e($errors->first('categoria_ecommerce_id')); ?>

																</div>
																<?php endif; ?>
															</div>

															<div class="form-group validated col-lg-4 col-md-6 col-sm-10">
																<label class="col-form-label">Sub Categoria</label>
																<div class="input-group">

																	<select id="sub_categoria_ecommerce_id" class="form-control custom-select" name="sub_categoria_ecommerce_id">
																		<option value="">--</option>
																	</select>

																	<?php if($errors->has('sub_categoria_ecommerce_id')): ?>
																	<div class="invalid-feedback">
																		<?php echo e($errors->first('sub_categoria_ecommerce_id')); ?>

																	</div>
																	<?php endif; ?>
																</div>
															</div>

															<div class="form-group validated col-sm-4 col-lg-3">
																<label class="col-form-label">Valor</label>
																<div class="">
																	<input type="text" class="form-control <?php if($errors->has('valor_ecommerce')): ?> is-invalid <?php endif; ?> money" name="valor_ecommerce" id="valor_ecommerce" value="<?php echo e(old('valor_ecommerce')); ?>">
																	<?php if($errors->has('valor_ecommerce')): ?>
																	<div class="invalid-feedback">
																		<?php echo e($errors->first('valor_ecommerce')); ?>

																	</div>
																	<?php endif; ?>
																</div>
															</div>

															<div class="col col-sm-3 col-lg-3">
																<br>
																<label>Controlar estoque:</label>

																<div class="switch switch-outline switch-success">
																	<label class="">
																		<input value="true" name="controlar_estoque" class="red-text" <?php if(old('controlar_estoque')): ?> checked <?php endif; ?> type="checkbox">
																		<span class="lever"></span>
																	</label>
																</div>
															</div>

															<div class="col col-sm-3 col-lg-3">
																<br>
																<label>Ativo:</label>

																<div class="switch switch-outline switch-info">
																	<label class="">
																		<input value="true" name="status" <?php if(old('status')): ?> checked <?php endif; ?> class="red-text" type="checkbox">
																		<span class="lever"></span>
																	</label>
																</div>
															</div>

															<div class="col col-sm-3 col-lg-3">
																<br>
																<label>Destaque:</label>

																<div class="switch switch-outline switch-primary">
																	<label class="">
																		<input value="true" name="destaque" <?php if(old('destaque')): ?> checked <?php endif; ?> class="red-text" type="checkbox">
																		<span class="lever"></span>
																	</label>
																</div>
															</div>

															<div class="form-group validated col-sm-12 col-lg-12">
																<label class="col-form-label">Descrição</label>
																<div class="">

																	<div class="row">
																		<div class="col-12">
																			<textarea name="descricao" id="descricao" style="width: 800px;height:500px;"><?php echo e(old('descricao')); ?></textarea>
																		</div>
																	</div>

																	<?php if($errors->has('descricao')): ?>
																	<div class="invalid-feedback">
																		<?php echo e($errors->first('descricao')); ?>

																	</div>
																	<?php endif; ?>
																</div>
															</div>
														</div>
													</div>
													<?php endif; ?>

													<hr>
													<div class="form-group validated col-12">
														<h3>Lote e Vencimento (Opcional)</h3>

														<span class="switch switch-outline switch-info">
															<label>
																<input <?php if(isset($produto)): ?> <?php if($produto->lote != ''): ?> checked <?php endif; ?> <?php endif; ?> <?php if(old('lote')): ?> checked <?php endif; ?>
																id="lote_venc" value="true" class="red-text" type="checkbox">
																<span></span>
															</label>
														</span>
													</div>

													<div class="div_lote col-12" style="display: none">
														<div class="row">
															<div class="form-group validated col-lg-2 col-md-4 col-sm-4">
																<label class="col-form-label">Lote</label>

																<input type="text" id="lote" class="form-control <?php if($errors->has('lote')): ?> is-invalid <?php endif; ?>" name="lote" 
																value="<?php echo e(isset($produto->lote) ? $produto->lote : old('lote')); ?>">
																<?php if($errors->has('lote')): ?>
																<div class="invalid-feedback">
																	<?php echo e($errors->first('lote')); ?>

																</div>
																<?php endif; ?>
															</div>

															<div class="form-group validated col-lg-2 col-md-4 col-sm-4">
																<label class="col-form-label">Vencimento</label>

																<input type="text" id="kt_datepicker_3" class="form-control <?php if($errors->has('vencimento')): ?> is-invalid <?php endif; ?>" data-mask="00/00/0000" data-mask-reverse="true" name="vencimento" 
																value="<?php echo e(isset($produto->vencimento) ? $produto->vencimento : old('vencimento')); ?>">
																<?php if($errors->has('vencimento')): ?>
																<div class="invalid-feedback">
																	<?php echo e($errors->first('vencimento')); ?>

																</div>
																<?php endif; ?>
															</div>
														</div>
													</div>

													<hr>
													<div class="form-group validated col-12">
														<h3>Dados Veiculo (Opcional)</h3>

														<span class="switch switch-outline switch-info">
															<label>
																<input <?php if(isset($produto)): ?> <?php if($produto->renavam != ''): ?> checked <?php endif; ?> <?php endif; ?> id="tp_veiculo" value="true" class="red-text" type="checkbox">
																<span></span>
															</label>
														</span>
													</div>

													<div class="div_veiculo col-12" style="display: none">
														<div class="row">
															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">Renavam</label>

																<input type="text" id="renavam" class="form-control <?php if($errors->has('renavam')): ?> is-invalid <?php endif; ?>" name="renavam" 
																value="<?php echo e(isset($produto->renavam) ? $produto->renavam : old('renavam')); ?>">
																<?php if($errors->has('renavam')): ?>
																<div class="invalid-feedback">
																	<?php echo e($errors->first('renavam')); ?>

																</div>
																<?php endif; ?>
															</div>

															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">Placa</label>

																<input type="text" id="placa" class="form-control <?php if($errors->has('placa')): ?> is-invalid <?php endif; ?>" name="placa" 
																value="<?php echo e(isset($produto->placa) ? $produto->placa : old('placa')); ?>">
																<?php if($errors->has('placa')): ?>
																<div class="invalid-feedback">
																	<?php echo e($errors->first('placa')); ?>

																</div>
																<?php endif; ?>
															</div>

															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">Chassi</label>

																<input type="text" id="chassi" class="form-control <?php if($errors->has('chassi')): ?> is-invalid <?php endif; ?>" name="chassi" 
																value="<?php echo e(isset($produto->chassi) ? $produto->chassi : old('chassi')); ?>">
																<?php if($errors->has('chassi')): ?>
																<div class="invalid-feedback">
																	<?php echo e($errors->first('chassi')); ?>

																</div>
																<?php endif; ?>
															</div>

															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">Combustível</label>

																<input type="text" id="combustivel" class="form-control <?php if($errors->has('combustivel')): ?> is-invalid <?php endif; ?>" name="combustivel" 
																value="<?php echo e(isset($produto->combustivel) ? $produto->combustivel : old('combustivel')); ?>">
																<?php if($errors->has('combustivel')): ?>
																<div class="invalid-feedback">
																	<?php echo e($errors->first('combustivel')); ?>

																</div>
																<?php endif; ?>
															</div>

															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">Ano/Modelo</label>

																<input type="text" id="ano_modelo" class="form-control <?php if($errors->has('ano_modelo')): ?> is-invalid <?php endif; ?>" name="ano_modelo" 
																value="<?php echo e(isset($produto->ano_modelo) ? $produto->ano_modelo : old('ano_modelo')); ?>">
																<?php if($errors->has('ano_modelo')): ?>
																<div class="invalid-feedback">
																	<?php echo e($errors->first('ano_modelo')); ?>

																</div>
																<?php endif; ?>
															</div>

															<div class="form-group validated col-lg-3 col-md-4 col-sm-4">
																<label class="col-form-label">Cor</label>

																<input type="text" id="cor_veiculo" class="form-control <?php if($errors->has('cor_veiculo')): ?> is-invalid <?php endif; ?>" name="cor_veiculo" 
																value="<?php echo e(isset($produto->cor_veiculo) ? $produto->cor_veiculo : old('cor_veiculo')); ?>">
																<?php if($errors->has('cor_veiculo')): ?>
																<div class="invalid-feedback">
																	<?php echo e($errors->first('cor_veiculo')); ?>

																</div>
																<?php endif; ?>
															</div>

														</div>

													</div>

												</div>

											</div>
										</div>

									</div>
								</div>
								<div class="pb-5" data-wizard-type="step-content">

									<div class="row">
										<div class="col-xl-12">
											<div class="row">
												
												<div class="form-group validated col-lg-10 col-md-10 col-sm-10">
													<label class="col-form-label text-left col-lg-12 col-sm-12">
														<?php if($tributacao->regime == 1): ?>
														CST
														<?php else: ?>
														CSOSN
														<?php endif; ?>
													*</label>

													<select class="custom-select form-control" id="CST_CSOSN" name="CST_CSOSN">
														<?php $__currentLoopData = $listaCSTCSOSN; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<option value="<?php echo e($key); ?>" <?php if($config !=null): ?> <?php if(isset($produto)): ?> <?php if($key==$produto->CST_CSOSN): ?>
															selected
															<?php endif; ?>
															<?php else: ?>
															<?php if($key == $config->CST_CSOSN_padrao): ?>
															selected
															<?php endif; ?>
															<?php endif; ?>

															<?php endif; ?>
															><?php echo e($key); ?> - <?php echo e($c); ?>

														</option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>

												</div>

												<div class="form-group validated col-lg-5 col-md-10 col-sm-10">
													<label class="col-form-label text-left col-lg-12 col-sm-12">CST PIS *</label>

													<select class="custom-select form-control" id="CST_CSOSN" name="CST_PIS">
														<?php $__currentLoopData = $listaCST_PIS_COFINS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<option value="<?php echo e($key); ?>" <?php if($config !=null): ?> <?php if(isset($produto)): ?> <?php if($key==$produto->CST_PIS): ?>
															selected
															<?php endif; ?>
															<?php else: ?>
															<?php if($key == $config->CST_PIS_padrao): ?>
															selected
															<?php endif; ?>
															<?php endif; ?>

															<?php endif; ?>
															><?php echo e($key); ?> - <?php echo e($c); ?>

														</option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>

												</div>

												<div class="form-group validated col-lg-5 col-md-10 col-sm-10">
													<label class="col-form-label text-left col-lg-12 col-sm-12">CST COFINS *</label>

													<select class="custom-select form-control" id="CST_CSOSN" name="CST_COFINS">
														<?php $__currentLoopData = $listaCST_PIS_COFINS; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<option value="<?php echo e($key); ?>" <?php if($config !=null): ?> <?php if(isset($produto)): ?> <?php if($key==$produto->CST_COFINS): ?>
															selected
															<?php endif; ?>
															<?php else: ?>
															<?php if($key == $config->CST_COFINS_padrao): ?>
															selected
															<?php endif; ?>
															<?php endif; ?>

															<?php endif; ?>
															><?php echo e($key); ?> - <?php echo e($c); ?>

														</option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>

												</div>

												<div class="form-group validated col-lg-10 col-md-10 col-sm-10">
													<label class="col-form-label text-left col-lg-12 col-sm-12">CST IPI *</label>

													<select class="custom-select form-control" id="CST_IPI" name="CST_IPI">
														<?php $__currentLoopData = $listaCST_IPI; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<option value="<?php echo e($key); ?>" <?php if($config !=null): ?> <?php if(isset($produto)): ?> <?php if($key==$produto->CST_IPI): ?>
															selected
															<?php endif; ?>
															<?php else: ?>
															<?php if($key == $config->CST_IPI_padrao): ?>
															selected
															<?php endif; ?>
															<?php endif; ?>

															<?php endif; ?>
															><?php echo e($key); ?> - <?php echo e($c); ?>

														</option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>

												</div>



												<div class="form-group validated col-lg-10 col-md-10 col-sm-10">
													<label class="col-form-label text-left col-lg-12 col-sm-12">
														<?php if($tributacao->regime == 1): ?>
														CST Exportação
														<?php else: ?>
														CSOSN Exportação
														<?php endif; ?>
													*</label>

													<select class="custom-select form-control" id="CST_CSOSN_EXP" name="CST_CSOSN_EXP">
														<option value="">--</option>
														<?php $__currentLoopData = $listaCSTCSOSN; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
														<option value="<?php echo e($key); ?>" <?php if(isset($produto)): ?> <?php if($key==$produto->CST_CSOSN_EXP): ?>
															selected
															<?php endif; ?>
															<?php endif; ?>

															><?php echo e($key); ?> - <?php echo e($c); ?>

														</option>
														<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
													</select>

												</div>

												<div class="form-group validated col-sm-4 col-lg-4">
													<label class="col-form-label">CFOP saida interno *</label>
													<div class="">
														<input type="text" id="CFOP_saida_estadual" class="form-control <?php if($errors->has('CFOP_saida_estadual')): ?> is-invalid <?php endif; ?>" name="CFOP_saida_estadual" 
														value="<?php echo e(isset($produto->CFOP_saida_estadual) ? $produto->CFOP_saida_estadual : $natureza->CFOP_saida_estadual); ?>">
														<?php if($errors->has('CFOP_saida_estadual')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('CFOP_saida_estadual')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>
												<div class="form-group validated col-sm-4 col-lg-4">
													<label class="col-form-label">CFOP saida externo *</label>
													<div class="">
														<input type="text" id="CFOP_saida_inter_estadual" class="form-control <?php if($errors->has('CFOP_saida_inter_estadual')): ?> is-invalid <?php endif; ?>" name="CFOP_saida_inter_estadual" 
														value="<?php echo e(isset($produto->CFOP_saida_inter_estadual) ? $produto->CFOP_saida_inter_estadual : $natureza->CFOP_saida_inter_estadual); ?>">
														<?php if($errors->has('CFOP_saida_inter_estadual')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('CFOP_saida_inter_estadual')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>

												<div class="form-group validated col-sm-3 col-lg-3">
													<label class="col-form-label">%ICMS *</label>
													<div class="">
														<input type="text" id="perc_icms" class="form-control trib <?php if($errors->has('perc_icms')): ?> is-invalid <?php endif; ?>" name="perc_icms" 
														value="<?php echo e(isset($produto->perc_icms) ? $produto->perc_icms : $tributacao->icms); ?>">
														<?php if($errors->has('perc_icms')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('perc_icms')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>
												<div class="form-group validated col-sm-3 col-lg-3">
													<label class="col-form-label">%PIS *</label>
													<div class="">
														<input type="text" id="perc_pis" class="form-control trib <?php if($errors->has('perc_pis')): ?> is-invalid <?php endif; ?>" name="perc_pis" 
														value="<?php echo e(isset($produto->perc_pis) ? $produto->perc_pis : $tributacao->pis); ?>">
														<?php if($errors->has('perc_pis')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('perc_pis')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>
												<div class="form-group validated col-sm-3 col-lg-3">
													<label class="col-form-label">%COFINS *</label>
													<div class="">
														<input type="text" id="perc_cofins" class="form-control trib <?php if($errors->has('perc_cofins')): ?> is-invalid <?php endif; ?>" name="perc_cofins" 
														value="<?php echo e(isset($produto->perc_cofins) ? $produto->perc_cofins : $tributacao->cofins); ?>">
														<?php if($errors->has('perc_cofins')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('perc_cofins')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>
												<div class="form-group validated col-sm-3 col-lg-3">
													<label class="col-form-label">%IPI *</label>
													<div class="">
														<input type="text" id="perc_ipi" class="form-control trib <?php if($errors->has('perc_ipi')): ?> is-invalid <?php endif; ?>" name="perc_ipi" 
														value="<?php echo e(isset($produto->perc_ipi) ? $produto->perc_ipi : $tributacao->ipi); ?>">
														<?php if($errors->has('perc_ipi')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('perc_ipi')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>

												<div class="form-group validated col-sm-3 col-lg-3">
													<label class="col-form-label">%ISS*</label>
													<div class="">
														<input type="text" id="perc_iss" class="form-control trib <?php if($errors->has('perc_iss')): ?> is-invalid <?php endif; ?>" name="perc_iss" 
														value="<?php echo e(isset($produto->perc_iss) ? $produto->perc_iss : 0.00); ?>">
														<?php if($errors->has('perc_iss')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('perc_iss')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>

												<div class="form-group validated col-sm-3 col-lg-3">
													<label class="col-form-label">%Redução BC *</label>
													<div class="">
														<input type="text" id="pRedBC" class="form-control <?php if($errors->has('pRedBC')): ?> is-invalid <?php endif; ?>" name="pRedBC" 
														value="<?php echo e(isset($produto->pRedBC) ? $produto->pRedBC : 0.00); ?>">
														<?php if($errors->has('pRedBC')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('pRedBC')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>

												<div class="form-group validated col-sm-3 col-lg-3">
													<label class="col-form-label">Cod benefício</label>
													<div class="">
														<input type="text" id="cBenef" class="form-control <?php if($errors->has('cBenef')): ?> is-invalid <?php endif; ?>" name="cBenef" 
														value="<?php echo e(isset($produto->cBenef) ? $produto->cBenef : old('cBenef')); ?>">
														<?php if($errors->has('cBenef')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('cBenef')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>
												<div class="form-group validated col-sm-6 col-lg-6">
													<label class="col-form-label">Origem</label>
													<div class="">
														<select name="origem" class="custom-select">
															<?php $__currentLoopData = App\Models\Produto::origens(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $o): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<option value="<?php echo e($key); ?>"
															<?php if(isset($produto)): ?> <?php if($key == $produto->origem): ?>
															selected=""
															<?php endif; ?>
															<?php else: ?>
															<?php if($key == old('origem')): ?>
															selected
															<?php endif; ?>
															<?php endif; ?>
															><?php echo e($key); ?> - <?php echo e($o); ?></option>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</select>
														<?php if($errors->has('origem')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('origem')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>
												<div class="col-xl-12"></div>
												<div class="form-group validated col-sm-3 col-lg-3">
													<label class="col-form-label">%ICMS interestadual</label>
													<div class="">
														<input type="text" id="perc_icms_interestadual" class="form-control <?php if($errors->has('perc_icms_interestadual')): ?> is-invalid <?php endif; ?> trib" name="perc_icms_interestadual" 
														value="<?php echo e(isset($produto->perc_icms_interestadual) ? $produto->perc_icms_interestadual : old('perc_icms_interestadual')); ?>">
														<?php if($errors->has('perc_icms_interestadual')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('perc_icms_interestadual')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>

												<div class="form-group validated col-sm-3 col-lg-3">
													<label class="col-form-label">%ICMS interno</label>
													<div class="">
														<input type="text" id="perc_icms_interno" class="form-control <?php if($errors->has('perc_icms_interno')): ?> is-invalid <?php endif; ?> trib" name="perc_icms_interno" 
														value="<?php echo e(isset($produto->perc_icms_interno) ? $produto->perc_icms_interno : old('perc_icms_interno')); ?>">
														<?php if($errors->has('perc_icms_interno')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('perc_icms_interno')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>

												<div class="form-group validated col-sm-3 col-lg-3">
													<label class="col-form-label">%FCP interestadual</label>
													<div class="">
														<input type="text" id="perc_fcp_interestadual" class="form-control <?php if($errors->has('perc_fcp_interestadual')): ?> is-invalid <?php endif; ?> trib" name="perc_fcp_interestadual" 
														value="<?php echo e(isset($produto->perc_fcp_interestadual) ? $produto->perc_fcp_interestadual : old('perc_fcp_interestadual')); ?>">
														<?php if($errors->has('perc_fcp_interestadual')): ?>
														<div class="invalid-feedback">
															<?php echo e($errors->first('perc_fcp_interestadual')); ?>

														</div>
														<?php endif; ?>
													</div>
												</div>

											</div>
										</div>
									</div>
								</div>

								<input type="hidden" id="subs" value="<?php echo e(json_encode($subs)); ?>">
								<input type="hidden" id="subs_ecommerce" value="<?php echo e(json_encode($subsEcommerce)); ?>">
								<input type="hidden" id="divisoes" value="<?php echo e(json_encode($divisoes)); ?>" name="">
								<input type="hidden" id="subDivisoes" value="<?php echo e(json_encode($subDivisoes)); ?>" name="">
								<input type="hidden" id="combinacoes" value="<?php echo e(old('combinacoes')); ?>" name="combinacoes">

								<div class="card-footer">

									<div class="row">
										<div class="col-xl-2">

										</div>
										<div class="col-lg-3 col-sm-6 col-md-4">
											<a style="width: 100%" class="btn btn-danger" href="/produtos">
												<i class="la la-close"></i>
												<span class="">Cancelar</span>
											</a>
										</div>
										<div class="col-lg-3 col-sm-6 col-md-4">
											<button style="width: 100%" type="submit" class="btn btn-success">
												<i class="la la-check"></i>
												<span class="">Salvar</span>
											</button>
										</div>

									</div>
								</div>
							</div>

						</form>
					</div>
				</div>
				<input type="hidden" id="sub_id" value="<?php if(isset($produto)): ?> <?php echo e($produto->sub_categoria_id); ?> <?php else: ?> 0 <?php endif; ?>" name="">
				<input type="hidden" id="sub_ecommerce_id" value="<?php if(isset($produto)): ?> <?php echo e($produto->sub_categoria_id); ?> <?php else: ?> 0 <?php endif; ?>" name="">
				<!-- end nav -->


			</form>
		</div>
	</div>
</div>
</div>

<div class="modal fade" id="modal-grade1" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Escolha as combinações</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">
				<div class="row">
					<div style="margin-top: 15px;">
						<h3>Divisões</h3>
						<div class="divisoes">
							
						</div>
					</div>
				</div>

				<hr>

				<div class="row">
					<div style="margin-top: 5px;">
						<h3>Subdivisões</h3>
						<div class="subDivisoes">
							
						</div>
					</div>
				</div>

			</div>
			<div class="modal-footer">
				<button style="width: 100%" type="button" onclick="escolhaDivisao()" class="btn btn-success font-weight-bold">OK</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-grade2" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Preencha os campos das combinações</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body modal-body-grade">
				<div class="row">
					<div style="margin-top: 15px;">
						<div class="combinacoes">

						</div>
					</div>
				</div>


			</div>

			<div class="modal-footer">
				<button style="width: 100%" type="button" onclick="finalizarGrade()" class="btn btn-success font-weight-bold">OK</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-categoria" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Nova Categoria</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">

				<div class="row">
					<div class="col-xl-12">

						
						<div class="row">

							<div class="form-group validated col-12">
								<label class="col-form-label" id="lbl_cpf_cnpj">Nome</label>
								<div class="">
									<input type="text" id="nome_categoria" class="form-control <?php if($errors->has('nome')): ?> is-invalid <?php endif; ?>" name="nome">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" id="btn-frete" class="btn btn-danger font-weight-bold spinner-white spinner-right" data-dismiss="modal" aria-label="Close">Fechar</button>
				<button type="button" onclick="salvarCategoria()" class="btn btn-success font-weight-bold spinner-white spinner-right">Salvar</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-sub-categoria" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Nova Sub Categoria</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">

				<div class="row">
					<div class="col-xl-12">

						<div class="row">

							<div class="form-group validated col-12">
								<label class="col-form-label" id="lbl_cpf_cnpj">Nome</label>
								<div class="">
									<input type="text" id="nome_sub_categoria" class="form-control <?php if($errors->has('nome')): ?> is-invalid <?php endif; ?>" name="nome">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" id="btn-frete" class="btn btn-danger font-weight-bold spinner-white spinner-right" data-dismiss="modal" aria-label="Close">Fechar</button>
				<button type="button" onclick="salvarSubCategoria()" class="btn btn-success font-weight-bold spinner-white spinner-right">Salvar</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-marca" data-backdrop="static" tabindex="-1" role="dialog" aria-labelledby="staticBackdrop" aria-hidden="true">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Nova Marca</h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					x
				</button>
			</div>
			<div class="modal-body">

				<div class="row">
					<div class="col-xl-12">

						
						<div class="row">

							<div class="form-group validated col-12">
								<label class="col-form-label" id="lbl_cpf_cnpj">Nome</label>
								<div class="">
									<input type="text" id="nome_marca" class="form-control">
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="modal-footer">
				<button type="button" id="btn-frete" class="btn btn-danger font-weight-bold spinner-white spinner-right" data-dismiss="modal" aria-label="Close">Fechar</button>
				<button type="button" onclick="salvarMarca()" class="btn btn-success font-weight-bold spinner-white spinner-right">Salvar</button>
			</div>
		</div>

	</div>
</div>
<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">

	$(function () {
		let is = $('.ecommerce').is(':checked');
		if(is){
			$('.div-ecommmerce').css('display', 'block')
		}else{
			$('.div-ecommmerce').css('display', 'none')
		}

		is = $('.der_petroleo').is(':checked');
		if(is){
			$('.div-petroleo').css('display', 'block')
		}else{
			$('.div-petroleo').css('display', 'none')
		}
		tpVeiculo();
		tpLote();
		setTimeout(() => {
			montaSubs()
			montaSubsEcommerce()
			let sub_id = $('#sub_id').val()
			if(sub_id > 0){
				sub_id = parseInt(sub_id)
				$('#sub_categoria_id').val(sub_id).change()
			}
			// reloadCombinacao()
		}, 300)

	});


	$('.ecommerce').change((target) => {
		let is = $('.ecommerce').is(':checked');
		if(is){
			$('.div-ecommmerce').css('display', 'block')
		}else{
			$('.div-ecommmerce').css('display', 'none')

		}
	})

	$('#der_petroleo').change((target) => {
		let is = $('#der_petroleo').is(':checked');
		if(is){
			$('.div-petroleo').css('display', 'block')
		}else{
			$('.div-petroleo').css('display', 'none')

		}
	})

	$('.locacao').change((target) => {
		let is = $('.locacao').is(':checked');
		if(is){
			$('.div-loc').css('display', 'block')
		}else{
			$('.div-loc').css('display', 'none')

		}
	})

	function novaCategoria(){
		$('#modal-categoria').modal('show')
	}

	function novaSubCategoria(){
		$('#modal-sub-categoria').modal('show')
	}

	function novaMarca(){
		$('#modal-marca').modal('show')

	}

	function salvarCategoria(){
		let nome = $('#nome_categoria').val()
		if(!nome){
			swal("Erro", "Informe nome", "warning")
		}else{
			let token = $('#_token').val();
			$.post(path + 'categorias/quickSave',
			{
				_token: token,
				nome: nome
			})
			.done((res) =>{

				console.log(res)
				$('#categoria').append('<option value="'+res.id+'">'+ 
					res.nome+'</option>').change();
				$('#categoria').val(res.id).change();
				swal("Sucesso", "Categoria adicionada!!", 'success')
				.then(() => {
					$('#modal-categoria').modal('hide')
				})
			})
			.fail((err) => {
				console.log(err)
				swal("Erro", "Algo deu errado!!", 'error')

			})
		}
	}

	function salvarSubCategoria(){
		let nome = $('#nome_sub_categoria').val()
		let categoria_id = $('#categoria').val()

		if(!categoria_id){
			swal("Erro", "Informe a categoria", "warning")
		}else if(!nome){
			swal("Erro", "Informe nome", "warning")
		}else{
			let token = $('#_token').val();
			$.post(path + 'subcategorias/quickSave',
			{
				_token: token,
				nome: nome,
				categoria_id: categoria_id
			})
			.done((res) =>{

				console.log(res)
				$('#sub_categoria_id').append('<option value="'+res.id+'">'+ 
					res.nome+'</option>').change();
				$('#sub_categoria_id').val(res.id).change();
				swal("Sucesso", "Sub Categoria adicionada!!", 'success')
				.then(() => {
					$('#modal-sub-categoria').modal('hide')
				})
			})
			.fail((err) => {
				console.log(err)
				swal("Erro", "Algo deu errado!!", 'error')

			})
		}
	}

	function salvarMarca(){
		let nome = $('#nome_marca').val()
		if(!nome){
			swal("Erro", "Informe nome", "warning")
		}else{
			let token = $('#_token').val();
			$.post(path + 'marcas/quickSave',
			{
				_token: token,
				nome: nome
			})
			.done((res) =>{

				console.log(res)
				$('#marca').append('<option value="'+res.id+'">'+ 
					res.nome+'</option>').change();
				$('#marca').val(res.id).change();
				swal("Sucesso", "Marca adicionada!!", 'success')
				.then(() => {
					$('#modal-marca').modal('hide')
				})
			})
			.fail((err) => {
				console.log(err)
				swal("Erro", "Algo deu errado!!", 'error')

			})
		}
	}

	$('#tp_veiculo').change(() => {
		tpVeiculo();
	})

	function tpVeiculo(){
		if($('#tp_veiculo').is(':checked')){
			$('.div_veiculo').css('display', 'block')
		}else{
			$('.div_veiculo').css('display', 'none')
		}
	}

	$('#lote_venc').change(() => {
		tpLote();
	})

	function tpLote(){
		if($('#lote_venc').is(':checked')){
			$('.div_lote').css('display', 'block')
		}else{
			$('.div_lote').css('display', 'none')
		}
	}



</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nextsistemas/nextweb.nextsistemas.app.br/resources/views/produtos/register.blade.php ENDPATH**/ ?>