<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">


	<div class="card-body">
		<div class="">
			<div class="col-sm-12 col-lg-4 col-md-6 col-xl-4">

				<a href="/eventos/novaAtividade/<?php echo e($evento->id); ?>" class="btn btn-lg btn-success">
					<i class="fa fa-plus"></i>Nova Atividade
				</a>

				<a href="/eventos/registros/<?php echo e($evento->id); ?>" class="btn btn-lg btn-info">
					<i class="fa fa-money"></i> Registros
				</a>
			</div>
		</div>
		<br>

		<div class="" id="kt_user_profile_aside" style="margin-left: 10px; margin-right: 10px;">

			<form method="get" action="/eventos/filtroAtividade">
				<div class="row align-items-center">

					<input type="hidden" name="evento_id" value="<?php echo e($evento->id); ?>">

					<div class="form-group col-lg-3 col-md-4 col-sm-6">
						<label class="col-form-label">Reponsável</label>
						<div class="">
							<div class="input-group">
								<input type="text" name="responsavel" class="form-control" value="<?php echo e(isset($responsavel) ? $responsavel : ''); ?>" />
							</div>
						</div>
					</div>

					<div class="form-group col-lg-3 col-md-4 col-sm-6">
						<label class="col-form-label">Criança</label>
						<div class="">
							<div class="input-group">
								<input type="text" name="crianca" class="form-control" value="<?php echo e(isset($crianca) ? $crianca : ''); ?>" />
							</div>
						</div>
					</div>

					<div class="form-group col-lg-2 col-md-4 col-sm-6">
						<label class="col-form-label">Estado</label>
						<div class="">
							<div class="input-group date">
								<select class="custom-select form-control" id="estado" name="estado">
									<option <?php if(isset($estado) && $estado == 'TODOS'): ?> selected <?php endif; ?> value="TODOS">TODOS</option>
									<option <?php if(isset($estado) && $estado == 'CONCLUIDO'): ?> selected <?php endif; ?> value="1">CONCLUIDO</option>
									<option <?php if(isset($estado) && $estado == 'OPERANDO'): ?> selected <?php else: ?> selected <?php endif; ?> value="0">OPERANDO</option>
								</select>
							</div>
						</div>
					</div>

					<div class="col-lg-2 col-xl-2 mt-2 mt-lg-0">
						<button style="margin-top: 15px;" class="btn btn-light-primary px-6 font-weight-bold">Pesquisa</button>
					</div>
				</div>
			</form>
			<br>
			<h4>Lista de Atividades</h4>

			<div class="row">

				<div class="col-sm-12 col-lg-12 col-md-12 col-xl-12">

					<div class="wizard wizard-3" id="kt_wizard_v3" data-wizard-state="between" data-wizard-clickable="true">
						<div class="wizard-nav">

							<div class="wizard-steps px-8 py-8 px-lg-15 py-lg-3">
								<!--begin::Wizard Step 1 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="done">
									<div class="wizard-label">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-table"></i>
												Tabela
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>
								<!--end::Wizard Step 1 Nav-->
								<!--begin::Wizard Step 2 Nav-->
								<div class="wizard-step" data-wizard-type="step" data-wizard-state="current">
									<div class="wizard-label" id="grade">
										<h3 class="wizard-title">
											<span>
												<i style="font-size: 40px" class="la la-tablet"></i>
												Grade
											</span>
										</h3>
										<div class="wizard-bar"></div>
									</div>
								</div>

							</div>
						</div>

						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">

								<div class="col-xl-12">

									<div id="kt_datatable" class="datatable datatable-bordered datatable-head-custom datatable-default datatable-primary datatable-loaded">

										<table class="datatable-table" style="max-width: 100%; overflow: scroll">
											<thead class="datatable-head">
												<tr class="datatable-row" style="left: 0px;">
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">RESPONSÁVEL</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">CRIANÇA</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">TELEFONE</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">STATUS</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">ATIVIDADES</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">INICIO/FIM</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 100px;">VALOR</span></th>
													<th data-field="OrderID" class="datatable-cell datatable-cell-sort"><span style="width: 200px;">AÇÕES</span></th>
												</tr>
											</thead>

											<tbody id="body" class="datatable-body">
												<?php $__currentLoopData = $atividades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<tr class="datatable-row">
													<td class="datatable-cell"><span class="codigo" style="width: 200px;" id="id"><?php echo e($e->responsavel_nome); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 200px;" id="id"><?php echo e($e->crianca_nome); ?></span>
													</td>
													<td class="datatable-cell"><span class="codigo" style="width: 200px;" id="id"><?php echo e($e->responsavel_telefone); ?></span>
													</td>
													<td class="datatable-cell">
														<span class="codigo" style="width: 100px;" id="id">
															<?php if($e->status): ?>
															<span class="label label-xl label-inline label-light-info">CONCLUIDO</span>
															<?php else: ?>
															<span class="label label-xl label-inline label-light-success">OPERANDO</span>
															<?php endif; ?>
														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 100px;" id="id">
															<?php $__currentLoopData = $e->servicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
															<span><?php echo e($s->servico->nome); ?>

																<?php if($key < sizeof($e->servicos)-1): ?> |
																<?php endif; ?>
															</span>
															<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 100px;" id="id">
															<?php echo e(\Carbon\Carbon::parse($e->inicio)->format('H:i')); ?>/<?php echo e(\Carbon\Carbon::parse($e->fim)->format('H:i')); ?>

														</span>
													</td>
													<td class="datatable-cell">
														<span class="codigo" style="width: 100px;" id="id">
															<?php echo e(number_format($e->total, 2, ',', '.')); ?> - <?php echo e($e->forma_pagamento); ?>

														</span>
													</td>

													<td class="datatable-cell">
														<span class="codigo" style="width: 200px;" id="id">
															<?php if($e->status == 0): ?>
															<a class="btn btn-danger" href="/eventos/finalizarAtividade/<?php echo e($e->id); ?>">
																<i class="la la-close"></i>	
															</a>
															<?php else: ?>
															<a class="btn btn-info" href="/eventos/finalizarAtividade/<?php echo e($e->id); ?>">
																<i class="la la-list"></i>	
															</a>
															<?php endif; ?>

															<a target="_blank" href="/eventos/imprimirComprovante/<?php echo e($e->id); ?>" class="btn btn-primary">
																<i class="la la-print"></i>
															</a>

															<?php
															$whats = str_replace(" ", "", $e->responsavel_telefone);
															$whats = str_replace("-", "", $whats);
															?>
															<a href="http://wa.me/55<?php echo e($whats); ?>" class="btn btn-success">
																<i class="lab la-whatsapp"></i>
															</a>
														</span>
													</td>
												</tr>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>


						<div class="pb-5" data-wizard-type="step-content">
							<div class="row">
								<?php $__currentLoopData = $atividades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

								<div class="col-sm-12 col-lg-6 col-md-6 col-xl-6">
									<div class="card card-custom gutter-b example example-compact" style="height: 380px;">
										<div class="card-header">
											<div class="card-title">
												<h3 style="width: 230px; font-size: 12px; height: 10px;" class="card-title">
													Responsável: <strong style="margin-left: 5px;" class="text-info"> <?php echo e($e->responsavel_nome); ?></strong> 
												</h3>
												<h3 style="width: 230px; font-size: 12px; height: 10px;" class="card-title">
													Criança: <strong style="margin-left: 5px;" class="text-info"><?php echo e($e->crianca_nome); ?></strong>
												</h3>
											</div>


										</div>

										<div class="card-body">

											<div class="kt-widget__info">
												<span class="kt-widget__label">Atividades:</span>
												<a target="_blank" class="kt-widget__data text-success">
													<?php $__currentLoopData = $e->servicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<span><?php echo e($s->servico->nome); ?>

														<?php if($key < sizeof($e->servicos)-1): ?> |
														<?php endif; ?>
													</span>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												</a>
											</div>
											<div class="kt-widget__info">
												<span class="kt-widget__label">Status:</span>
												<a target="_blank" class="kt-widget__data text-success">
													<?php if($e->status): ?>
													<span class="label label-xl label-inline label-light-info">CONCLUIDO</span>
													<?php else: ?>
													<span class="label label-xl label-inline label-light-success">OPERANDO</span>
													<?php endif; ?>
												</a>
											</div>
											<div class="kt-widget__info">
												<span class="kt-widget__label">Telefone:</span>
												<a target="_blank" class="kt-widget__data text-success">
													<?php echo e($e->responsavel_telefone); ?>

												</a>
											</div>
											<div class="kt-widget__info">
												<span class="kt-widget__label">Início:</span>
												<a target="_blank" class="kt-widget__data text-success">
													<?php echo e(\Carbon\Carbon::parse($e->inicio)->format('H:i')); ?>

												</a>
											</div>
											<div class="kt-widget__info">
												<span class="kt-widget__label">Fim:</span>
												<a target="_blank" class="kt-widget__data text-danger">
													<?php echo e(\Carbon\Carbon::parse($e->fim)->format('H:i')); ?>

												</a>
											</div>

											<?php if($e->status == 1): ?>
											<div class="kt-widget__info">
												<span class="kt-widget__label">Valor:</span>
												<a target="_blank" class="kt-widget__data text-danger">
													<?php echo e(number_format($e->total, 2, ',', '.')); ?> - <?php echo e($e->forma_pagamento); ?>

												</a>
											</div>
											<?php endif; ?>


										</div>

										<div class="card-footer">
											<?php if($e->status == 0): ?>
											<a style="width: 100%;" href="/eventos/finalizarAtividade/<?php echo e($e->id); ?>" class="btn btn-light-danger">
												<i class="la la-close"></i>
												Finalizar
											</a>
											<?php else: ?>
											<a style="width: 100%;" href="/eventos/finalizarAtividade/<?php echo e($e->id); ?>" class="btn btn-light-info">
												<i class="la la-list"></i>
												Detalhes
											</a>
											<?php endif; ?>

											<a style="width: 100%;" target="_blank" href="/eventos/imprimirComprovante/<?php echo e($e->id); ?>" class="btn btn-light-primary">
												<i class="la la-print"></i>
												Imprimir
											</a>

											<?php
											$whats = str_replace(" ", "", $e->responsavel_telefone);
											$whats = str_replace("-", "", $whats);
											?>
											<a target="_blank" style="width: 100%;"href="http://wa.me/55<?php echo e($whats); ?>" class="btn btn-light-success">
												<i class="lab la-whatsapp"></i>
												WhatsApp
											</a>
										</div>
									</div>
								</div>

								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="d-flex justify-content-between align-items-center flex-wrap">
				<div class="d-flex flex-wrap py-2 mr-3">
					<?php if(isset($links)): ?>
					<?php echo e($eventos->links()); ?>

					<?php endif; ?>
				</div>
			</div>
		</div>

	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('default.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/marcosbueno/Documents/laravel/metronic_multi_8.4/resources/views/eventos/atividades.blade.php ENDPATH**/ ?>