<?php

namespace App\Http\Controllers\Pdv;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ConfigNota;
use App\Models\Tributacao;

class ConfigController extends Controller
{
	public function index(Request $request){
		$config = ConfigNota::
		where('empresa_id', $request->empresa_id)
		->first();

		$tributacao = Tributacao::
		where('empresa_id', $request->empresa_id)
		->first();
		$objeto = [];

		if($config != null && $tributacao != null){
			$objeto = [
				'numeroSerieNfe' => $config->numero_serie_nfe,
				'ultimoNumeroNfe' => $config->ultimo_numero_nfe,
				'numeroSerieNfce' => $config->numero_serie_nfce,
				'ultimoNumeroNfce' => $config->ultimo_numero_nfce,
				'ambiente' => $config->ambiente,
				'regime' => $tributacao->regime,
				'naturezaOperacao' => $config->natureza ? $config->natureza->natureza : ''
			];
		}

		return response()->json($objeto, 200);
	}
}
