<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mdfe_create')): ?>
                    <a href="<?php echo e(route('mdfe.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i> Nova MDFe
                    </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('mdfe.nao-encerrados')); ?>" type="button" class="btn btn-danger">
                        <i class="ri-close-fill"></i> Ver documentos não encerrados
                    </a>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mdfe_create')): ?>
                    <button class="btn btn-dark" id="btn-importar_nfe" data-bs-toggle="modal" data-bs-target="#modal-importar_nfe">
                        <i class="ri-file-upload-fill"></i> Selecionar Documentos NFe
                    </button>
                    <?php endif; ?>
                </div>

                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('estado', 'Estado',
                            ['novo' => 'Nova',
                            'rejeitado' => 'Rejeitadas',
                            'cancelado' => 'Canceladas',
                            'aprovado' => 'Aprovadas',
                            '' => 'Todos'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>

                        <?php if(__countLocalAtivo() > 1): ?>
                        <div class="col-md-2">
                            <?php echo Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <?php endif; ?>
                        <div class="col-md-4">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('mdfe.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>

                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Data Início da Viagem</th>
                                    <th>Data Criação</th>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <th>Local</th>
                                    <?php endif; ?>
                                    <th>CNPJ Contratante</th>
                                    <th>Estado Fiscal</th>
                                    <th>Chave</th>
                                    <th>Número</th>
                                    <th>Veículo Tração</th>
                                    <th>Quantidade Carga</th>
                                    <th>Valor Carga</th>
                                    <th>Local de emissão</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(__data_pt($item->data_inicio_viagem, 0)); ?></td>
                                    <td><?php echo e(__data_pt($item->created_at, 0)); ?></td>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <td class="text-danger"><?php echo e($item->localizacao->descricao); ?></td>
                                    <?php endif; ?>
                                    <td><?php echo e($item->cnpj_contratante); ?></td>
                                    <td><?php echo $item->estadoEmissao($item->estado_emissao); ?></td>
                                    <td><?php echo e($item->chave); ?></td>
                                    <td><?php echo e($item->mdfe_numero > 0 ? $item->mdfe_numero : '--'); ?></td>
                                    <td><?php echo e($item->veiculoTracao->marca); ?> - <?php echo e($item->veiculoTracao->placa); ?> </td>
                                    <td><?php echo e($item->quantidade_carga); ?></td>
                                    <td><?php echo e(__moeda( $item->valor_carga)); ?></td>
                                    <td>
                                        <?php if($item->api): ?>
                                        <span class="text-success">API</span>
                                        <?php else: ?>
                                        <span class="text-primary">Painel</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('mdfe.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 350px">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            <?php if($item->estado_emissao == 'cancelado'): ?>
                                            
                                            <?php endif; ?>
                                            <?php if($item->estado_emissao == 'aprovado'): ?>
                                            <a class="btn btn-primary btn-sm" target="_blank" href="<?php echo e(route('mdfe.imprimir', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>

                                            <a class="btn btn-light btn-sm" target="_blank" href="<?php echo e(route('mdfe.download', [$item->id])); ?>">
                                                <i class="ri-download-2-fill"></i>
                                            </a>

                                            <button title="Cancelar MDFe" type="button" class="btn btn-danger btn-sm" onclick="cancelar('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-close-circle-line"></i>
                                            </button>

                                            <?php endif; ?>

                                            <?php if($item->estado_emissao == 'aprovado' || $item->estado_emissao == 'rejeitado'): ?>
                                            <button type="button" class="btn btn-info btn-sm" onclick="info('<?php echo e($item->motivo_rejeicao); ?>', '<?php echo e($item->chave); ?>', '<?php echo e($item->estado); ?>', '<?php echo e($item->recibo); ?>')">
                                                <i class="ri-file-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php if($item->estado_emissao == 'novo' || $item->estado_emissao == 'rejeitado'): ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mdfe_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('mdfe.edit', $item->id)); ?>">
                                                <i class="ri-edit-line"></i>
                                            </a>
                                            <?php endif; ?>

                                            <a target="_blank" title="XML temporário" class="btn btn-light btn-sm" href="<?php echo e(route('mdfe.xml-temp', $item->id)); ?>">
                                                <i class="ri-file-line"></i>
                                            </a>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('mdfe_delete')): ?>
                                            <button type="button" class="btn btn-danger btn-sm btn-delete"><i class="ri-delete-bin-line"></i></button>
                                            <?php endif; ?>
                                            
                                            <button title="Transmitir MDFe" type="button" class="btn btn-success btn-sm" onclick="transmitir('<?php echo e($item->id); ?>')">
                                                <i class="ri-send-plane-fill"></i>
                                            </button>
                                            <?php endif; ?>

                                            <?php if($item->estado_emissao == 'aprovado' || $item->estado_emissao == 'cancelado'): ?>
                                            <button title="Consultar MDFe" type="button" class="btn btn-light btn-sm" onclick="consultar('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-file-search-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <a title="Alterar estado fiscal" class="btn btn-dark btn-sm" href="<?php echo e(route('mdfe.alterar-estado', $item->id)); ?>">
                                                <i class="ri-arrow-up-down-line"></i>
                                            </a>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="11" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $data->appends(request()->all())->links(); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-cancelar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Cancelar MDFe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-12">
                        <?php echo Form::text('motivo-cancela', 'Motivo')
                        ->required(); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-cancelar" class="btn btn-danger">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    function info(motivo_rejeicao, chave, estado, recibo) {

        if (estado == 'rejeitado') {
            let text = "Motivo: " + motivo_rejeicao + "\n"
            text += "Chave: " + chave + "\n"
            swal("", text, "warning")
        } else {
            let text = "Chave: " + chave + "\n"
            swal("", text, "success")
        }
    }

</script>
<script type="text/javascript" src="/js/mdfe.js"></script>
<script type="text/javascript" src="/js/mdfe_transmitir.js"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('modals._importar_nfe', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'MDFe'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/mdfe/index.blade.php ENDPATH**/ ?>