<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-2">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reserva_create')): ?>
                    <a href="<?php echo e(route('reservas.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova Reserva
                    </a>
                    <?php endif; ?>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::select('cliente_id', 'Cliente')
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('estado', 'Estado',
                            ['pendente' => 'Pendente',
                            'iniciado' => 'Iníciado',
                            'finalizado' => 'Finalizado',
                            'cancelado' => 'Cancelado',
                            '' => 'Todos'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('reservas.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="row">

                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <strong class="text-success">#<?php echo e($item->numero_sequencial); ?></strong>
                                </div>
                                <div class="card-body">
                                    <h6>Data checkin: <strong><?php echo e(__data_pt($item->data_checkin, 0)); ?></strong></h6>
                                    <h6>Data checkout: <strong><?php echo e(__data_pt($item->data_checkout, 0)); ?></strong></h6>
                                    <h6>Cliente: <strong><?php echo e($item->cliente->info); ?></strong></h6>
                                    <h6>Acomodação: <strong><?php echo e($item->acomodacao->info); ?></strong></h6>
                                    <span class="badge bg-<?php echo e($item->colorStatus()); ?>"><?php echo e(strtoupper($item->estado)); ?></span>
                                </div>

                                <div class="card-footer">
                                    <a href="<?php echo e(route('reservas.show', [$item->id])); ?>" class="btn btn-dark w-100">
                                        <i class="ri-eye-2-line"></i>
                                        Visualizar reserva
                                    </a>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Reservas'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/reservas/index.blade.php ENDPATH**/ ?>