<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">

                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::select('funcionario_id', 'Garçom')
                            ->options($funcionario ? [$funcionario->id => $funcionario->nome] : []); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('atendimento-garcom.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-12 mt-3">
                    <span>Total de registros: <strong><?php echo e($data->total()); ?></strong></span>
                    <div class="table-responsive">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Garçom</th>
                                    <th>Data Registro</th>
                                    <th>Comanda</th>
                                    <th>Produto</th>
                                    <th>Valor</th>
                                    <th>Quantidade</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->funcionario ? $item->funcionario->nome : ''); ?></td>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td><?php echo e($item->pedido->comanda); ?></td>
                                    <td><?php echo e($item->produto->nome); ?></td>
                                    <td><?php echo e(__moeda($item->sub_total)); ?></td>
                                    <td>
                                        <?php if($item->produto->unidade == 'UN'): ?>
                                        <?php echo e(number_format($item->quantidade, 0)); ?>

                                        <?php else: ?>
                                        <?php echo e($item->quantidade); ?>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                            <tfoot class="table-dark">
                                <tr>
                                    <td colspan="4">Total</td>
                                    <td colspan="2"><?php echo e(__moeda($data->sum('sub_total'))); ?></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>

                <br>
                <h4>Total: <strong class="text-success">R$ <?php echo e(__moeda($soma)); ?></strong></h4>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => 'Atendimento Garçom'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/atendimento_garcom/index.blade.php ENDPATH**/ ?>