<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('devolucao_create')): ?>
                        <a href="<?php echo e(route('devolucao.xml')); ?>" class="btn btn-danger">
                            <i class="ri-add-circle-fill"></i>
                            Nova Devolução
                        </a>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-8"></div>

                    <?php if(__isPlanoFiscal()): ?>
                    <div class="col-md-2">
                        <button id="btn-consulta-sefaz" class="btn btn-dark" style="float: right;">
                            <i class="ri-refresh-line"></i>
                            Consultar Status Sefaz
                        </button>
                    </div>
                    <?php endif; ?>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3 g-1">
                        <div class="col-md-4">
                            <?php echo Form::select('fornecedor_id', 'Fornecedor')
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <?php if(__isPlanoFiscal()): ?>
                        <div class="col-md-2">
                            <?php echo Form::select('estado', 'Estado',
                            ['novo' => 'Novas',
                            'rejeitado' => 'Rejeitadas',
                            'cancelado' => 'Canceladas',
                            'aprovado' => 'Aprovadas',
                            '' => 'Todos'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('tpNF', 'Tipo',
                            [
                            '1' => 'Saída',
                            '0' => 'Entrada',
                            '' => 'Todos'
                            ])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <?php endif; ?>

                        <?php if(__countLocalAtivo() > 1): ?>
                        <div class="col-md-2">
                            <?php echo Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <?php endif; ?>

                        <div class="col-lg-4 col-12">
                            <br>

                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('devolucao.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Fornecedor</th>
                                    <th>CPF/CNPJ</th>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <th>Local</th>
                                    <?php endif; ?>
                                    <th>Número</th>
                                    <th>Valor</th>
                                    <?php if(__isPlanoFiscal()): ?>
                                    <th>Estado</th>
                                    <th>Ambiente</th>
                                    <?php endif; ?>
                                    <th>Data</th>
                                    <th>Local de emissão</th>
                                    <th>CRT</th>
                                    <th>Tipo</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->numero_sequencial); ?></td>
                                    <?php if($item->cliente): ?>
                                    <td><label style="width: 300px"><?php echo e($item->cliente ? $item->cliente->razao_social : "--"); ?></label></td>
                                    <td><label style="width: 150px"><?php echo e($item->cliente ? $item->cliente->cpf_cnpj : "--"); ?></label></td>
                                    <?php else: ?>
                                    <td><label style="width: 300px"><?php echo e($item->fornecedor ? $item->fornecedor->razao_social : "--"); ?></label></td>
                                    <td><label style="width: 150px"><?php echo e($item->fornecedor ? $item->fornecedor->cpf_cnpj : "--"); ?></label></td>
                                    <?php endif; ?>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <td class="text-danger"><?php echo e($item->localizacao ? $item->localizacao->descricao : ''); ?></td>
                                    <?php endif; ?>
                                    <td><?php echo e($item->numero ? $item->numero : ''); ?></td>
                                    <td><?php echo e(__moeda($item->total)); ?></td>
                                    <?php if(__isPlanoFiscal()): ?>
                                    <td width="150">
                                        <?php if($item->estado == 'aprovado'): ?>
                                        <span class="btn btn-success text-white btn-sm w-100">Aprovado</span>
                                        <?php elseif($item->estado == 'cancelado'): ?>
                                        <span class="btn btn-danger text-white btn-sm w-100">Cancelado</span>
                                        <?php elseif($item->estado == 'rejeitado'): ?>
                                        <span class="btn btn-warning text-white btn-sm w-100">Rejeitado</span>
                                        <?php else: ?>
                                        <span class="btn btn-info text-white btn-sm w-100">Novo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->ambiente == 2 ? 'Homologação' : 'Produção'); ?></td>
                                    <?php endif; ?>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td>
                                        <?php if($item->api): ?>
                                        <span class="text-success">API</span>
                                        <?php else: ?>
                                        <span class="text-primary">Painel</span>
                                        <?php endif; ?>
                                    </td>
                                    <td style="width: 200px">
                                        <?php if($item->crt == 1): ?>
                                        <span class="text-info">Simples Nacional</span>
                                        <?php elseif($item->crt == 2): ?>
                                        <span class="text-primary">Simples Nacional, excesso sublimite de receita bruta</span>
                                        <?php elseif($item->crt == 3): ?>
                                        <span class="text-primary">Regime Normal</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item->tpNF): ?>
                                        <span class="text-success">Saída</span>
                                        <?php else: ?>
                                        <span class="text-primary">Entrada</span>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <form action="<?php echo e(route('devolucao.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 360px">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>

                                            <?php if($item->estado == 'cancelado'): ?>
                                            <a class="btn btn-danger btn-sm" target="_blank" href="<?php echo e(route('nfe.imprimir-cancela', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php if($item->estado == 'aprovado'): ?>
                                            <!-- <a class="btn btn-primary btn-sm" title="Imprimir NFe" target="_blank" href="<?php echo e(route('nfe.imprimir', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a> -->

                                            <button type="button" onclick="imprimir('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')" class="btn btn-primary btn-sm" title="Imprimir NFe">
                                                <i class="ri-printer-line"></i>
                                            </button>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfe_transmitir')): ?>
                                            <button title="Cancelar NFe" type="button" class="btn btn-danger btn-sm" onclick="cancelar('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-close-circle-line"></i>
                                            </button>
                                            <button title="Corrigir NFe" type="button" class="btn btn-warning btn-sm" onclick="corrigir('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-file-warning-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <?php endif; ?>

                                            <?php if($item->estado == 'aprovado' || $item->estado == 'rejeitado'): ?>
                                            <button title="Consultar status" type="button" class="btn btn-dark btn-sm" onclick="info('<?php echo e($item->motivo_rejeicao); ?>', '<?php echo e($item->chave); ?>', '<?php echo e($item->estado); ?>', '<?php echo e($item->recibo); ?>')">
                                                <i class="ri-file-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <?php if($item->estado == 'novo' || $item->estado == 'rejeitado'): ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('devolucao_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('devolucao.edit', $item->id)); ?>">
                                                <i class="ri-edit-line"></i>
                                            </a>
                                            <?php endif; ?>

                                            <?php if(__isPlanoFiscal()): ?>
                                            <a target="_blank" title="XML temporário" class="btn btn-light btn-sm" href="<?php echo e(route('nfe.xml-temp', $item->id)); ?>">
                                                <i class="ri-file-line"></i>
                                            </a>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('devolucao_delete')): ?>
                                            <button title="Remover devolução" type="button" class="btn btn-danger btn-sm btn-delete"><i class="ri-delete-bin-line"></i></button>
                                            <?php endif; ?>

                                            <?php if(__isPlanoFiscal()): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfe_transmitir')): ?>
                                            <button title="Transmitir NFe" type="button" class="btn btn-success btn-sm" onclick="transmitir('<?php echo e($item->id); ?>')">
                                                <i class="ri-send-plane-fill"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php endif; ?>

                                            <?php endif; ?>
                                            
                                            <?php if($item->estado == 'aprovado' || $item->estado == 'cancelado'): ?>
                                            <button title="Consultar NFe" type="button" class="btn btn-light btn-sm" onclick="consultar('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-file-search-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php if(__isPlanoFiscal()): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('devolucao_edit')): ?>
                                            <a title="Alterar estado fiscal devolução" class="btn btn-danger btn-sm" href="<?php echo e(route('nfe.alterar-estado', [$item->id, 'tipo=devolucao'])); ?>">
                                                <i class="ri-arrow-up-down-line"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                            

                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="13" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $data->appends(request()->all())->links(); ?>

                </div>
                <h5 class="mt-2">Soma: <strong class="text-success">R$ <?php echo e(__moeda($data->sum('total'))); ?></strong></h5>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-print" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Imprimir NFe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-12 col-lg-4">
                        <button type="button" class="btn btn-success w-100" onclick="gerarDanfe('danfe')">
                            <i class="ri-printer-line"></i>
                            DANFE
                        </button>
                    </div>

                    <div class="col-12 col-lg-4">
                        <button type="button" class="btn btn-primary w-100" onclick="gerarDanfe('simples')">
                            <i class="ri-printer-line"></i>
                            DANFE Simples
                        </button>
                    </div>

                    <div class="col-12 col-lg-4">
                        <button type="button" class="btn btn-dark w-100" onclick="gerarDanfe('etiqueta')">
                            <i class="ri-printer-line"></i>
                            DANFE Etiqueta
                        </button>
                    </div>

                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-cancelar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Cancelar NFe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-12">
                        <?php echo Form::text('motivo-cancela', 'Motivo')
                        ->required(); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-cancelar" class="btn btn-danger">Cancelar</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal-corrigir" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Corrigir NFe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-12">
                        <?php echo Form::text('motivo-corrigir', 'Motivo')
                        ->required(); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-corrigir" class="btn btn-warning">Corrigir</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    function info(motivo_rejeicao, chave, estado, recibo) {
        if (estado == 'rejeitado') {
            let text = "Motivo: " + motivo_rejeicao + "\n"
            text += "Chave: " + chave + "\n"
            swal("", text, "warning")
        } else {
            let text = "Chave: " + chave + "\n"
            text += "Recibo: " + recibo + "\n"
            swal("", text, "success")
        }
    }

    $('#btn-consulta-sefaz').click(() => {
        $.post(path_url + 'api/nfe_painel/consulta-status-sefaz', {
            usuario_id: $('#usuario_id').val(),
            empresa_id: $('#empresa_id').val()
        })
        .done((res) => {
            let msg = "cStat: " + res.cStat
            msg += "\nMotivo: " + res.xMotivo
            msg += "\nAmbiente: " + (res.tpAmb == 2 ? "Homologação" : "Produção")
            msg += "\nverAplic: " + res.verAplic

            swal("Sucesso", msg, "success")
        })
        .fail((err) => {
            try {
                swal("Erro", err.responseText, "error")
            } catch {
                swal("Erro", "Algo deu errado", "error")
            }
        })
    })

</script>
<script type="text/javascript" src="/js/nfe_transmitir.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Devoluções'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/devolucao/index.blade.php ENDPATH**/ ?>