<div class="row">
    <div class="col-md-4">
        <?php echo Form::select('produto_id', 'Produto')
        ->attrs(['class' => 'form-select'])->required()
        ->options(isset($item) ? [$item->produto->id => $item->produto->nome] : [])
        ->disabled(isset($item) ? true : false); ?>

    </div>

    <?php if(isset($item) && __countLocalAtivo() > 1): ?>
    <div class="row">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Local</th>
                        <th>Quantidade</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $locais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <?php if($l->local): ?>
                            <input type="hidden" readonly class="form-control" required name="local_id[]" value="<?php echo e($l->id); ?>">
                            <input readonly class="form-control" required value="<?php echo e($l->local->descricao); ?>">
                            <?php else: ?>
                            <input type="hidden" readonly class="form-control" required name="local_id[]" value="<?php echo e($firstLocation->id); ?>">
                            <input readonly class="form-control" required value="<?php echo e($firstLocation->nome); ?>">
                            <input type="hidden" name="novo_estoque" value="1">
                            <?php endif; ?>
                        </td>
                        <td>
                            <input class="form-control quantidade" value="<?php echo e(number_format($l->quantidade, 3)); ?>" required name="quantidade[]">
                        </td>
                    </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php else: ?>
    <div class="col-md-2">
        <?php echo Form::text('quantidade', 'Quantidade')
        ->attrs(['class' => 'quantidade'])->required()
        ->value(isset($item) ? number_format($item->quantidade, 3, '.', '') : ''); ?>

    </div>

    <?php if(__countLocalAtivo() > 1): ?>

    <div class="col-md-3">
        <label for="">Local</label>

        <select required class="select2" data-toggle="select2" name="local_id">
            <option value="">Selecione</option>
            <?php $__currentLoopData = __getLocaisAtivoUsuario(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $local): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option <?php if(isset($item)): ?> <?php if($item->local_id == $local->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($local->id); ?>"><?php echo e($local->descricao); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <?php endif; ?>

    <?php endif; ?>

    <input name="produto_variacao_id" id="produto_variacao_id" type="hidden">
    <hr class="mt-4">
    <div class="col-12" style="text-align: right;">
        <button type="submit" class="btn btn-success px-5" id="btn-store">Salvar</button>
    </div>
</div>
<?php echo $__env->make('modals._variacao', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(function(){
        $('#produto_variacao_id').val('')
    })

    $(document).on("change", "#inp-produto_id", function () {
        $('#produto_variacao_id').val('')

        let product_id = $(this).val()
        $.get(path_url + "api/produtos/find", 
        { 
            produto_id: product_id
        })
        .done((e) => {
            console.log(e)
            let codigo_variacao = $(this).select2('data')[0].codigo_variacao

            if(e.variacao_modelo_id && !codigo_variacao){
                buscarVariacoes(product_id)
            }

            if(codigo_variacao > 0){
                $('#produto_variacao_id').val(codigo_variacao)
            }
        })
        .fail((err) => {
            console.log(err)
        })
    })

    function buscarVariacoes(produto_id){
        $.get(path_url + "api/variacoes/find", { produto_id: produto_id })
        .done((res) => {
            $('#modal_variacao .modal-body').html(res)
            $('#modal_variacao').modal('show')
        })
        .fail((err) => {
            console.log(err)
            swal("Algo deu errado", "Erro ao buscar variações", "error")
        })
    }

    function selecionarVariacao(id, descricao, valor){
        $('#produto_variacao_id').val(id)
        $('#modal_variacao').modal('hide')
    }
</script>
<?php $__env->stopSection(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/estoque/_forms.blade.php ENDPATH**/ ?>