<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <a href="<?php echo e(route('contadores.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Novo Contador
                    </a>

                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-4">
                            <?php echo Form::text('nome', 'Pesquisar por nome'); ?>

                        </div>
                        <div class="col-md-3">
                            <?php echo Form::tel('cpf_cnpj', 'Pesquisar por documento'); ?>

                        </div>
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('contadores.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-centered">
                            <thead class="table-dark">
                                <tr>
                                    <th>Razão social</th>
                                    <th>Nome fantasia</th>
                                    <th>CNPJ/CPF</th>
                                    <th>IE/RG</th>
                                    <th>Status</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item->nome); ?></td>
                                    <td><?php echo e($item->nome_fantasia); ?></td>
                                    <td><?php echo e($item->cpf_cnpj); ?></td>
                                    <td><?php echo e($item->ie); ?></td>
                                    
                                    <td>
                                        <?php if($item->status): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('contadores.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 200px;">
                                            <?php echo method_field('delete'); ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('contadores.edit', [$item->id])); ?>">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                            <?php echo csrf_field(); ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>

                                            <a title="Empresas do contador" class="btn btn-dark btn-sm" href="<?php echo e(route('contadores.show', [$item->id])); ?>">
                                                <i class="ri-play-list-add-fill"></i>
                                            </a>

                                            <a title="Financeiro do contador" class="btn btn-success btn-sm" href="<?php echo e(route('contadores.financeiro', [$item->id])); ?>">
                                                <i class="ri-cash-fill"></i>
                                            </a>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>


            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Contadores'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/contadores/index.blade.php ENDPATH**/ ?>