<?php $__env->startSection('css'); ?>
<style type="text/css">
    input[type="file"] {
        display: none;
    }

    .file-certificado label {
        padding: 8px 8px;
        width: 100%;
        background-color: #8833FF;
        color: #FFF;
        text-transform: uppercase;
        text-align: center;
        display: block;
        margin-top: 20px;
        cursor: pointer;
        border-radius: 5px;
    }

    .card-body strong{
        color: #8833FF;
    }

</style>
<?php $__env->stopSection(); ?>
<div class="row g-2">

    <?php if(isset($diferenca) && $diferenca > 0): ?>
    <div class="col-md-12 mb-3">
        <p class="text-info">Crie uma nova conta à receber ou somente finalize abaixo!</p>
        <a href="<?php echo e(route('conta-receber.index')); ?>" class="btn btn-dark btn-sm px-3">
            <i class="ri-arrow-left-double-fill"></i>Finalizar novo recebimento
        </a>
    </div>
    <?php endif; ?>

    <?php if(__countLocalAtivo() > 1): ?>
    <div class="col-md-2">
        <label for="">Local</label>

        <select id="inp-local_id" required class="select2 class-required" data-toggle="select2" name="local_id">
            <option value="">Selecione</option>
            <?php $__currentLoopData = __getLocaisAtivoUsuario(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $local): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option <?php if(isset($item)): ?> <?php if($item->local_id == $local->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($local->id); ?>"><?php echo e($local->descricao); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <?php else: ?>
    <input id="inp-local_id" type="hidden" value="<?php echo e(__getLocalAtivo() ? __getLocalAtivo()->id : ''); ?>" name="local_id">
    <?php endif; ?>

    <div class="col-md-3">
        <?php echo Form::text('descricao', 'Descrição'); ?>

    </div>
    <div class="col-md-4">
        <label>Cliente</label>
        <div class="input-group flex-nowrap">
            <select id="inp-cliente_id" name="cliente_id" class="cliente_id">
                <?php if(isset($item) && $item->cliente): ?>
                <option value="<?php echo e($item->cliente_id); ?>"><?php echo e($item->cliente->razao_social); ?></option>
                <?php endif; ?>
            </select>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('clientes_create')): ?>
            <button class="btn btn-dark" data-bs-toggle="modal" data-bs-target="#modal_novo_cliente" type="button">
                <i class="ri-add-circle-fill"></i>
            </button>
            <?php endif; ?>
        </div>
    </div>
    <div class="col-md-2">
        <?php echo Form::text('valor_integral', 'Valor Integral')->attrs(['class' => 'moeda'])->value(isset($item) ? __moeda($item->valor_integral) : '')->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::date('data_vencimento', 'Data Vencimento')->required(); ?>

    </div>

    <div class="col-md-2">
        <?php echo Form::select('status', 'Conta Recebida', ['0' => 'Não', '1' => 'Sim'])->attrs(['class' => 'form-select'])->required(); ?>

    </div>

    <div class="col-md-3">
        <?php echo Form::select('tipo_pagamento', 'Tipo Pagamento', App\Models\ContaReceber::tiposPagamento())->attrs(['class' => 'form-select'])->required(); ?>

    </div>
    <div class="col-md-6">
        <?php echo Form::text('observacao', 'Observação'); ?>

    </div>

    <div class="col-md-3 file-certificado">
        <?php echo Form::file('file', 'Procurar arquivo')
        ->attrs(['accept' => '.pdf, image/*']); ?>

        <span class="text-danger" id="filename"></span>
    </div>

    <?php if(isset($item) && $item->arquivo != null): ?>
    <a href="<?php echo e(route('conta-receber.download-file', [$item->id])); ?>">
        <i class="ri-file-download-line"></i>
        Baixar arquivo
    </a>
    <?php endif; ?>

    <hr class="mt-4">

    <?php if(!isset($item)): ?>
    <p class="text-danger">
        * Campo abaixo deve ser preenchido se ouver recorrência para este registro
    </p>

    <div class="col-md-2">
        <?php echo Form::tel('recorrencia', 'Data')
        ->attrs(['data-mask' => '00/00'])
        ->placeholder('mm/aa'); ?>

    </div>
    <?php endif; ?>

    <div class="row tbl-recorrencia d-none mt-2">
    </div>

    <hr class="mt-4">
    <div class="col-12" style="text-align: right;">
        <button type="submit" class="btn btn-success px-5" id="btn-store">Salvar</button>
    </div>
</div>

<?php $__env->startSection('js'); ?>
<script src="/js/novo_cliente.js"></script>
<script>
    $('#inp-recorrencia').blur(() => {
        let data = $('#inp-recorrencia').val()
        if (data.length == 5) {
            let vencimento = $('#inp-data_vencimento').val()
            let valor = $('#inp-valor_integral').val()
            if (valor && vencimento) {
                let item = {
                    data: data, 
                    vencimento: vencimento,
                    valor: valor
                }
                $.get(path_url + 'api/conta-receber/recorrencia', item)
                .done((html) => {
                    $('.tbl-recorrencia').html(html)
                    $('.tbl-recorrencia').removeClass('d-none')

                }).fail((err) => {
                    console.log(err)

                })
            } else {
                swal("Algo saiu errado", "Informe o valor e vencimento data conta base!", "warning")
            }
        } else {
            swal("Algo saiu errado", "Informe uma data válida mm/aa exemplo 12/25", "warning")
        }
    })

</script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/conta-receber/_forms.blade.php ENDPATH**/ ?>