<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-4">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taxa_pagamento_create')): ?>
                    <a href="<?php echo e(route('taxa-cartao.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova Taxa
                    </a>
                    <?php endif; ?>
                </div>
                <hr class="mt-3">
                <div class="col-md-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Tipo Pagamento</th>
                                    <th>Bandeira</th>
                                    <th>Taxa</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->getTipo()); ?></td>
                                    <td><?php echo e($item->bandeira_cartao ? $item->getBandeira() : '--'); ?></td>
                                    <td><?php echo e(__moeda($item->taxa)); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('taxa-cartao.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 100px;">
                                            <?php echo method_field('delete'); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taxa_pagamento_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('taxa-cartao.edit', [$item->id])); ?>">
                                                <i class="ri-edit-line"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php echo csrf_field(); ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('taxa_pagamento_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Taxa de Cartão'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/taxa_cartao/index.blade.php ENDPATH**/ ?>