<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <hr class="mt-3">
                <h5>Histórico do cliente: <strong class="text-primary"><?php echo e($item->info); ?></strong></h5>

                <div id="basicwizard">
                    <ul class="nav nav-pills nav-justified form-wizard-header mb-4 m-2">
                        <li class="nav-item">
                            <a href="#tab-vendas" data-bs-toggle="tab" data-toggle="tab"  class="nav-link rounded-0 py-1"> 
                                <i class="ri-stack-fill fw-normal fs-18 align-middle me-1"></i>
                                <span class="d-none d-sm-inline">Vendas</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#tab-produtos" data-bs-toggle="tab" data-toggle="tab" class="nav-link rounded-0 py-1">
                                <i class="ri-box-3-line fs-18 align-middle me-1"></i>
                                <span class="d-none d-sm-inline">Produtos vendidos</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="#tab-faturas" data-bs-toggle="tab" data-toggle="tab" class="nav-link rounded-0 py-1">
                                <i class="ri-wallet-line fs-18 align-middle me-1"></i>
                                <span class="d-none d-sm-inline">Faturas</span>
                            </a>
                        </li>
                    </ul>
                    <!--  -->
                    <div class="tab-content b-0 mb-0">
                        <div class="tab-pane" id="tab-vendas">

                            <div class="col-md-12 mt-3 table-responsive">
                                <div class="table-responsive-sm">
                                    <table class="table table-striped table-centered mb-0">
                                        <thead class="table-dark">
                                            <tr>
                                                <th>Data</th>
                                                <th>Valor total</th>
                                                <th>Estado</th>
                                                <th>Chave</th>
                                                <th>Número documento</th>
                                                <th>Tipo</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $total = 0; ?>
                                            <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e(__data_pt($c->created_at)); ?></td>
                                                <td><?php echo e(__moeda($c->total)); ?></td>
                                                <td>
                                                    <?php if($c->estado == 'aprovado'): ?>
                                                    <span class="btn btn-success text-white btn-sm w-50">Aprovado</span>
                                                    <?php elseif($c->estado == 'cancelado'): ?>
                                                    <span class="btn btn-danger text-white btn-sm w-50">Cancelado</span>
                                                    <?php elseif($c->estado == 'rejeitado'): ?>
                                                    <span class="btn btn-warning text-white btn-sm w-50">Rejeitado</span>
                                                    <?php else: ?>
                                                    <span class="btn btn-info text-white btn-sm w-50">Novo</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($c->estado == 'aprovado' ? $c->chave : '--'); ?></td>
                                                <td><?php echo e($c->estado == 'aprovado' ? $c->numero : '--'); ?></td>
                                                <td><?php echo e($c->tipo == 'nfce' ? 'PDV NFCe' : 'NFe'); ?></td>
                                            </tr>

                                            <?php $total += $c->total; ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="6" class="text-center">Nada encontrado</td>
                                            </tr>
                                            <?php endif; ?>
                                        </tbody>
                                        <tfoot>
                                            <tr class="bg-dark">
                                                <td class="text-white">Total</td>
                                                <td class="text-white"><?php echo e(__moeda($total)); ?></td>
                                                <td colspan="4"></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--  -->

                    <div class="tab-content b-0 mb-0">
                        <div class="tab-pane" id="tab-produtos">
                            <div class="col-md-12 mt-3 table-responsive">
                                <div class="table-responsive-sm">
                                    <table class="table table-striped table-centered mb-0">
                                        <thead class="table-dark">
                                            <tr>
                                                <th></th>
                                                <th>Produto</th>
                                                <th>Quantidade</th>
                                                <th>Valor unitário</th>
                                                <th>Subtotal</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $produtos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><img class="img-60" src="<?php echo e($p->produto->img); ?>"></td>
                                                <td><?php echo e($p->produto->nome); ?></td>
                                                <td><?php echo e(number_format($p->quantidade, 2)); ?></td>
                                                <td><?php echo e(__moeda($p->valor_unitario)); ?></td>
                                                <td><?php echo e(__moeda($p->quantidade*$p->valor_unitario)); ?></td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!--  -->

                    <div class="tab-content b-0 mb-0">
                        <div class="tab-pane" id="tab-faturas">
                            <div class="col-md-12 mt-3 table-responsive">
                                <div class="table-responsive-sm">
                                    <table class="table table-striped table-centered mb-0">
                                        <thead class="table-dark">
                                            <tr>
                                                <th>Descrição</th>
                                                <th>Data de cadastro</th>
                                                <th>Data de vencimento</th>
                                                <th>Data de recebimento</th>
                                                <th>Valor</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $faturas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($c->descricao); ?></td>
                                                <td><?php echo e(__data_pt($c->created_at)); ?></td>
                                                <td><?php echo e(__data_pt($c->data_vencimento, 0)); ?></td>
                                                <td><?php echo e($c->status ? __data_pt($c->data_recebimento, 0) : '--'); ?></td>
                                                <td><?php echo e(__moeda($c->valor_integral)); ?></td>
                                                <td>
                                                    <?php if($c->status): ?>
                                                    <span class="btn btn-success position-relative me-lg-5 btn-sm">
                                                        <i class="ri-checkbox-line"></i> Recebido
                                                    </span>
                                                    <?php else: ?>
                                                    <span class="btn btn-warning position-relative me-lg-5 btn-sm">
                                                        <i class="ri-alert-line"></i> Pendente
                                                    </span>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="/assets/vendor/twitter-bootstrap-wizard/jquery.bootstrap.wizard.min.js"></script>
<script src="/assets/js/pages/demo.form-wizard.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Histórico do cliente'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/clientes/historico.blade.php ENDPATH**/ ?>