<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <h4>Detalhes da NFCe</h4>
                <div style="text-align: right; margin-top: -35px;">
                    <a href="<?php echo e(route('nfce.index')); ?>" class="btn btn-danger btn-sm px-3">
                        <i class="ri-arrow-left-double-fill"></i>Voltar
                    </a>
                </div>
                <hr class="mt-3">
                <div class="">
                    <h4>Cliente: <strong style="color: steelblue"><?php echo e($data->cliente_id ? $data->cliente->razao_social : 'Consumidor Final'); ?></strong></h4>
                    <h4>Total: <strong class="text-success">R$ <?php echo e(__moeda($data->total)); ?></strong></h4>

                    <?php if(__isPlanoFiscal()): ?>
                    <h4>Data de emissão: <strong><?php echo e(__data_pt($data->data_emissao)); ?></strong></h4>

                    <h4>Estado:
                        <?php if($data->estado == 'aprovado'): ?>
                        <span class="text-success">Aprovado</span>
                        <a href="<?php echo e(route('nfce.download-xml', [$data->id])); ?>" class="btn btn-dark">
                            <i class="ri-file-download-line"></i>
                            Download XML
                        </a>

                        <a class="btn btn-primary" title="Imprimir NFCe" target="_blank" href="<?php echo e(route('nfce.imprimir', [$data->id])); ?>">
                            <i class="ri-printer-line"></i>
                            Imprimir
                        </a>

                        <?php elseif($data->estado == 'cancelado'): ?>
                        <span class="text-danger">Cancelado</span>
                        <?php elseif($data->estado == 'rejeitado'): ?>
                        <span class="text-warning">Rejeitado</span>
                        <?php else: ?>
                        <span class="text-info">Novo</span>
                        <?php endif; ?>
                    </h4>
                    <?php endif; ?>
                </div>
                <hr>
                <div class="col-lg-12 mt-4">
                    <h5>Itens da NFCe</h5>
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Produto</th>
                                    <th>Qtd</th>
                                    <th>Valor</th>
                                    <th>Sub Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->produto->nome); ?></td>
                                    <td><?php echo e($item->quantidade); ?></td>
                                    <td><?php echo e(__moeda($item->valor_unitario)); ?></td>
                                    <td><?php echo e(__moeda($item->sub_total)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="7" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>

                    </div>
                    <div class="col-md-8 col-12 mt-5">
                        <h5>Fatura</h5>
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Pagamento</th>
                                    <th>Data Vencimento</th>
                                    <th>Valor</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data->fatura; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->getTipoPagamento($item->tipo_pagamento)); ?></td>
                                    <td><?php echo e(__data_pt($item->data_vencimento, 0)); ?></td>
                                    <td><?php echo e(__moeda($item->valor)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center">Nfe sem informações de pagamento</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', ['title' => 'Detalhes da NFCe'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/nfce/show.blade.php ENDPATH**/ ?>