<?php $__env->startSection('css'); ?>
<style type="text/css">
	.card-hover:hover{
		cursor: pointer;
	}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="mt-3">
	<div class="row">
		<input value="<?php echo e($item->id); ?>" type="hidden" id="pedido_id">
		<?php if($item->estado == 'novo' || $item->estado == 'aprovado'): ?>
		<div class="col-12 col-lg-4">
			<div class="card">
				<div class="card-body">
					<form class="row" method="post" action="<?php echo e(route('pedidos-delivery.store-item', [$item->id])); ?>">
						<?php echo csrf_field(); ?>

						<input type="hidden" id="tipo_divisao_pizza" value="<?php echo e($config != null ? $config->valor_pizza : 'divide'); ?>">
						<div class="col-md-12">
							<?php echo Form::select('produto_delivery', 'Produto')->required()
							->attrs(['class' => 'produto_delivery']); ?>

						</div>

						<div class="col-md-6 col-12 mt-2">
							<?php echo Form::tel('quantidade', 'Quantidade')
							->required()
							->attrs(['class' => 'moeda']); ?>

						</div>

						<div class="col-md-6 col-12 mt-2">
							<?php echo Form::tel('valor_unitario', 'Valor unitário')
							->required()
							->attrs(['class' => 'moeda']); ?>

						</div>

						<div class="col-md-12 mt-2">
							<button type="button" class="btn w-100 btn-dark" id="btn-adicionais">
								<i class="ri-shopping-basket-fill"></i>
								Definir adicionais
							</button>
						</div>

						<div class="col-md-12 mt-2 adicionaisescolhidos">
						</div>

						<div class="col-md-12 col-12 mt-2">
							<?php echo Form::text('observacao', 'Observação'); ?>

						</div>

						<div class="col-12 mt-2 div-tp-carne d-none">
							<?php echo Form::select('ponto_carne', 'Ponto da carne', ['' => 'Selecione'] +  App\Models\Produto::pontosDaCarne())
							->attrs(['class' => 'form-select']); ?>

						</div>

						<div class="col-md-6 col-12 mt-2">
							<?php echo Form::tel('sub_total', 'Subtotal')
							->required()
							->readonly()
							->attrs(['class' => 'moeda']); ?>

						</div>

						<div class="col-md-6 col-12 mt-2">
							<?php echo Form::select('estado', 'Estado', 
							[
							'novo' => 'Novo', 
							'pendente' => 'Pendente', 
							'preparando' => 'Preparando', 
							'finalizado' => 'Finalizando'
							])
							->attrs(['class' => 'form-select'])
							->required(); ?>

						</div>

						<input type="hidden" id="adicionais-hidden" name="adicionais">
						<input type="hidden" id="pizzas-hidden" name="pizzas">
						<input type="hidden" id="tamanho_id-hidden" name="tamanho_id">
						<div class="col-md-12 col-12 mt-4">
							<button type="submit" class="btn w-100 btn-success">
								<i class="ri-checkbox-circle-fill"></i>
								Adicionar
							</button>
						</div>
					</form>
				</div>
			</div>
		</div>
		<?php endif; ?>

		<div class="col-12 <?php if($item->estado == 'novo' || $item->estado == 'aprovado'): ?> col-lg-8 <?php else: ?> col-lg-12 <?php endif; ?>">
			<div class="card">
				<div class="card-body">
					<div class="col-12">

						<a href="<?php echo e(route('pedidos-delivery.enviar-wpp', [$item->id])); ?>" class="btn btn-sm btn-success">
							<i class="ri-whatsapp-line"></i> Enviar mensagem
						</a>
						<div style="text-align: right; ">
							<a href="<?php echo e(route('pedidos-delivery.index')); ?>" class="btn btn-danger btn-sm px-3">
								<i class="ri-arrow-left-double-fill"></i>Voltar
							</a>
						</div>
						<div class="row">
							<div class="col-12">
								<?php echo $item->_estado(); ?>

							</div>
							<?php if($item->finalizado == 0): ?>
							<form method="post" action="<?php echo e(route('pedidos-delivery.update', [$item->id])); ?>" class="row">
								<div class="col-8 col-lg-4">
									<?php echo csrf_field(); ?>
									<?php echo method_field('put'); ?>

									<?php echo Form::select('estado', 'Estado', 
									[
									'' => 'Selecione',
									'novo' => 'Novo',
									'aprovado' => 'Aprovado',
									'cancelado' => 'Cancelado',
									'finalizado' => 'Finalizado',
									] 
									)->required()
									->attrs(['class' => 'form-select'])
									->value($item->estado); ?>

								</div>
								<div class="col-4 col-lg-4">
									<br>
									<button class="btn btn-dark">
										Alterar estado
										<i class="ri-checkbox-circle-fill"></i>
									</button>
								</div>
							</form>
							<?php endif; ?>

						</div>
					</div>
					<br>
					<h3>ITENS <strong class="text-success">#<?php echo e($item->id); ?></strong></h3>

					<a target="_blank" class="float-end btn btn-dark mb-1" href="<?php echo e(route('pedidos-delivery.print', [$item->id])); ?>">
						<i class="ri-printer-line"></i>
						Imprimir
					</a>
					
					<div class="table-responsive col-12" style="min-height: 300px;">
						<table class="table">
							<thead class="table-light">
								<tr>
									<th>Produto</th>
									<th>Quantidade</th>
									<th>Valor unitário</th>
									<th>Subtotal</th>
									<th>Observação</th>
									<th>Ações</th>
								</tr>
							</thead>
							<tbody>
								<?php $__currentLoopData = $item->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr class="bg-<?php echo e($i->estado); ?>">
									<td><?php echo e($i->produto->nome); ?></td>
									<td><?php echo e(__moeda($i->quantidade)); ?></td>
									<td><?php echo e(__moeda($i->valor_unitario)); ?></td>
									<td><?php echo e(__moeda($i->sub_total)); ?></td>
									<td>
										<?php if($i->observacao == ''): ?>
										<button class="btn btn-sm">
											<i class="ri-sticky-note-line"></i>
										</button>
										<?php else: ?>
										<button class="btn btn-sm btn-dark" onclick="noteSwal('<?php echo e($i->observacao); ?>')">
											<i class="ri-sticky-note-line"></i>
										</button>
										<?php endif; ?>
									</td>
									<td>
										<?php if($item->estado == 'novo' || $item->estado == 'aprovado'): ?>
										<form action="<?php echo e(route('pedidos-delivery.destroy-item', $i->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
											<?php echo csrf_field(); ?>
											<?php echo method_field('delete'); ?>
											<button type="submit" title="Deletar" class="btn btn-danger btn-delete btn-sm"><i class="ri-delete-bin-2-line"></i></button>
										</form>
										<?php endif; ?>
									</td>
								</tr>
								<?php if(sizeof($i->adicionais) > 0): ?>
								<tr>
									<td></td>
									<td colspan="5" style="font-weight: bold; font-size: 13px;">Adicionais: <?php echo e($i->getAdicionaisStr()); ?></td>
								</tr>
								<?php endif; ?>

								<?php if($i->ponto_carne): ?>
								<tr>
									<td></td>
									<td colspan="5" style="font-weight: bold; font-size: 13px;">Ponto da carme: <strong class="text-success"><?php echo e($i->ponto_carne); ?></strong></td>
								</tr>
								<?php endif; ?>

								<?php if(sizeof($i->pizzas) > 0): ?>
								<tr>
									<td></td>
									<td colspan="5" style="font-weight: bold; font-size: 13px;">Sabores: 
										<strong class="text-success">
											<?php $__currentLoopData = $i->pizzas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											1/<?php echo e(sizeof($i->pizzas)); ?> <?php echo e($s->sabor->nome); ?>

											<?php if(!$loop->last): ?>
											|
											<?php endif; ?>
											<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
										</strong>

										<span> - Tamanho: <strong class="text-info"><?php echo e($i->tamanho ? $i->tamanho->nome : '--'); ?></strong></span>
									</td>
								</tr>
								<?php endif; ?>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
							<tfoot>
								<?php if($item->desconto > 0): ?>
								<tr>
									<td>Desconto</td>
									<td colspan="5">-R$ <?php echo e(__moeda($item->desconto)); ?></td>
								</tr>
								<?php endif; ?>
							</tfoot>
						</table>
						
					</div>	

					<div class="row">
						<h5>estados dos itens</h5>
						<div class="col-lg-3 col-6">
							<h6 class="text-novo">
								<i class="ri-flag-2-fill"></i> novo
							</h6>
						</div>

						<div class="col-lg-3 col-6">
							<h6 class="text-pendente">
								<i class="ri-flag-2-fill"></i> pendente
							</h6>
						</div>

						<div class="col-lg-3 col-6">
							<h6 class="text-preparando">
								<i class="ri-flag-2-fill"></i> preparando
							</h6>
						</div>

						<div class="col-lg-3 col-6">
							<h6 class="text-finalizado">
								<i class="ri-flag-2-fill"></i> finalizado
							</h6>
						</div>
					</div>
					<hr>

					<?php if($item->estado == 'novo' || $item->estado == 'aprovado'): ?>
					<?php if($item->endereco): ?>
					<h5 class="text-danger">Endereço de entrega: <strong><?php echo e($item->endereco->info); ?></strong>
						<button data-bs-toggle="modal" data-bs-target="#modal-enderecos" class="btn btn-sm">
							<i class="ri-map-2-fill"></i>
						</button>
					</h5>
					<h5>Valor de entrega: <strong class="text-danger">R$ <?php echo e(__moeda($item->valor_entrega)); ?></strong></h5>
					<h5>Tipo de pagamento: <strong class="text-danger"><?php echo e($item->tipo_pagamento); ?></strong></h5>
					<?php else: ?>
					<h5 class="text-danger"><strong>Retirada no balcão</strong>
						<button data-bs-toggle="modal" data-bs-target="#modal-enderecos" class="btn btn-sm">
							<i class="ri-map-2-fill"></i>
						</button>
					</h5>
					<?php endif; ?>

					<?php if($item->troco_para): ?>
					<h5 class="mt-25 float-end">Troco para: <strong>R$ <?php echo e(__moeda($item->troco_para)); ?></strong></h5>
					<?php endif; ?>

					<?php if($item->motoboy): ?>
					<h5 class="text-primary">Motoboy: <strong><?php echo e($item->motoboy->nome); ?> - R$ <?php echo e(__moeda($item->comissao_motoboy)); ?></strong></h5>
					<?php endif; ?>
					<?php endif; ?>
					<?php if($item->estado == 'novo' || $item->estado == 'aprovado'): ?>
					<div class="col-12">
						<button data-bs-toggle="modal" data-bs-target="#modal-finalizar" class="btn btn-lg btn-primary pull-right <?php if($item->finalizado): ?> disabled <?php endif; ?>">
							<i class="ri-shopping-cart-2-line"></i>
							Finalizar <strong style="font-size: 25px; margin-left: 15px">R$ <?php echo e(__moeda($item->valor_total)); ?></strong>
						</button>
					</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-enderecos" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-xl">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">
					Endereços

					<button class="btn btn-sm btn-success ml-2 btn-novo-endereco" type="button">
						<i class="ri-add-circle-fill"></i>
						Novo endereço
					</button>
				</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="table-responsive">
						<table class="table">
							<thead class="table-dark">
								<tr>
									<th>Endereço</th>
									<th>Padrão</th>
									<th>Valor de entrega</th>
									<th>Ação</th>
								</tr>
							</thead>
							<tbody>
								<?php $__currentLoopData = $cliente->enderecos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($e->info); ?></td>
									<td>
										<?php if($item->padrao): ?>
										<i class="ri-checkbox-circle-fill text-success"></i>
										<?php else: ?>
										<i class="ri-close-circle-fill text-danger"></i>
										<?php endif; ?>
									</td>
									<td><?php echo e(__moeda($e->bairro->valor_entrega)); ?></td>

									<td>
										<form method="post" action="<?php echo e(route('pedidos-delivery.set-endereco', [$item->id])); ?>">
											<input type="hidden" name="endereco_id" value="<?php echo e($e->id); ?>">
											<?php echo csrf_field(); ?>
											<button title="Selecionar endereço" class="btn btn-success btn-sm">
												<i class="ri-check-line"></i>
											</button>
										</form>
									</td>
								</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

								<tr>
									<td>Retirar no balcão</td>
									<td></td>
									<td></td>
									<td>
										<form method="post" action="<?php echo e(route('pedidos-delivery.set-endereco', [$item->id])); ?>">
											<input type="hidden" name="endereco_id" value="">
											<?php echo csrf_field(); ?>
											<button title="Selecionar endereço" class="btn btn-success btn-sm">
												<i class="ri-check-line"></i>
											</button>
										</form>
									</td>
								</tr>
							</tbody>
						</table>
					</div>

				</div>
			</div>
			<div class="modal-footer">
				<button id="" type="button" class="btn btn-danger" data-bs-dismiss="modal">Fechar</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-novo-endereco" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-xl">
		<div class="modal-content">
			<form method="post" action="<?php echo e(route('pedidos-delivery.store-endereco', [$item->id])); ?>">
				<?php echo csrf_field(); ?>
				<div class="modal-header">
					<h5 class="modal-title" id="exampleModalLabel">Novo Endereço</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				</div>
				<div class="modal-body">
					<div class="row g-2">

						<div class="col-md-3">
							<?php echo Form::select('bairro_id', 'Bairro', ['' => 'Selecione'] + $bairros->pluck('info', 'id')->all())->required()
							->attrs(['class' => 'form-select']); ?>

						</div>

						<div class="col-md-4">
							<?php echo Form::text('rua', 'Rua')->required(); ?>

						</div>

						<div class="col-md-2">
							<?php echo Form::text('numero', 'Número')->required(); ?>

						</div>

						<div class="col-md-2">
							<?php echo Form::select('tipo', 'Tipo', ['casa' => 'Casa', 'trabalho' => 'Trabalho'])->required()
							->attrs(['class' => 'form-select']); ?>

						</div>

						<div class="col-md-4">
							<?php echo Form::text('referencia', 'Referência'); ?>

						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="submit" class="btn btn-success" data-bs-dismiss="modal">Salvar</button>
				</div>
			</form>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-finalizar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-md">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Finalizar</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="row">
					<div class="col-md-8">
						<?php echo Form::select('motoboy_id', 'Motoboy', ['' => 'Selecione'] + $motoboys->pluck('info', 'id')->all())
						->attrs(['class' => 'form-select select2'])
						->value($item->motoboy ? $item->motoboy_id : ''); ?>

					</div>

					<div class="col-md-4">
						<?php echo Form::tel('valor_comissao', 'Valor')->attrs(['class' => 'moeda'])
						->value($item->motoboy ? __moeda($item->comissao_motoboy) : ''); ?>

					</div>
				</div>
			</div>
			<div class="modal-footer">
				<button id="btn-finalizar" type="button" class="btn btn-success" data-bs-dismiss="modal">Salvar</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-adicionais" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-xl">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Adicionais</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="row adicionais">


				</div>

				<h4 class="mt-3">Subtotal: <strong class="subtotal_modal"></strong></h4>

			</div>
			<div class="modal-footer">
				<button id="btn-save-modal" type="button" class="btn btn-success" data-bs-dismiss="modal">Salvar</button>
			</div>
		</div>
	</div>
</div>

<div class="modal fade" id="modal-pizza" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
	<div class="modal-dialog modal-xl">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleModalLabel">Selecione os sabores</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<div class="row m-2">
					<p class="text-danger">*selecione o tamanho para buscar os sabores</p>
					<div class="col-md-5 col-6">
						<?php echo Form::select('tamanho_id', 'Tamanho', ['' => 'Selecione'] + 
						$tamanhosPizza->pluck('info', 'id')->all())
						->attrs(['class' => 'form-select']); ?>

					</div>
				</div>
				<div class="row pizzas m-2 mt-4">
				</div>

				<div class="col-md-2 col-6 m-2 mt-3">
					<?php echo Form::tel('subtotal_modal', 'Subtotal')
					->required()
					->attrs(['class' => 'moeda']); ?>

				</div>
			</div>
			<div class="modal-footer">
				<button id="btn-save-sabores" type="button" class="btn btn-success">Salvar</button>
			</div>
		</div>
	</div>
</div>

<form method="get" action="<?php echo e(route('pedidos-delivery.finish', [$item->id])); ?>" id="form-finish">
	<input type="hidden" name="motoboy_id" id="motoboy_id">
	<input type="hidden" name="valor_comissao" id="valor_comissao">
</form>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/pedido_delivery.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Pedido Delivery #' . $item->id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/pedido_delivery/show.blade.php ENDPATH**/ ?>