<?php $__env->startSection('css'); ?>
<style type="text/css">
    .card-title strong{
        color: #159488;
    }

    h4 strong{
        color: #4254BA;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">

                <?php $__currentLoopData = $pagamentosAlterados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <label class="badge <?php if($p['status'] == 'approved'): ?> bg-success <?php else: ?> bg-danger <?php endif; ?> p-2">#<?php echo e($p['hash_pedido']); ?> - <?php echo e($p['status']); ?></label>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::select('cliente_delivery_id', 'Pesquisar por cliente')
                            ->options($cliente != null ? [$cliente->id => ($cliente->razao_social . " - " . $cliente->telefone)] : []); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('estado', 'Estado', ['' => 'Selecione'] + App\Models\PedidoEcommerce::estados())
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('pedidos-ecommerce.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Cliente</th>
                                    <th>Valor total</th>
                                    <th>Valor do frete</th>
                                    <th>Desconto</th>
                                    <th>Qtd. itens</th>
                                    <th>Estado</th>
                                    <th>Data</th>
                                    <th>Tipo de pagamento</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>#<?php echo e($item->hash_pedido); ?></td>
                                    <td><?php echo e($item->cliente->info); ?></td>
                                    <td><?php echo e(__moeda($item->valor_total)); ?></td>
                                    <td><?php echo e(__moeda($item->valor_frete)); ?></td>
                                    <td><?php echo e(__moeda($item->desconto)); ?></td>
                                    <td><?php echo e(sizeof($item->itens)); ?></td>
                                    <td><?php echo $item->_estado(); ?></td>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td><?php echo e(strtoupper($item->tipo_pagamento)); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('pedidos-ecommerce.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <a title="Visualizar" href="<?php echo e(route('pedidos-ecommerce.show', $item->id)); ?>" class="btn btn-dark btn-sm text-white">
                                                <i class="ri-survey-line"></i>
                                            </a>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>

                
            </div>
        </div>
    </div>
</div>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(function(){

    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', ['title' => 'Pedidos de Ecommerce'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/pedido_ecommerce/index.blade.php ENDPATH**/ ?>