<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lista_preco_create')): ?>
                        <a href="<?php echo e(route('lista-preco.create')); ?>" class="btn btn-success">
                            <i class="ri-add-circle-fill"></i>
                            Nova Lista
                        </a>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-6"></div>
                    <div class="col-md-2">
                        <h5>Total de produtos cadastrados: <strong class="text-success"><?php echo e($totalDeProdutos); ?></strong></h5>
                    </div>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::text('nome', 'Pesquisar por nome'); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('tipo_pagamento', 'Tipo de pagamento', ['' => 'Selecione'] + App\Models\ListaPreco::tiposPagamento())->attrs(['class' => 'form-select']); ?>

                        </div>

                        <div class="col-md-3">
                            <?php echo Form::select('funcionario_id', 'Funcionário')
                            ->options((isset($item) && $item->funcionario) ? [$item->funcionario_id => $item->funcionario->nome] : []); ?>

                        </div>
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('lista-preco.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lista_preco_delete')): ?>
                                    <th>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input" type="checkbox" id="select-all-checkbox">
                                        </div>
                                    </th>
                                    <?php endif; ?>
                                    <th style="width: 25%">Nome</th>
                                    <th>Ajuste sobre</th>
                                    <th>Tipo</th>
                                    <th>% Alteração</th>
                                    <th>Data de cadastro</th>
                                    <th>Tipo de pagamento</th>
                                    <th>Funcionario</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lista_preco_delete')): ?>
                                    <td>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input check-delete" type="checkbox" name="item_delete[]" value="<?php echo e($item->id); ?>">
                                        </div>
                                    </td>
                                    <?php endif; ?>
                                    <td><?php echo e($item->nome); ?></td>
                                    <td><?php echo e($item->ajuste_sobre == 'valor_venda' ? 'Valor de venda' : 'Valor de compra'); ?></td>
                                    <td><?php echo e($item->tipo == 'incremento' ? 'Incremento' : 'Redução'); ?></td>
                                    <td><?php echo e($item->percentual_alteracao); ?>%</td>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td><?php echo e($item->tipo_pagamento ? $item->getTipoPagamento() : ''); ?></td>
                                    <td><?php echo e($item->funcionario ? $item->funcionario->nome : ''); ?></td>
                                    <td>
                                        <form style="width: 150px;" action="<?php echo e(route('lista-preco.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lista_preco_edit')): ?>
                                            <a class="btn btn-warning btn-sm text-white" href="<?php echo e(route('lista-preco.edit', [$item->id])); ?>">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php echo csrf_field(); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lista_preco_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <a title="Ver produtos" class="btn btn-dark btn-sm text-white" href="<?php echo e(route('lista-preco.show', [$item->id])); ?>">
                                                <i class="ri-file-list-2-fill"></i>
                                            </a>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <br>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('lista_preco_delete')): ?>
                        <form action="<?php echo e(route('lista-preco.destroy-select')); ?>" method="post" id="form-delete-select">
                            <?php echo method_field('delete'); ?>
                            <?php echo csrf_field(); ?>
                            <div></div>
                            <button type="button" class="btn btn-danger btn-sm btn-delete-all" disabled>
                                <i class="ri-close-circle-line"></i> Remover selecionados
                            </button>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/delete_selecionados.js"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => 'Lista de preços'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/lista_preco/index.blade.php ENDPATH**/ ?>