<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <a href="<?php echo e(route('roles.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova Atribuição
                    </a>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::text('descricao', 'Pesquisar por descrição'); ?>

                        </div>
                        <div class="col-md-3">
                            <?php echo Form::select('empresa', 'Pesquisar por empresa')
                            ->options($empresa ? [$empresa->id => $empresa->nome] : []); ?>

                        </div>
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('roles.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>

                <div class="col-md-12 mt-3 table-responsive">
                    <h5>Total de registros: <strong class="text-success"><?php echo e($data->total()); ?></strong></h5>

                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Nome</th>
                                    <th>Descrição</th>
                                    <th>Empresa</th>
                                    <th>Data de cadastro</th>
                                    <th>Data de atualização</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>

                                    <td><?php echo e($item->name); ?></td>
                                    <td><?php echo e($item->description); ?></td>
                                    <td><?php echo e($item->empresa ? $item->empresa->nome : ''); ?></td>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td><?php echo e(__data_pt($item->updated_at)); ?></td>
                                    <td>
                                        <?php if($item->name != 'gestor_plataforma'): ?>
                                        <form action="<?php echo e(route('roles.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('roles.edit', [$item->id])); ?>">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                            <?php echo csrf_field(); ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <br>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', ['title' => 'Atribuições'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/roles/index.blade.php ENDPATH**/ ?>