<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-2">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfce_view')): ?>
                        <a href="<?php echo e(route('nfce.create')); ?>" class="btn btn-success">
                            <i class="ri-add-circle-fill"></i>
                            Nova NFCe
                        </a>
                        <?php endif; ?>
                    </div>
                    <div class="col-md-8"></div>

                    <div class="col-md-2">
                        <button id="btn-consulta-sefaz" class="btn btn-dark" style="float: right;">
                            <i class="ri-refresh-line"></i>
                            Consultar Status Sefaz
                        </button>
                    </div>
                </div>
                
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-4">
                            <?php echo Form::select('cliente_id', 'Cliente')
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('estado', 'Estado',
                            ['novo' => 'Novas',
                            'rejeitado' => 'Rejeitadas',
                            'cancelado' => 'Canceladas',
                            'aprovado' => 'Aprovadas',
                            '' => 'Todos'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>

                        <?php if(__countLocalAtivo() > 1): ?>
                        <div class="col-md-2">
                            <?php echo Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <?php endif; ?>

                        <div class="col-md-4">
                            <br>

                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('nfce.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>

                <?php if($contigencia != null): ?>
                <div class="row">
                    <div class="col-md-3">
                        <div class="card">
                            <div class="card-body">
                                <h4 class="text-danger">Contigência ativada</h4>
                                <p class="text-danger">Tipo: <strong><?php echo e($contigencia->tipo); ?></strong></p>
                                <p class="text-danger">Data de ínicio: <strong><?php echo e(__data_pt($contigencia->created_at)); ?></strong></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <div class="col-lg-12 mt-4">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>#</th>
                                    <th>Cliente</th>
                                    <th>CPF/CNPJ</th>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <th>Local</th>
                                    <?php endif; ?>
                                    <th>Número</th>
                                    <th>Valor</th>
                                    <th>Estado</th>
                                    <th>Ambiente</th>
                                    <th>Data de cadastro</th>
                                    <th>Data de emissão</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->numero_sequencial); ?></td>
                                    <td><?php echo e($item->cliente ? $item->cliente->razao_social : ($item->cliente_nome != "" ? $item->cliente_nome : "--")); ?></td>
                                    <td><?php echo e($item->cliente ? $item->cliente->cpf_cnpj : ($item->cliente_cpf_cnpj != "" ? $item->cliente_cpf_cnpj : "--")); ?></td>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <td class="text-danger"><?php echo e($item->localizacao->descricao); ?></td>
                                    <?php endif; ?>
                                    <td><?php echo e($item->numero); ?></td>
                                    <td><?php echo e(number_format($item->total, 2, ',', '.')); ?></td>
                                    <td width="150">
                                        <?php if($item->estado == 'aprovado'): ?>
                                        <span class="btn btn-success text-white btn-sm w-100">aprovado</span>
                                        <?php elseif($item->estado == 'cancelado'): ?>
                                        <span class="btn btn-danger text-white btn-sm w-100">cancelado</span>
                                        <?php elseif($item->estado == 'rejeitado'): ?>
                                        <span class="btn btn-warning text-white btn-sm w-100">rejeitado</span>
                                        <?php else: ?>
                                        <span class="btn btn-info text-white btn-sm w-100">novo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->ambiente == 2 ? 'Homologação' : 'Produção'); ?></td>

                                    <td><label style="width: 120px"><?php echo e(__data_pt($item->created_at)); ?></label></td>
                                    <td><label style="width: 120px"><?php echo e(__data_pt($item->data_emissao)); ?></label></td>
                                    <td>
                                        <form action="<?php echo e(route('nfce.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>" style="width: 320px">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>

                                            <?php if($item->estado == 'aprovado'): ?>
                                            <a class="btn btn-primary btn-sm" title="Imprimir NFCe" target="_blank" href="<?php echo e(route('nfce.imprimir', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfce_transmitir')): ?>
                                            <button title="Cancelar NFCe" type="button" class="btn btn-danger btn-sm" onclick="cancelar('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-close-circle-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if($item->estado == 'aprovado' || $item->estado == 'rejeitado'): ?>
                                            <button title="Consultar Chave" type="button" class="btn btn-dark btn-sm" onclick="info('<?php echo e($item->motivo_rejeicao); ?>', '<?php echo e($item->chave); ?>', '<?php echo e($item->estado); ?>', '<?php echo e($item->recibo); ?>')">
                                                <i class="ri-file-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php if($item->estado == 'novo' || $item->estado == 'rejeitado'): ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfce_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('nfce.edit', $item->id)); ?>">
                                                <i class="ri-edit-line"></i>
                                            </a>
                                            <?php endif; ?>

                                            <a title="XML temporário" class="btn btn-light btn-sm" href="<?php echo e(route('nfce.xml-temp', $item->id)); ?>">
                                                <i class="ri-file-line"></i>
                                            </a>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfce_delete')): ?>
                                            <button type="button" class="btn btn-danger btn-sm btn-delete">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfce_transmitir')): ?>
                                            <button title="Transmitir NFCe" type="button" class="btn btn-success btn-sm" onclick="transmitir('<?php echo e($item->id); ?>')">
                                                <i class="ri-send-plane-fill"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php endif; ?>

                                            <?php if($item->estado == 'aprovado' || $item->estado == 'cancelado'): ?>
                                            <button title="Consultar NFCe" type="button" class="btn btn-light btn-sm" onclick="consultar('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-search-eye-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('nfce_edit')): ?>
                                            <a title="Alterar estado fiscal" class="btn btn-danger btn-sm" href="<?php echo e(route('nfce.alterar-estado', $item->id)); ?>">
                                                <i class="ri-arrow-up-down-line"></i>
                                            </a>
                                            <?php endif; ?>
                                            <a class="btn btn-ligth btn-sm" title="Detalhes" href="<?php echo e(route('nfce.show', $item->id)); ?>"><i class="ri-eye-line"></i></a>

                                            <a class="btn btn-danger btn-sm" title="DANFCE Temporária" target="_blank" href="<?php echo e(route('nfce.danfce-temporaria', [$item->id])); ?>">
                                                <i class="ri-printer-fill"></i>
                                            </a>

                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $data->appends(request()->all())->links(); ?>

                </div>
                <h5 class="mt-2">Soma: <strong class="text-success">R$ <?php echo e(__moeda($data->sum('total'))); ?></strong></h5>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-cancelar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Cancelar NFCe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-12">
                        <?php echo Form::text('motivo-cancela', 'Motivo')
                        ->required(); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-cancelar" class="btn btn-danger">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    function info(motivo_rejeicao, chave, estado, recibo) {

        if (estado == 'rejeitado') {
            let text = "Motivo: " + motivo_rejeicao + "\n"
            text += "Chave: " + chave + "\n"
            swal("", text, "warning")
        } else {
            let text = "Chave: " + chave + "\n"
            text += "Recibo: " + recibo + "\n"
            swal("", text, "success")
        }
    }

    $('#btn-consulta-sefaz').click(() => {
        $.post(path_url + 'api/nfce_painel/consulta-status-sefaz', { 
            empresa_id: $('#empresa_id').val(),
            usuario_id: $('#usuario_id').val(),
        })
        .done((res) => {
            let msg = "cStat: " + res.cStat
            msg += "\nMotivo: " + res.xMotivo
            msg += "\nAmbiente: " + (res.tpAmb == 2 ? "Homologação" : "Produção")
            msg += "\nverAplic: " + res.verAplic

            swal("Sucesso", msg, "success")
        })
        .fail((err) => {
            try{
                swal("Erro", err.responseText, "error")
            }catch{
                swal("Erro", "Algo deu errado", "error")
            }
        })
    })

</script>
<script type="text/javascript" src="/js/nfce_transmitir.js"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'NFCe'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/nfce/index.blade.php ENDPATH**/ ?>