<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categoria_servico_create')): ?>
                    <a href="<?php echo e(route('categoria-servico.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova Categoria de Serviço
                    </a>
                    <?php endif; ?>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-3">
                            <?php echo Form::text('nome', 'Pesquisar por nome'); ?>

                        </div>
                        <div class="col-md-3 text-left ">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('categoria-servico.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3 table-responsive">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categoria_servico_delete')): ?>
                                    <th>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input" type="checkbox" id="select-all-checkbox">
                                        </div>
                                    </th>
                                    <?php endif; ?>
                                    <th>Nome</th>
                                    <?php if(__isActivePlan(Auth::user()->empresa, 'Delivery')): ?>
                                    <th>MarketPlace</th>
                                    <?php endif; ?>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categoria_servico_delete')): ?>
                                    <td>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input check-delete" type="checkbox" name="item_delete[]" value="<?php echo e($item->id); ?>">
                                        </div>
                                    </td>
                                    <?php endif; ?>
                                    <td><?php echo e($item->nome); ?></td>
                                    <?php if(__isActivePlan(Auth::user()->empresa, 'Delivery')): ?>
                                    <td>
                                        <?php if($item->marketplace): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <?php endif; ?>
                                    <td>
                                        <form action="<?php echo e(route('categoria-servico.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categoria_servico_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('categoria-servico.edit', [$item->id])); ?>">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php echo csrf_field(); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categoria_servico_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <br>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categoria_servico_delete')): ?>
                        <form action="<?php echo e(route('categoria-servico.destroy-select')); ?>" method="post" id="form-delete-select">
                            <?php echo method_field('delete'); ?>
                            <?php echo csrf_field(); ?>
                            <div></div>
                            <button type="button" class="btn btn-danger btn-sm btn-delete-all" disabled>
                                <i class="ri-close-circle-line"></i> Remover selecionados
                            </button>
                        </form>
                        <?php endif; ?>
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/delete_selecionados.js"></script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', ['title' => 'Categoria de Serviço'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/categoria_servico/index.blade.php ENDPATH**/ ?>