<?php $__env->startSection('content'); ?>

<div class="card mt-1">
    <div class="card-header">
        <h4>Composição do Produto:<strong style="color: royalblue"> <?php echo e($item->nome); ?></strong></h4>
        <div style="text-align: right; margin-top: -35px;">
            <a href="<?php echo e(route('produtos.index')); ?>" class="btn btn-danger btn-sm px-3">
                <i class="ri-arrow-left-double-fill"></i>Voltar
            </a>
        </div>
    </div>
    <div class="card-body">
        <?php echo Form::open()
        ->post()
        ->route('produto-composto.store', [$item->id]); ?>

        <div class="pl-lg-4">
            <div class="row">
                <input type="hidden" name="produto_id" id="" value="<?php echo e($item->id); ?>">
                <div class="col-md-4">
                    <?php echo Form::select('ingrediente_id', 'Selecionar Ingrediente')
                    ->attrs(['class' => 'select2'])->required(); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::text('quantidade', 'Quantidade')->attrs(['class' => ''])->required(); ?>

                </div>
                <div class="row col-12 col-lg-2 mt-3">
                    <br>
                    <button type="submit" class="btn btn-info px-3">
                        <i class="ri-add-line"></i> Adicionar
                    </button>
                </div>
            </div>
        </div>
        <?php echo Form::close(); ?>

        <div class="table-responsive-sm mt-3">
            <table class="table table-striped table-centered mb-0">
                <thead class="table-dark">
                    <tr>
                        <th>Ingredientes</th>
                        <th>Quantidade</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($item->ingrediente->nome); ?></td>
                        <td><?php echo e($item->quantidade); ?></td>
                    <td>
                        <form action="<?php echo e(route('produto-composto.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('delete'); ?>
                            <button type="submit" title="Deletar" class="btn btn-danger btn-sm btn-delete"><i class="ri-delete-bin-2-line"></i></button>
                        </form>
                    </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="text-center">Nada encontrado</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="col-12 mt-4" style="text-align: right;">
            <a href="<?php echo e(route('produtos.index')); ?>" class="btn btn-success px-5" id="btn-store">Finalizar Produto</a>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Composição do produto'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/produtos/composto/composto.blade.php ENDPATH**/ ?>