<?php $__env->startSection('content'); ?>

<div class="card mt-1">
    <div class="card-body">
        <div class="pl-lg-4">
            <div class="">

                <div class="ms">
                    <div class="row">
                        <div class="col-6">
                            <h5>Estado:
                                <?php if($ordem->estado == 'pd'): ?>
                                <span class="btn btn-warning btn-sm">PENDENTE</span>
                                <?php elseif($ordem->estado == 'ap'): ?>
                                <span class="btn btn-success btn-sm">APROVADO</span>
                                <?php elseif($ordem->estado == 'rp'): ?>
                                <span class="btn btn-danger btn-sm">REPROVADO</span>
                                <?php elseif($ordem->estado == 'fz'): ?>
                                <span class="btn btn-info btn-sm">FINALIZADO</span>
                                <?php endif; ?>
                            </h5> 
                        </div>
                        <div class="col-6">

                            <h3 class="text-danger">OS #<?php echo e($ordem->codigo_sequencial); ?></h3>
                        </div>
                    </div>

                    <div class="mt-" style="text-align: right;">
                        <a href="<?php echo e(route('ordem-servico.index')); ?>" class="btn btn-danger btn-sm px-3">
                            <i class="ri-arrow-left-double-fill"></i>Voltar
                        </a>
                    </div>
                    <div class="row mb-2">
                        <div class="col-md-3 col-6">
                            <h5>Início: <strong class="text-primary"><?php echo e(__data_pt($ordem->data_inicio)); ?></strong></h5>
                        </div>

                        <div class="col-md-3 col-6">
                            <h5>Previsão de entrega: <strong class="text-primary"><?php echo e(__data_pt($ordem->data_entrega)); ?></strong></h5>
                        </div>

                        <div class="col-md-3 col-6">
                            <h5>Total: <strong class="text-primary">R$ <?php echo e(__moeda($ordem->valor)); ?></strong> </h5>
                        </div>

                        <div class="col-md-3 col-6">
                            <h5>Usuário responsável: <strong class="text-primary"><?php echo e($ordem->usuario->name); ?></strong></h5>
                        </div>
                    </div>

                    <a href="<?php echo e(route('ordem-servico.alterar-estado', [$ordem->id])); ?>" class="btn btn-info btn-sm" href=""><i class="ri-refresh-line"></i>
                        Alterar estado
                    </a>
                    <a target="_blank" class="btn btn-primary btn-sm" href="<?php echo e(route('ordem-servico.imprimir', $ordem->id)); ?>"><i class="ri-printer-line"></i>
                        Imprimir
                    </a>
                    <?php if($ordem->nfe_id == 0): ?>
                    <a class="btn btn-success btn-sm" href="<?php echo e(route('ordem-servico.gerar-nfe', $ordem->id)); ?>">
                        <i class="ri-file-text-line"></i>
                        Gerar NFe
                    </a>
                    <?php endif; ?>
                    <!-- <h5 class="mt-2">NFSe:
                        <?php if($ordem->nfe_id): ?>   
                        <strong><?php echo e($ordem->nfe_id); ?></strong>
                        <?php else: ?>
                        <strong> -- </strong>
                        <?php endif; ?>
                    </h5> -->
                </div>
            </div>
            <hr class="">
            <div class="card border row">
                <?php echo Form::open()
                ->post()
                ->route('ordem-servico.store-servico'); ?>

                <h3 class="text-center mt-2">Serviços</h3>
                <div class="row m-2 mt-3">
                    <input type="hidden" value="<?php echo e($ordem->id); ?>" name="ordem_servico_id">
                    <div class="col-md-4">
                        <?php echo Form::select('servico_id', 'Serviço', [null => 'Selecione'] + $servicos->pluck('nome', 'id')->all())->attrs(['class' => 'form-select'])->required(); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::tel('quantidade', 'Quantidade')->attrs(['class' => 'moeda'])->required(); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::text('valor', 'Valor unitário')->attrs(['class' => 'moeda'])->required(); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::select('status', 'Status', [0 => 'Pendente', 1 => 'Finalizado'])->attrs(['class' => 'form-select'])->required(); ?>

                    </div>
                    <div class="col-md-2">
                        <br>
                        <button type="submit" class="btn btn-success">
                            <i class="ri-add-line"></i>Adicionar
                        </button>

                    </div>
                </div>
                <?php echo Form::close(); ?>

                <div class="card-body">
                    <div class="table-responsive">
                        <p class="">total de serviços: <strong><?php echo e(sizeof($ordem->servicos)); ?></strong></p>
                        <table class="table mb-0 table-striped table-servico">
                            <thead class="table-dark">
                                <tr>
                                    <th>Serviço</th>
                                    <th>Quantidade</th>
                                    <th>Status</th>
                                    <th>Subtotal</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(isset($ordem)): ?>
                                <?php $__empty_1 = true; $__currentLoopData = $ordem->servicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <input readonly type="text" name="servico[]" class="form-control" value="<?php echo e($item->servico->nome); ?>">
                                    </td>
                                    <td>
                                        <input readonly type="tel" name="servico_quantidade[]" class="form-control" value="<?php echo e($item->quantidade); ?>">
                                    </td>
                                    <td>
                                        <?php if($item->status): ?>
                                        <span class="badge bg-success">FINALIZADO
                                        </span>
                                        <?php else: ?>
                                        <span class="badge bg-warning">PENDENTE
                                        </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <input readonly type="tel" name="valor[]" class="form-control qtd-item" value="<?php echo e(__moeda($item->subtotal)); ?>">
                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('ordem-servico.deletar-servico', $item->id)); ?>" method="post" id="form-servico-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            <a title="Alterar estado" href="<?php echo e(route('ordem-servico.alterar-status-servico', $item->id)); ?>" class="btn btn-sm btn-dark">
                                                <i class="ri-refresh-line"></i>
                                            </a>

                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center">Nenhum registro</td>
                                </tr>
                                <?php endif; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <hr class="mt-3">
            <div class="card border row">
                <?php echo Form::open()
                ->post()
                ->route('ordem-servico.store-produto'); ?>

                <h3 class="text-center mt-2">Produtos</h3>
                <div class="row m-2">
                    <input type="hidden" value="<?php echo e($ordem->id); ?>" name="ordem_servico_id">
                    <div class="col-md-4">
                        <?php echo Form::select('produto_id', 'Produto')->attrs(['class' => ''])->required(); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::tel('quantidade_produto', 'Quantidade')->attrs(['class' => 'moeda'])->required(); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::tel('valor_produto', 'Valor unitário')->attrs(['class' => 'moeda'])->required(); ?>

                    </div>
                    <div class="col-md-2">
                        <br>
                        <?php if(!isset($not_submit)): ?>
                        <button type="submit" class="btn btn-success"><i class=" ri-add-line"></i>Adicionar</button>
                        <?php endif; ?>
                    </div>
                </div>
                <?php echo Form::close(); ?>

                <div class="card-body">
                    <div class="table-responsive">
                        <p class="">total de produtos: <strong><?php echo e(sizeof($ordem->itens)); ?></strong></p>
                        <table class="table mb-0 table-striped table-produto">
                            <thead class="table-dark">
                                <tr>
                                    <th>Produto</th>
                                    <th>Quantidade</th>
                                    <th>Valor</th>
                                    <th>SubTotal</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(isset($ordem)): ?>
                                <?php $__empty_1 = true; $__currentLoopData = $ordem->itens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <input readonly type="text" name="produto[]" class="form-control" value="<?php echo e($item->produto->nome); ?>">
                                    </td>
                                    <td>
                                        <input readonly type="tel" name="produto_quantidade[]" class="form-control" value="<?php echo e($item->quantidade); ?>">
                                    </td>

                                    <td>
                                        <input readonly type="tel" name="total[]" class="form-control qtd-item" value="<?php echo e(__moeda($item->produto->valor_unitario)); ?>">
                                    </td>
                                    <td>
                                        <input readonly type="tel" name="subtotal[]" class="form-control qtd-item" value="<?php echo e(__moeda($item->subtotal)); ?>">
                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('ordem-servico.deletar-produto', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            
                                            <?php echo csrf_field(); ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center">Nenhum registro</td>
                                </tr>
                                <?php endif; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <hr class="mt-3">
            <div class="card border row">

                <h3 class="text-center mt-2">Relatórios:</h3>
                <div class="row m-2">
                    <div class="col-md-3">
                        <a href="<?php echo e(route('ordem-servico.add-relatorio', $ordem->id)); ?>" class="btn btn-success"><i class=" ri-add-line"></i>Adicionar relatório</a>
                    </div>
                    <p class="mt-2">total de relatórios: <strong><?php echo e(sizeof($ordem->relatorios)); ?></strong></p>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table mb-0 table-striped">
                            <thead class="table-dark">
                                <tr>
                                    <th>Data</th>
                                    <th>Usuário</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $ordem->relatorios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td><?php echo e($item->usuario->name); ?></td>
                                    <td>
                                        <form action="<?php echo e(route('ordem-servico.delete-relatorio', $item->id)); ?>" method="post" id="form-relatorio-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            <a href="<?php echo e(route('ordem-servico.edit-relatorio', $item->id)); ?>" title="Editar" class="btn btn-warning btn-sm text-white">
                                                <i class="ri-pencil-fill"></i>
                                            </a>

                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="card border row">
                <h3 class="text-center mt-2">Descrição</h3>

                <div class="card-body">
                    <div class="col-md-12">
                        <?php echo $ordem->descricao; ?>

                    </div>
                </div>
            </div>
        </div>


    </div>
</div>

<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/ordem_servico.js"></script>


<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Ordem de Serviço'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/ordem_servico/show.blade.php ENDPATH**/ ?>