<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-2">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cte_os_create')): ?>
                    <a href="<?php echo e(route('cte-os.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova CTe Os
                    </a>
                    <?php endif; ?>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">

                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Data inicial'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Data final'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('estado', 'Estado',
                            ['novo' => 'Nova',
                            'rejeitado' => 'Rejeitadas',
                            'cancelado' => 'Canceladas',
                            'aprovado' => 'Aprovadas',
                            '' => 'Todos'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>

                        <?php if(__countLocalAtivo() > 1): ?>
                        <div class="col-md-2">
                            <?php echo Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <?php endif; ?>
                        <div class="col-md-2">
                            <br>

                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('cte-os.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3">
                    <div class="table-responsive">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th>Emitente</th>
                                    <th>Tomador</th>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <th>Local</th>
                                    <?php endif; ?>
                                    <th>Valor serviço</th>
                                    <th>Valor a receber</th>
                                    <th>Estado</th>
                                    <th>Data cadastro</th>
                                    <th>Tomador</th>
                                    <th>Nº</th>
                                    <th>Local de emissão</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->emitente ? $item->emitente->razao_social : "--"); ?></td>
                                    <td><?php echo e($item->tomador_cli ? $item->tomador_cli->razao_social : "--"); ?></td>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <td class="text-danger"><?php echo e($item->localizacao ? $item->localizacao->descricao : ''); ?></td>
                                    <?php endif; ?>
                                    <td><?php echo e(__moeda($item->valor_transporte)); ?></td>
                                    <td><?php echo e(__moeda($item->valor_receber)); ?></td>
                                    <td><?php echo $item->estadoEmissao(); ?></td>
                                    <td><?php echo e(__data_pt($item->created_at, 1)); ?></td>
                                    <td><?php echo e($item->getTomador()); ?></td>
                                    <td><?php echo e($item->numero ? $item->numero : '--'); ?></td>
                                    <td>
                                        <?php if($item->api): ?>
                                        <span class="text-success">API</span>
                                        <?php else: ?>
                                        <span class="text-primary">Painel</span>
                                        <?php endif; ?>
                                    </td>
                                    <td width="300">
                                        <form action="<?php echo e(route('cte-os.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php echo csrf_field(); ?>
                                            <?php if($item->estado_emissao == 'cancelado'): ?>
                                            <a class="btn btn-danger btn-sm" target="_blank" href="<?php echo e(route('cte-os.imprimir-cancela', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php if($item->estado_emissao == 'aprovado'): ?>
                                            <a class="btn btn-primary btn-sm" target="_blank" href="<?php echo e(route('cte-os.imprimir', [$item->id])); ?>">
                                                <i class="ri-printer-line"></i>
                                            </a>

                                            <a class="btn btn-light btn-sm" target="_blank" href="<?php echo e(route('cte-os.download', [$item->id])); ?>">
                                                <i class="ri-download-2-fill"></i>
                                            </a>

                                            <button title="Cancelar CTeOs" type="button" class="btn btn-danger btn-sm" onclick="cancelar('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-close-circle-line"></i>
                                            </button>
                                            
                                            <?php endif; ?>

                                            <?php if($item->estado_emissao == 'aprovado' || $item->estado_emissao == 'rejeitado'): ?>
                                            <button type="button" title="Consultar Chave" class="btn btn-dark btn-sm" onclick="info('<?php echo e($item->motivo_rejeicao); ?>', '<?php echo e($item->chave); ?>', '<?php echo e($item->estado); ?>', '<?php echo e($item->recibo); ?>')">
                                                <i class="ri-file-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <?php if($item->estado_emissao == 'novo' || $item->estado_emissao == 'rejeitado'): ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cte_os_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('cte-os.edit', $item->id)); ?>">
                                                <i class="ri-edit-line"></i>
                                            </a>
                                            <?php endif; ?>

                                            <a target="_blank" title="XML temporário" class="btn btn-light btn-sm" href="<?php echo e(route('cte-os.xml-temp', $item->id)); ?>">
                                                <i class="ri-file-line"></i>
                                            </a>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cte_os_delete')): ?>
                                            <button type="button" class="btn btn-danger btn-sm btn-delete"><i class="ri-delete-bin-line"></i></button>
                                            <?php endif; ?>
                                            
                                            <button title="Transmitir CTe" type="button" class="btn btn-success btn-sm" onclick="transmitir('<?php echo e($item->id); ?>')">
                                                <i class="ri-send-plane-fill"></i>
                                            </button>
                                            <?php endif; ?>

                                            <?php if($item->estado_emissao == 'aprovado' || $item->estado_emissao == 'cancelado'): ?>
                                            <button title="Consultar CTe" type="button" class="btn btn-light btn-sm" onclick="consultar('<?php echo e($item->id); ?>', '<?php echo e($item->numero); ?>')">
                                                <i class="ri-file-search-line"></i>
                                            </button>
                                            <?php endif; ?>
                                            <a title="Alterar estado fiscal" class="btn btn-danger btn-sm" href="<?php echo e(route('cte-os.alterar-estado', $item->id)); ?>">
                                                <i class="ri-arrow-up-down-line"></i>
                                            </a>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="11" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo $data->appends(request()->all())->links(); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-cancelar" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Cancelar CTe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-12">
                        <?php echo Form::text('motivo-cancela', 'Motivo')
                        ->required(); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-cancelar" class="btn btn-danger">Cancelar</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="modal-corrigir" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Corrigir CTe <strong class="ref-numero"></strong></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-2">
                        <?php echo Form::select('grupo', 'Grupo')
                        ->attrs(['class' => 'form-select'])->required()
                        ->options(App\Models\Cte::gruposCte()); ?>

                    </div>
                    <div class="col-md-2">
                        <?php echo Form::text('campo', 'Campo')->required(); ?>

                    </div>
                    <div class="col-md-8">
                        <?php echo Form::text('motivo-corrigir', 'Motivo')
                        ->required(); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                <button type="button" id="btn-corrigir" class="btn btn-warning">Corrigir</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    function info(motivo_rejeicao, chave, estado, recibo) {

        if (estado == 'rejeitado') {
            let text = "Motivo: " + motivo_rejeicao + "\n"
            text += "Chave: " + chave + "\n"
            swal("", text, "warning")
        } else {
            let text = "Chave: " + chave + "\n"
            text += "Recibo: " + recibo + "\n"
            swal("", text, "success")
        }
    }

</script>
<script type="text/javascript" src="/js/cte_os_transmitir.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'CTe Os'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/cte_os/index.blade.php ENDPATH**/ ?>