<div class="row g-2">
    <?php if(__countLocalAtivo() > 1): ?>
    <div class="col-md-2">
        <label for="">Local</label>

        <select id="inp-local_id" required class="select2 class-required" data-toggle="select2" name="local_id">
            <option value="">Selecione</option>
            <?php $__currentLoopData = __getLocaisAtivoUsuario(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $local): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option <?php if(isset($item)): ?> <?php if($item->local_id == $local->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($local->id); ?>"><?php echo e($local->descricao); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <?php else: ?>
    <input id="inp-local_id" type="hidden" value="<?php echo e(__getLocalAtivo() ? __getLocalAtivo()->id : ''); ?>" name="local_id">
    <?php endif; ?>
    <div class="col-md-2">
        <?php echo Form::tel('mdfe_numero', 'Número MDFe')
        ->required()
        ->value(isset($item) ? $item->numero : $numeroMDFe); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::select('uf_inicio', 'UF inicial', ['' => 'Selecione...'] + App\Models\Cidade::estados())
        ->attrs(['class' => 'form-select select2'])->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::select('uf_fim', 'UF final', ['' => 'Selecione...'] + App\Models\Cidade::estados())->attrs([
        'class' => 'form-select select2'])->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::date('data_inicio_viagem', 'Data início da viagem')->value(date('Y-m-d'))->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::select('carga_posterior', 'Carga posterior', [0 => 'Não', 1 => 'Sim'])->attrs(
        ['class' => 'form-select'],
        )->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::select(
        'tp_emit',
        'Tipo do emitente',
        ['' => 'Selecione...'] + [
        1 => '1 - Prestador de serviço de transporte',
        2 => '2 - Transportador de carga própria',
        ],
        )->attrs(['class' => 'form-select class-required'])->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::select(
        'tp_transp',
        'Tipo do transportador',
        ['' => 'Selecione...'] + [1 => '1 - ETC', 2 => '2 - TAC', 3 => '3 - CTC'],
        )->attrs(['class' => 'form-select'])->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::select('tipo_modal', 'Tipo modal', ['' => 'Selecione...'] + App\Models\Mdfe::tiposModal())->attrs([
        'class' => 'form-select select2'])->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::text('lac_rodo', 'Lacre rodoviário')->attrs(['data-mask' => '00000000'])->required(); ?>

    </div>
    <div class="col-md-3">
        <?php echo Form::tel('cnpj_contratante', 'CNPJ do contratante')->attrs(['class' => 'cpf_cnpj'])->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::tel('quantidade_carga', 'Quantidade da carga')->attrs(['class' => 'qtd_carga', 'data-mask' => '00000.000', 'data-mask-reverse' => 'true'])->required(); ?>

    </div>
    <div class="col-md-2">
        <?php echo Form::tel('valor_carga', 'Valor da carga')->attrs(['class' => 'moeda'])->required(); ?>

    </div>
    <div class="col-md-3">
        <?php echo Form::select(
        'veiculo_tracao_id',
        'Veículo de tração',
        ['' => 'Selecione...'] + $veiculos->pluck('placa', 'id')->all(),
        )->attrs([
        'class' => 'form-select class-required',
        ])->required(); ?>

    </div>
    <div class="col-md-3">
        <?php echo Form::select(
        'veiculo_reboque_id',
        'Veículo de reboque 1 (opcional)',
        ['' => 'Selecione...'] + $veiculos->pluck('placa', 'id')->all(),
        )->attrs(['class' => 'form-select']); ?>

    </div>
    <div class="col-md-3">
        <?php echo Form::select(
        'veiculo_reboque2_id',
        'Veículo de reboque 2 (opcional)',
        ['' => 'Selecione...'] + $veiculos->pluck('placa', 'id')->all(),
        )->attrs(['class' => 'form-select']); ?>

    </div>
    <div class="col-md-3">
        <?php echo Form::select(
        'veiculo_reboque3_id',
        'Veículo de reboque 3 (opcional)',
        ['' => 'Selecione...'] + $veiculos->pluck('placa', 'id')->all(),
        )->attrs(['class' => 'form-select']); ?>

    </div>
    <hr>
    <div class="row card-body g-3 m-1">
        <h4>Produto predominante (opcional)</h4>
        <div class="col-md-3">
            <?php echo Form::text('produto_pred_nome', 'Nome')->attrs(['class' => '']); ?>

        </div>
        <div class="col-md-2">
            <?php echo Form::tel('produto_pred_ncm', 'NCM')->attrs(['class' => 'ncm']); ?>

        </div>
        <div class="col-md-2">
            <?php echo Form::tel('produto_pred_cod_barras', 'Código de barras')->attrs(['class' => '']); ?>

        </div>
        <div class="col-md-2">
            <?php echo Form::tel('cep_carrega', 'Cep carrega')->attrs(['data-mask' => '00000000']); ?>

        </div>
        <div class="col-md-2">
            <?php echo Form::tel('latitude_carregamento', 'Latitude carrega')->attrs(['class' => '']); ?>

        </div>
        <div class="col-md-2">
            <?php echo Form::tel('longitude_carregamento', 'Longitude carrega')->attrs(['class' => '']); ?>

        </div>
        <div class="col-md-2">
            <?php echo Form::tel('cep_descarrega', 'Cep descarrega')->attrs(['data-mask' => '00000000']); ?>

        </div>
        <div class="col-md-2">
            <?php echo Form::tel('latitude_descarregamento', 'Latitude descarrega')->attrs(['class' => '']); ?>

        </div>
        <div class="col-md-2">
            <?php echo Form::tel('longitude_descarregamento', 'Longitude descarrega')->attrs(['class' => '']); ?>

        </div>
        <div class="col-md-2">
            <?php echo Form::select('tp_carga', 'Tipo de carga', ['' => 'Selecione...'] + App\Models\Mdfe::tiposCarga())->attrs([
            'class' => 'form-select',
            ]); ?>

        </div>
    </div>
    <hr>
    <div class="row mt-4">
        <div class="col-md-4 row">
            <button type="button" class="btn btn-outline-primary btn-gerais active px-6" onclick="selectDiv2('gerais')">INFORMAÇÕES GERAIS</button>
        </div>
        <div class="col-md-4 row ms-auto">
            <button type="button" class="btn btn-outline-primary btn-transporte px-6" onclick="selectDiv2('transporte')">
            INFORMAÇÕES TRANSPORTE</button>
        </div>
        <div class="col-md-4 row m-auto">
            <button type="button" class="btn btn-outline-primary btn-descarregamento px-6" onclick="selectDiv2('descarregamento')">
            INFORMAÇÕES DESCARREGAMENTO</button>
        </div>
    </div>
    <hr>

    <div class="div-gerais row">
        <div class="card">
            <div class="row m-3">
                <h4>Seguradora (opcional)</h4>
                <div class="col-md-4 mt-3">
                    <?php echo Form::text('seguradora_nome', 'Nome da seguradora')->attrs(['class' => '']); ?>

                </div>
                <div class="col-md-3 mt-3">
                    <?php echo Form::tel('seguradora_cnpj', 'CNPJ da seguradora')->attrs(['class' => 'cpf_cnpj']); ?>

                </div>
                <div class="col-md-2 mt-3">
                    <?php echo Form::tel('numero_apolice', 'Número da apólice')->attrs(['class' => '']); ?>

                </div>
                <div class="col-md-2 mt-3">
                    <?php echo Form::tel('numero_averbacao', 'Número da averbação')->attrs(['class' => '']); ?>

                </div>
            </div>
        </div>
        <div class="card col-12 col-md-8">
            <div class="row m-3">
                <div class="col-12 row">
                    <h4>Município(s) de carregamento</h4>
                    <div class="row">
                        <table class="table mb-0 table-striped table-dynamic">
                            <thead class="table-dark">
                                <tr>
                                    <th>Cidade</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody id="body" class="datatable-body">
                                <?php if(isset($item) && sizeof($item->municipiosCarregamento) > 0): ?>
                                <?php $__currentLoopData = $item->municipiosCarregamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mun): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="dynamic-form">
                                    <td class="col-12 col-md-4">
                                        <?php echo Form::select('municipiosCarregamento[]', '', [null => 'Selecione...'] + $cidades->pluck('info', 'id')->all())
                                        ->attrs(['class' => 'select2'])->required()->value($mun->cidade_id); ?>

                                    </td>
                                    <td>
                                        <br>
                                        <button class="btn btn-danger btn-sm btn-remove-tr">
                                            <i class="ri-delete-bin-line"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                <tr class="dynamic-form">
                                    <td class="col-11">
                                        <?php echo Form::select('municipiosCarregamento[]', '', [null => 'Selecione...'] + $cidades->pluck('info', 'id')->all())
                                        ->attrs(['class' => 'select2 class-municipio class-required'])->required(); ?>

                                    </td>
                                    <td>
                                        <br>
                                        <button class="btn btn-danger btn-sm btn-remove-tr">
                                            <i class="ri-delete-bin-line"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <br>
                            <button type="button" class="btn btn-dark btn-add-tr">
                                <i class="ri-add-line"></i>
                                Adicionar
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="card col-12 col-md-4">
            <div class="row">
                <div class="col-12 mt-3">
                    <h4>Percurso</h4>
                    <div class="table-responsive">
                        <table class="table mb-0 table-striped">
                            <thead class="table-dark">
                                <tr>
                                    <th>UF</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody class="datatable-body" id="tbody">
                                <?php if(isset($item) && sizeof($item->percurso) > 0): ?>
                                <?php $__currentLoopData = $item->percurso; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cuf): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="">
                                    <td class="col-10">
                                        <br>
                                        <?php echo Form::select('uf[]', '', ['' => 'Selecione...'] + App\Models\Cidade::estados())
                                        ->attrs(['class' => 'select2']); ?>

                                    </td>
                                    <td>
                                        <br>
                                        <button class="btn btn-danger btn-sm btn-remove-tr">
                                            <i class="ri-delete-bin-line"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                <tr class="">
                                    <td class="col-10">
                                        <br>
                                        <?php echo Form::select('uf[]', '', ['' => 'Selecione...'] + App\Models\Cidade::estados())
                                        ->attrs(['class' => 'select2']); ?>

                                    </td>
                                    <td>
                                        <br>
                                        <button class="btn btn-danger btn-sm btn-remove-tr">
                                            <i class="ri-delete-bin-line"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="row mt-3">
                        <div class="col-12">
                            <button type="button" class="btn btn-dark btn-add-tr">
                                <i class="ri-add-line"></i>
                                Adicionar
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="div-transporte d-none">
        <div class="card">
            <div class="row m-3">
                <h4>CIOT (opcional)</h4>
                <div class="table-responsive mt-2">
                    <table class="table table-dynamic">
                        <thead class="table-dark">
                            <tr>
                                <th>Código CIOT</th>
                                <th>CPF/CNPJ</th>
                                <th>Ação</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(isset($item) && sizeof($item->ciots) > 0): ?>
                            <?php $__currentLoopData = $item->ciots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ciot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="dynamic-form">
                                <td>
                                    <input type="tel" class="form-control codigo_ciot" name="codigo_ciot[]" value="<?php echo e($ciot->codigo); ?>">
                                </td>
                                <td>
                                    <input type="tel" class="form-control cpf_cnpj" name="cpf_cnpj[]" value="<?php echo e($ciot->cpf_cnpj); ?>">
                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-sm btn-remove-tr">
                                        <i class="ri-delete-bin-line"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr class="dynamic-form">
                                <td>
                                    <input type="tel" class="form-control codigo_ciot" name="codigo_ciot[]">
                                </td>
                                <td>
                                    <input type="tel" class="form-control cpf_cnpj" name="cpf_cnpj[]">
                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-sm btn-remove-tr">
                                        <i class="ri-delete-bin-line"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="row">
                    <div class="col-12">
                        <button type="button" class="btn btn-dark btn-add-tr">
                            <i class="ri-add-line"></i>
                            Adicionar
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="row m-3">
                <h4>Vale pedágio (opcional)</h4>
                <div class="table-responsive mt-4">
                    <table class="table table-dynamic">
                        <thead class="table-dark">
                            <tr>
                                <th>CNPJ</th>
                                <th>CPF/CNPJ Pagador</th>
                                <th>Número da compra</th>
                                <th>Valor</th>
                                <th>Ação</th>

                            </tr>
                        </thead>
                        <tbody>
                            <?php if(isset($item) && sizeof($item->valesPedagio) > 0): ?>
                            <?php $__currentLoopData = $item->valesPedagio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="dynamic-form">
                                <td>
                                    <input type="tel" class="form-control cnpj_fornecedor cpf_cnpj" name="cnpj_fornecedor[]" value="<?php echo e($vale->cnpj_fornecedor); ?>">
                                </td>
                                <td>
                                    <input type="tel" class="form-control cnpj_fornecedor_pagador" name="cnpj_fornecedor_pagador[]" value="<?php echo e($vale->cnpj_fornecedor_pagador); ?>">
                                </td>
                                <td>
                                    <input type="tel" class="form-control numero_compra" name="numero_compra[]" value="<?php echo e($vale->numero_compra); ?>">
                                </td>
                                <td>
                                    <input type="tel" class="form-control valor" name="valor_pedagio[]" value="<?php echo e(__moeda($vale->valor)); ?>">
                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-sm btn-remove-tr">
                                        <i class="ri-delete-bin-line"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr class="dynamic-form">
                                <td>
                                    <input type="tel" class="form-control cnpj_fornecedor cpf_cnpj" name="cnpj_fornecedor[]">
                                </td>
                                <td>
                                    <input type="tel" class="form-control cnpj_fornecedor_pagador cpf_cnpj" name="cnpj_fornecedor_pagador[]">
                                </td>
                                <td>
                                    <input type="tel" class="form-control numero_compra" name="numero_compra[]">
                                </td>
                                <td>
                                    <input type="tel" class="form-control valor moeda" name="valor_pedagio[]">
                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-sm btn-remove-tr">
                                        <i class="ri-delete-bin-line"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="row">
                    <div class="col-12">
                        <button type="button" class="btn btn-dark btn-add-tr">
                            <i class="ri-add-line"></i>
                            Adicionar
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="row m-3">
                <h4>Condutor</h4>
                <div class="col-md-3 mt-3">
                    <?php echo Form::text('condutor_nome', 'Nome')->attrs(['class' => 'class-condutor class-required'])->required(); ?>

                </div>
                <div class="col-md-2 mt-3">
                    <?php echo Form::tel('condutor_cpf', 'CPF')->attrs(['class' => 'cpf class-condutor class-required'])->required(); ?>

                </div>
            </div>
        </div>
    </div>
    
    <div class="div-descarregamento d-none">
        <div class="form-descarregamento">
            <div class="card">
                <div class="row m-3">
                    <h4>Informações da unidade de transporte/Documentos fiscais/Lacres</h4>
                    <div class="col-md-3 mt-3">
                        <?php echo Form::select(
                        'tp_unid_transp',
                        'Tipo unidade de transporte', ['' => 'Selecione...'] +
                        App\Models\Mdfe::tiposUnidadeTransporte(),
                        )->attrs(['class' => 'form-select']); ?>

                    </div>
                    <div class="col-md-2 mt-3">
                        <?php echo Form::tel('id_unid_transp', 'ID da Unidade de transporte (placa)')->attrs(['class' => 'placa']); ?>

                    </div>
                    <div class="col-md-2 mt-3">
                        <?php echo Form::tel('quantidade_rateio', 'Quantidade de rateio (transporte)')->attrs(['data-mask' => '000,00']); ?>

                    </div>
                    <div class="col-md-2 mt-3">
                        <?php echo Form::tel('id_unidade_carga', 'ID unidade da carga'); ?>

                    </div>
                    <div class="col-md-3 mt-3">
                        <?php echo Form::tel('quantidade_rateio_carga', 'Quantidade de rateio (unidade carga)')->attrs(['data-mask' => '000,00']); ?>

                    </div>
                </div>
            </div>
            <div class="card">
                <div class="row m-3">
                    <h4>NFe referência</h4>
                    <div class="col-md-5 mt-3">
                        <?php echo Form::tel('chave_nfe', 'NFe referência')->attrs(['class' => 'ignore chave_nfe']); ?>

                    </div>
                    <div class="col-md-5 mt-3">
                        <?php echo Form::tel('seg_cod_nfe', 'Segundo código de barra NFe (contingência)')->attrs(['class' => 'ignore']); ?>

                    </div>
                </div>
            </div>
            <div class="card">
                <div class="row m-3">
                    <h4>CTe referência</h4>
                    <div class="col-md-5 mt-3">
                        <?php echo Form::tel('chave_cte', 'CTe referência')->attrs(['class' => 'ignore chave_nfe']); ?>

                    </div>
                    <div class="col-md-5 mt-3">
                        <?php echo Form::tel('seg_cod_cte', 'Segundo código de barra CTe (contingência)')->attrs(['class' => 'ignore']); ?>

                    </div>
                </div>
            </div>
            <div class="row m-auto">
                <div class="card col-6">
                    <div class="row m-3">
                        <h4>Lacres de transporte</h4>
                        <div class="table-responsive mt-2">
                            <table class="table table-striped table-dynamic table-lacres">
                                <thead class="table-dark">
                                    <tr>
                                        <th></th>
                                        <th style="width: 70%">Número lacre</th>
                                        <th>Ação</th>
                                    </tr>
                                </thead>
                                <tbody id="body" class="datatable-body">
                                    <tr class="dynamic-form">
                                        <td></td>
                                        <td class="col-md-5">
                                            <?php echo Form::tel('numero_transporte[]', '')->attrs(['class' => 'numero_transporte input_lacres']); ?>

                                        </td>
                                        <td>
                                            <br>
                                            <button class="btn btn-danger btn-sm btn-remove-tr">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <button type="button" class="btn btn-dark btn-numero_transporte btn-add-tr">
                                    <i class="ri-add-line"></i>
                                    Adicionar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card col-6">
                    <div class="row m-3">
                        <h4>Lacres da unidade da carga</h4>
                        <div class="table-responsive mt-2">
                            <table class="table table-striped table-dynamic table-lacres-carga">
                                <thead class="table-dark">
                                    <tr>
                                        <th></th>
                                        <th style="width: 70%">Número lacre</th>
                                        <th>Ação</th>
                                    </tr>
                                </thead>
                                <tbody id="body" class="datatable-body">
                                    <tr class="dynamic-form">
                                        <td></td>
                                        <td class="col-md-5">
                                            <?php echo Form::tel('numero_carga[]', '')->attrs(['class' => 'numero_carga input_lacres']); ?>

                                        </td>
                                        <td>
                                            <br>
                                            <button class="btn btn-danger btn-sm btn-remove-tr">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <button type="button" class="btn btn-dark btn-add-tr">
                                    <i class="ri-add-line"></i>
                                    Adicionar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="row m-3">
                    <h4>Município de descarregamento</h4>
                    <div class="col-md-6 mt-3">
                        <?php echo Form::select('municipio_descarregamento', 'Município', ['' => 'Selecione...'] + $cidades->pluck('info', 'id')->all())->attrs(['class' => 'select2']); ?>

                    </div>
                </div>
            </div>
        </div>
        <div class="card">
            <div class="row m-2">
                <h4>Dados do descarregamento</h4>
                <div class="col-md-12 mt-3">
                    <button type="button" class="btn btn-info btn_info_desc">Adicionar informações do
                    descarregamento</button>
                </div>
            </div>
            <div class="table-responsive class-descarregamento mt-4">
                <table class="table table-centered table-descarregamento mb-2 mr-2">
                    <thead class="table-success">
                        <tr>
                            <th>Tipo transporte</th>
                            <th>Id unid transporte</th>
                            <th>Quant rateio</th>
                            <th>Quant rateio carga</th>
                            <th>NFe referência</th>
                            <th>CTe referência</th>
                            <th>Mun descarrega</th>
                            <th>Lacres de transp</th>
                            <th>Lacres unid carga</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody class="" id="">
                        <?php if(isset($item)): ?>
                        <?php $__currentLoopData = $item->infoDescarga; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <input readonly type="sel" name="tp_und_transp_row[]" class="form-control" value="<?php echo e($i->tp_unid_transp); ?>">
                            </td>
                            <td>
                                <input readonly type="text" name="id_und_transp_row[]" class="form-control" value="<?php echo e($i->id_unid_transp); ?>">
                            </td>
                            <td>
                                <input readonly type="tel" name="quantidade_rateio_row[]" class="form-control" value="<?php echo e($i->quantidade_rateio); ?>">
                            </td>
                            <td>
                                <input readonly type="tel" name="quantidade_rateio_carga_row[]" class="form-control" value="<?php echo e($i->unidadeCarga->quantidade_rateio); ?>">
                            </td>
                            <td>
                                <input readonly type="tel" name="chave_nfe_row[]" class="form-control" value="<?php echo e(isset($i->nfe->chave) ? $i->nfe->chave : ''); ?>">
                            </td>
                            <td>
                                <input readonly type="tel" name="chave_cte_row[]" class="form-control" value="<?php echo e(isset($i->cte->chave) ? $i->cte->chave : ''); ?>">
                            </td>
                            <td>
                                <input readonly type="tel" name="municipio_descarregamento" class="form-control" value="<?php echo e($i->cidade->nome); ?>">
                                <input readonly type="hidden" name="municipio_descarregamento_row[]" class="form-control" value="<?php echo e($i->cidade->id); ?>">
                            </td>
                            <td>
                                <input readonly type="tel" name="lacres_transporte_row[]" class="form-control" value="<?php echo e(json_encode($i->lacresTransp->pluck('numero')->toArray())); ?>">
                            </td>
                            <td>
                                <input readonly type="tel" name="lacres_unidade_row[]" class="form-control" value="<?php echo e(json_encode($i->lacresUnidCarga->pluck('numero')->toArray())); ?>">
                            </td>
                            <td>
                                <button class="btn btn-sm btn-danger btn-delete-row">
                                    <i class="ri-delete-bin-line"></i>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <hr>
    <div class="row mt-4 rodape">
        <div class="col-md-6">
            <?php echo Form::text('info_complementar', 'Informação complementar (opcional)'); ?>

        </div>
        <div class="col-md-6">
            <?php echo Form::text('info_adicional_fisco', 'Informação fiscal (opcional)'); ?>

        </div>
        <div class="col-12 alerts mt-4">
        </div>
    </div>

    <div class="col-12" style="text-align: right;">
        <button type="submit" disabled class="btn btn-success btn-salvarMdfe px-5">Salvar</button>
    </div>
</div>

<?php $__env->startSection('js'); ?>
<script src="/js/mdfe.js"></script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/mdfe/_forms.blade.php ENDPATH**/ ?>