<?php $__env->startSection('css'); ?>
<style type="text/css">
    .card-title strong{
        color: #159488;
    }

    h4 strong{
        color: #4254BA;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <hr>
                <button class="btn btn-success px-3" type="button" data-bs-toggle="modal" data-bs-target="#modal-comanda">
                    <i class="ri-add-circle-fill"></i>
                    Abrir comanda
                </button>
                <div class="row mt-3">
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a class="col-12 col-lg-3" href="<?php echo e(route('pedidos-cardapio.show', [$item->id])); ?>">
                        <div class="card">

                            <div class="card-body" style="height: 180px">
                                <h3 class="card-title">Comanda: <strong><?php echo e($item->comanda); ?></strong></h3>

                                <h4>Total: <strong><?php echo e(__moeda($item->total)); ?></strong></h4>
                                <h4>Cliente: <strong><?php echo e($item->cliente_nome != "" ? $item->cliente_nome : 'não identificado'); ?></strong></h4>
                                <h4>Mesa: <strong><?php echo e($item->mesa ? $item->mesa : '--'); ?></strong></h4>

                                <?php if(!$item->em_atendimento): ?>
                                <span class="text-danger">Pedindo para fechar</span>
                                <?php endif; ?>

                            </div>
                            <?php if(__isAdmin() || sizeof($item->itens) == 0): ?>
                            <div class="card-footer">
                                <form action="<?php echo e(route('pedidos-cardapio.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                    <?php echo method_field('delete'); ?>
                                    <?php echo csrf_field(); ?>
                                    <button class="btn btn-danger btn-delete w-100">
                                        Remover comanda
                                    </button>
                                </form>
                                <?php endif; ?>
                                
                            </div>
                        </div>
                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modal-comanda" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <form action="<?php echo e(route('pedidos-cardapio.store')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Abertura de Comanda</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">

                        <div class="col-md-2">
                            <?php echo Form::text('comanda', 'Número comanda')
                            ->required()
                            ->attrs(['data-mask' => 'AAAAAAAA']); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::tel('mesa', 'Mesa'); ?>

                        </div>

                        <div class="col-md-4">
                            <?php echo Form::select('cliente_id', 'Cliente')->attrs(['class' => 'select2']); ?>

                        </div>

                        <div class="col-md-3">
                            <?php echo Form::text('cliente_nome', 'Cliente nome'); ?>

                        </div>

                        <div class="col-md-3">
                            <?php echo Form::text('cliente_fone', 'Cliente telefone')
                            ->attrs(['class' => 'fone']); ?>

                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">Fechar</button>
                    <button type="submit" class="btn btn-success">Abrir</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript">
    $(function(){

        setTimeout(() => {
            $('.modal .select2').each(function () {
                $(this).select2({
                    minimumInputLength: 2,
                    dropdownParent: $(this).parent(),
                    language: "pt-BR",
                    placeholder: "Digite para buscar o cliente",
                    theme: "bootstrap4",

                    ajax: {
                        cache: true,
                        url: path_url + "api/clientes/pesquisa",
                        dataType: "json",
                        data: function (params) {
                            console.clear();
                            var query = {
                                pesquisa: params.term,
                                empresa_id: $("#empresa_id").val(),
                            };
                            return query;
                        },
                        processResults: function (response) {
                            var results = [];

                            $.each(response, function (i, v) {
                                var o = {};
                                o.id = v.id;

                                o.text = v.razao_social + " - " + v.cpf_cnpj;
                                o.value = v.id;
                                results.push(o);
                            });
                            return {
                                results: results,
                            };
                        },
                    },
                });
            });
        }, 10)
    })

    $('body').on('change', '#inp-cliente_id', function () {
        let id = $(this).val()
        $.get(path_url + 'api/clientes/find/'+id)
        .done((success) => {
            $('#inp-cliente_nome').val(success.razao_social)
            $('#inp-cliente_fone').val(success.telefone)
        })
        .fail((err) => {
            console.log(err)
        })
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', ['title' => 'Pedidos (Comandas)'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sophtecc/fazpdv.sophtec.com.br/resources/views/pedidos/index.blade.php ENDPATH**/ ?>